/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.ConstraintListener;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;

public abstract class GlobalConstraint<V extends Variable<V, T>, T extends Value<V, T>>
extends Constraint<V, T> {
    @Override
    public List<V> variables() {
        return this.getModel().variables();
    }

    @Override
    public Collection<V> assignedVariables(Assignment<V, T> assignment) {
        return assignment.assignedVariables();
    }

    @Override
    public int countAssignedVariables(Assignment<V, T> assignment) {
        return assignment.nrAssignedVariables();
    }

    @Override
    public void addVariable(V variable) {
        throw new RuntimeException("A variable cannot be added to a global constraint.");
    }

    @Override
    public void removeVariable(V variable) {
        throw new RuntimeException("A variable cannot be removed from a global constraint.");
    }

    @Override
    public void assigned(Assignment<V, T> assignment, long iteration, T value) {
        HashSet conf = null;
        if (this.isHard()) {
            conf = new HashSet();
            this.computeConflicts(assignment, value, conf);
        }
        if (this.constraintListeners() != null) {
            for (ConstraintListener listener : this.iConstraintListeners) {
                listener.constraintBeforeAssigned(assignment, iteration, this, value, conf);
            }
        }
        if (conf != null) {
            for (Value conflictValue : conf) {
                assignment.unassign(iteration, conflictValue.variable());
            }
        }
        if (this.constraintListeners() != null) {
            for (ConstraintListener listener : this.iConstraintListeners) {
                listener.constraintAfterAssigned(assignment, iteration, this, value, conf);
            }
        }
    }

    @Override
    public void unassigned(Assignment<V, T> assignment, long iteration, T value) {
    }
}

