/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.heuristics;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.heuristics.StandardNeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;

public class RoundRobinNeighbourSelection<V extends Variable<V, T>, T extends Value<V, T>>
extends StandardNeighbourSelection<V, T> {
    protected static Logger sLogger = Logger.getLogger(RoundRobinNeighbourSelection.class);
    protected int iSelectionIdx = -1;
    protected List<NeighbourSelection<V, T>> iSelections = new ArrayList<NeighbourSelection<V, T>>();
    protected Solver<V, T> iSolver = null;

    public RoundRobinNeighbourSelection(DataProperties properties) throws Exception {
        super(properties);
    }

    public void registerSelection(NeighbourSelection<V, T> selection) {
        this.iSelections.add(selection);
    }

    @Override
    public void init(Solver<V, T> solver) {
        super.init(solver);
        this.iSolver = solver;
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        int selectionIndex;
        NeighbourSelection<V, T> selection;
        Neighbour<V, T> neighbour;
        while ((neighbour = (selection = this.iSelections.get(selectionIndex = this.getSelectionIndex())).selectNeighbour(solution)) == null) {
            this.changeSelection(selectionIndex);
        }
        return neighbour;
    }

    public synchronized int getSelectionIndex() {
        if (this.iSelectionIdx == -1) {
            this.iSelectionIdx = 0;
            this.iSelections.get(this.iSelectionIdx).init(this.iSolver);
        }
        return this.iSelectionIdx;
    }

    public synchronized void changeSelection(int selectionIndex) {
        int newSelectionIndex = (1 + selectionIndex) % this.iSelections.size();
        if (newSelectionIndex == this.iSelectionIdx) {
            return;
        }
        this.iSelectionIdx = newSelectionIndex;
        sLogger.debug((Object)("Phase changed to " + (newSelectionIndex + 1)));
        if (this.iSolver.currentSolution().getBestInfo() == null || this.iSolver.getSolutionComparator().isBetterThanBestSolution(this.iSolver.currentSolution())) {
            this.iSolver.currentSolution().saveBest();
        }
        this.iSelections.get(this.iSelectionIdx).init(this.iSolver);
    }
}

