/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.ExtensionWithContext;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;

public class MacPropagation<V extends Variable<V, T>, T extends Value<V, T>>
extends ExtensionWithContext<V, T, NoGood> {
    private static Logger sLogger = Logger.getLogger(MacPropagation.class);
    private boolean iJustForwardCheck = false;
    private Progress iProgress;
    protected List<Constraint<V, T>> iConstraints = null;
    protected long iIteration = 0L;

    public MacPropagation(Solver<V, T> solver, DataProperties properties) {
        super(solver, properties);
        this.iJustForwardCheck = properties.getPropertyBoolean("MacPropagation.JustForwardCheck", false);
    }

    public void addConstraint(Constraint<V, T> constraint) {
        if (this.iConstraints == null) {
            this.iConstraints = new ArrayList<Constraint<V, T>>();
        }
        this.iConstraints.add(constraint);
    }

    public boolean contains(Constraint<V, T> constraint) {
        if (this.iConstraints == null) {
            return true;
        }
        return this.iConstraints.contains(constraint);
    }

    @Override
    public void beforeAssigned(Assignment<V, T> assignment, long iteration, T value) {
        this.iIteration = iteration;
        if (value == null) {
            return;
        }
        if (!this.isGood(assignment, value)) {
            while (!this.isGood(assignment, value) && !this.noGood(assignment, value).isEmpty()) {
                Value noGoodValue = (Value)this.noGood(assignment, value).iterator().next();
                assignment.unassign(iteration, noGoodValue.variable());
            }
        }
        if (!this.isGood(assignment, value)) {
            sLogger.warn((Object)("Going to assign a bad value " + value + " with empty no-good."));
        }
    }

    @Override
    public void afterAssigned(Assignment<V, T> assignment, long iteration, T value) {
        this.iIteration = iteration;
        if (!this.isGood(assignment, value)) {
            sLogger.warn((Object)(((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName() + " -- not good value assigned (noGood:" + this.noGood(assignment, value) + ")"));
            this.setGood(assignment, value);
        }
        HashSet<T> noGood = new HashSet<T>(1);
        noGood.add(value);
        for (Value anotherValue : ((Variable)((Value)value).variable()).values(assignment)) {
            if (anotherValue.equals(value)) continue;
            this.setNoGood(assignment, anotherValue, noGood);
        }
        this.propagate(assignment, ((Value)value).variable());
    }

    @Override
    public void afterUnassigned(Assignment<V, T> assignment, long iteration, T value) {
        this.iIteration = iteration;
        if (!this.isGood(assignment, value)) {
            sLogger.error((Object)(((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName() + " -- not good value unassigned (noGood:" + this.noGood(assignment, value) + ")"));
        }
        for (Value anotherValue : ((Variable)((Value)value).variable()).values(assignment)) {
            if (this.isGood(assignment, anotherValue)) continue;
            Set<T> noGood = anotherValue.conflicts(assignment);
            if (noGood == null) {
                this.setGood(assignment, anotherValue);
                continue;
            }
            this.setNoGood(assignment, anotherValue, noGood);
        }
        this.undoPropagate(assignment, ((Value)value).variable());
    }

    protected void propagate(Assignment<V, T> assignment, V variable) {
        LinkedList queue = new LinkedList();
        if (assignment.getValue(variable) != null) {
            for (Constraint constraint : ((Variable)variable).hardConstraints()) {
                if (!this.contains(constraint)) continue;
                this.propagate(assignment, (Constraint<V, T>)constraint, (V)assignment.getValue(variable), (Queue<V>)queue);
            }
        } else {
            for (Constraint constraint : ((Variable)variable).hardConstraints()) {
                if (!this.contains(constraint)) continue;
                this.propagate(assignment, (Constraint<V, T>)constraint, variable, (Queue<V>)queue);
            }
        }
        if (!this.iJustForwardCheck && !queue.isEmpty()) {
            this.propagate(assignment, queue);
        }
    }

    protected void propagate(Assignment<V, T> assignment, Queue<V> queue) {
        while (!queue.isEmpty()) {
            Variable aVariable = (Variable)queue.poll();
            for (Constraint constraint : aVariable.hardConstraints()) {
                if (!this.contains(constraint)) continue;
                this.propagate(assignment, (Constraint<V, T>)constraint, (V)aVariable, queue);
            }
        }
    }

    public void undoPropagate(Assignment<V, T> assignment, V variable) {
        HashMap undoVars = new HashMap();
        while (!this.supportValues(assignment, variable).isEmpty()) {
            Value value = (Value)this.supportValues(assignment, variable).iterator().next();
            Set<T> noGood = value.conflicts(assignment);
            if (noGood == null) {
                this.setGood(assignment, value);
                ArrayList<Value> values = (ArrayList<Value>)undoVars.get(value.variable());
                if (values == null) {
                    values = new ArrayList<Value>();
                    undoVars.put(value.variable(), values);
                }
                values.add(value);
                continue;
            }
            this.setNoGood(assignment, value, noGood);
            if (!noGood.isEmpty()) continue;
            ((Variable)value.variable()).removeValue(this.iIteration, (Value)value);
        }
        LinkedList queue = new LinkedList();
        for (Variable aVariable : undoVars.keySet()) {
            List values = (List)undoVars.get(aVariable);
            boolean add = false;
            for (Variable x : aVariable.constraintVariables().keySet()) {
                if (!this.propagate(assignment, x, aVariable, values)) continue;
                add = true;
            }
            if (!add) continue;
            queue.add(aVariable);
        }
        for (Variable x : ((Variable)variable).constraintVariables().keySet()) {
            if (!this.propagate(assignment, x, variable) || queue.contains(variable)) continue;
            queue.add(variable);
        }
        if (!this.iJustForwardCheck) {
            this.propagate(assignment, queue);
        }
    }

    protected boolean propagate(Assignment<V, T> assignment, V aVariable, V anotherVariable, List<T> adepts) {
        if (this.goodValues(assignment, aVariable).isEmpty()) {
            return false;
        }
        boolean ret = false;
        List<Value> conflicts = null;
        for (Constraint constraint : ((Variable)anotherVariable).constraintVariables().get(aVariable)) {
            for (Value aValue : this.goodValues(assignment, aVariable)) {
                if ((conflicts = conflicts == null ? this.conflictValues(constraint, aValue, adepts) : this.conflictValues(constraint, aValue, conflicts)) != null && !conflicts.isEmpty()) continue;
                break;
            }
            if (conflicts == null || conflicts.isEmpty()) continue;
            for (Value conflictValue : conflicts) {
                Set<Value> reason = this.reason(assignment, constraint, aVariable, conflictValue);
                this.setNoGood(assignment, conflictValue, reason);
                adepts.remove(conflictValue);
                if (reason.isEmpty()) {
                    ((Variable)conflictValue.variable()).removeValue(this.iIteration, (Value)conflictValue);
                }
                ret = true;
            }
        }
        return ret;
    }

    protected boolean propagate(Assignment<V, T> assignment, V aVariable, V anotherVariable) {
        if (this.goodValues(assignment, anotherVariable).isEmpty()) {
            return false;
        }
        return this.propagate(assignment, aVariable, anotherVariable, new ArrayList<T>(this.goodValues(assignment, anotherVariable)));
    }

    private Set<T> supportValues(Assignment<V, T> assignment, V variable) {
        Set<T>[] ret = ((NoGood)this.getContext(assignment)).getNoGood(variable);
        if (ret == null) {
            ret = new Set[]{new HashSet(1000), new HashSet()};
            ((NoGood)this.getContext(assignment)).setNoGood(variable, ret);
        }
        return ret[0];
    }

    public Set<T> goodValues(Assignment<V, T> assignment, V variable) {
        Set<T>[] ret = ((NoGood)this.getContext(assignment)).getNoGood(variable);
        if (ret == null) {
            ret = new Set[]{new HashSet(1000), new HashSet()};
            ((NoGood)this.getContext(assignment)).setNoGood(variable, ret);
        }
        return ret[1];
    }

    private void goodnessChanged(Assignment<V, T> assignment, T value) {
        if (this.isGood(assignment, value)) {
            this.goodValues(assignment, ((Value)value).variable()).add(value);
        } else {
            this.goodValues(assignment, ((Value)value).variable()).remove(value);
        }
    }

    private void removeSupport(Assignment<V, T> assignment, V variable, T value) {
        this.supportValues(assignment, variable).remove(value);
    }

    private void addSupport(Assignment<V, T> assignment, V variable, T value) {
        this.supportValues(assignment, variable).add(value);
    }

    public Set<T> noGood(Assignment<V, T> assignment, T value) {
        return ((NoGood)this.getContext(assignment)).getNoGood(value);
    }

    public boolean isGood(Assignment<V, T> assignment, T value) {
        return ((NoGood)this.getContext(assignment)).getNoGood(value) == null;
    }

    protected void setGood(Assignment<V, T> assignment, T value) {
        Set noGood = ((NoGood)this.getContext(assignment)).getNoGood(value);
        if (noGood != null) {
            for (Value v : noGood) {
                this.removeSupport(assignment, v.variable(), value);
            }
        }
        ((NoGood)this.getContext(assignment)).setNoGood(value, null);
        this.goodnessChanged(assignment, value);
    }

    private void initNoGood(Assignment<V, T> assignment, T value, Set<T> reason) {
        ((NoGood)this.getContext(assignment)).setNoGood(value, reason);
    }

    public void setNoGood(Assignment<V, T> assignment, T value, Set<T> reason) {
        Set<T> noGood = this.noGood(assignment, value);
        if (noGood != null) {
            for (Value v : noGood) {
                this.removeSupport(assignment, v.variable(), value);
            }
        }
        ((NoGood)this.getContext(assignment)).setNoGood(value, reason);
        for (Value aValue : reason) {
            this.addSupport(assignment, aValue.variable(), value);
        }
        this.goodnessChanged(assignment, value);
    }

    private void propagate(Assignment<V, T> assignment, Constraint<V, T> constraint, T anAssignedValue, Queue<V> queue) {
        HashSet<T> reason = new HashSet<T>(1);
        reason.add(anAssignedValue);
        List<T> conflicts = this.conflictValues(assignment, constraint, (V)anAssignedValue);
        if (conflicts != null && !conflicts.isEmpty()) {
            for (Value conflictValue : conflicts) {
                this.setNoGood(assignment, conflictValue, reason);
                if (queue.contains(conflictValue.variable())) continue;
                queue.add(conflictValue.variable());
            }
        }
    }

    private void propagate(Assignment<V, T> assignment, Constraint<V, T> constraint, V aVariable, Queue<V> queue) {
        if (this.goodValues(assignment, aVariable).isEmpty()) {
            return;
        }
        List<T> conflicts = this.conflictValues(assignment, constraint, aVariable);
        if (conflicts != null && !conflicts.isEmpty()) {
            for (Value conflictValue : conflicts) {
                if (!queue.contains(conflictValue.variable())) {
                    queue.add(conflictValue.variable());
                }
                Set<Value> reason = this.reason(assignment, constraint, aVariable, conflictValue);
                this.setNoGood(assignment, conflictValue, reason);
                if (!reason.isEmpty()) continue;
                ((Variable)conflictValue.variable()).removeValue(this.iIteration, (Value)conflictValue);
            }
        }
    }

    private List<T> conflictValues(Assignment<V, T> assignment, Constraint<V, T> constraint, T aValue) {
        ArrayList<Value> ret = new ArrayList<Value>();
        for (Variable variable : constraint.variables()) {
            if (variable.equals(((Value)aValue).variable()) || assignment.getValue(variable) != null) continue;
            for (Value value : this.goodValues(assignment, variable)) {
                if (constraint.isConsistent((Value)aValue, value)) continue;
                ret.add(value);
            }
        }
        return ret;
    }

    private List<T> conflictValues(Constraint<V, T> constraint, T aValue, List<T> values) {
        ArrayList<Value> ret = new ArrayList<Value>(values.size());
        for (Value value : values) {
            if (constraint.isConsistent((Value)aValue, value)) continue;
            ret.add(value);
        }
        return ret;
    }

    private List<T> conflictValues(Assignment<V, T> assignment, Constraint<V, T> constraint, V aVariable) {
        List<Object> conflicts = null;
        for (Value aValue : this.goodValues(assignment, aVariable)) {
            if ((conflicts = conflicts == null ? this.conflictValues(assignment, constraint, (V)aValue) : this.conflictValues(constraint, aValue, conflicts)) != null && !conflicts.isEmpty()) continue;
            return null;
        }
        return conflicts;
    }

    private Set<T> reason(Assignment<V, T> assignment, Constraint<V, T> constraint, V aVariable, T aValue) {
        HashSet<Value> ret = new HashSet<Value>();
        for (Value value : ((Variable)aVariable).values(assignment)) {
            if (!constraint.isConsistent((Value)aValue, value)) continue;
            if (this.noGood(assignment, value) == null) {
                sLogger.error((Object)("Something went wrong: value " + value + " cannot participate in a reason."));
                continue;
            }
            ret.addAll(this.noGood(assignment, value));
        }
        return ret;
    }

    @Override
    public NoGood createAssignmentContext(Assignment<V, T> assignment) {
        return new NoGood(assignment);
    }

    public class NoGood
    implements AssignmentContext {
        private Map<V, Set<T>[]> iNoGood = new HashMap();
        private Map<V, Map<T, Set<T>>> iNoGoodVal = new HashMap();

        public NoGood(Assignment<V, T> assignment) {
            MacPropagation.this.iProgress = Progress.getInstance(MacPropagation.this.getModel());
            MacPropagation.this.iProgress.save();
            MacPropagation.this.iProgress.setPhase("Initializing propagation:", 3 * MacPropagation.this.getModel().variables().size());
            for (Variable aVariable : MacPropagation.this.getModel().variables()) {
                MacPropagation.this.supportValues(assignment, aVariable).clear();
                MacPropagation.this.goodValues(assignment, aVariable).clear();
            }
            for (Variable aVariable : MacPropagation.this.getModel().variables()) {
                for (Value aValue : aVariable.values(assignment)) {
                    Set noGood = aValue.conflicts(assignment);
                    MacPropagation.this.initNoGood(assignment, aValue, noGood);
                    if (noGood != null) continue;
                    MacPropagation.this.goodValues(assignment, aVariable).add(aValue);
                }
                MacPropagation.this.iProgress.incProgress();
            }
            LinkedList queue = new LinkedList();
            for (Variable aVariable : MacPropagation.this.getModel().variables()) {
                for (Constraint constraint : aVariable.hardConstraints()) {
                    MacPropagation.this.propagate((Assignment<V, T>)assignment, (Constraint<V, T>)constraint, (V)aVariable, (Queue<V>)queue);
                }
                MacPropagation.this.iProgress.incProgress();
            }
            if (!MacPropagation.this.iJustForwardCheck) {
                MacPropagation.this.propagate(assignment, queue);
            }
            for (Variable aVariable : MacPropagation.this.getModel().variables()) {
                ArrayList<Value> values2delete = new ArrayList<Value>();
                for (Value aValue : aVariable.values(assignment)) {
                    if (MacPropagation.this.isGood(assignment, aValue) || !MacPropagation.this.noGood(assignment, aValue).isEmpty()) continue;
                    values2delete.add(aValue);
                }
                for (Value val : values2delete) {
                    aVariable.removeValue(0L, val);
                }
                if (aVariable.values(assignment).isEmpty()) {
                    sLogger.error((Object)(aVariable.getName() + " has empty domain!"));
                }
                MacPropagation.this.iProgress.incProgress();
            }
            MacPropagation.this.iProgress.restore();
        }

        public Set<T>[] getNoGood(V variable) {
            return this.iNoGood.get(variable);
        }

        public void setNoGood(V variable, Set<T>[] noGood) {
            if (noGood == null) {
                this.iNoGood.remove(variable);
            } else {
                this.iNoGood.put((Set<T>[])variable, noGood);
            }
        }

        public Set<T> getNoGood(T value) {
            Map ng = this.iNoGoodVal.get(((Value)value).variable());
            if (ng == null) {
                return null;
            }
            return ng.get(value);
        }

        public void setNoGood(T value, Set<T> noGood) {
            Map ng = this.iNoGoodVal.get(((Value)value).variable());
            if (ng == null) {
                ng = new HashMap();
                this.iNoGoodVal.put((Map)((Value)value).variable(), ng);
            }
            if (noGood == null) {
                ng.remove(value);
            } else {
                ng.put(value, noGood);
            }
        }
    }
}

