/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.example.tt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.example.tt.Activity;
import org.cpsolver.ifs.example.tt.Dependence;
import org.cpsolver.ifs.example.tt.Location;
import org.cpsolver.ifs.example.tt.Resource;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class TimetableModel
extends Model<Activity, Location> {
    private static Logger sLogger = Logger.getLogger(TimetableModel.class);
    private int iNrDays;
    private int iNrHours;

    public TimetableModel(int nrDays, int nrHours) {
        this.iNrDays = nrDays;
        this.iNrHours = nrHours;
    }

    public int getNrDays() {
        return this.iNrDays;
    }

    public int getNrHours() {
        return this.iNrHours;
    }

    /*
     * WARNING - void declaration
     */
    public static TimetableModel generate(DataProperties cfg, Assignment<Activity, Location> assignment) {
        int forcedPerturbances;
        int i;
        int aclass;
        int i2;
        int j;
        int r;
        int nrDays = cfg.getPropertyInt("Generator.NrDays", 5);
        int nrHours = cfg.getPropertyInt("Generator.NrHours", 20);
        int nrSlots = nrDays * nrHours;
        TimetableModel m = new TimetableModel(nrDays, nrHours);
        int nrRooms = cfg.getPropertyInt("Generator.NrRooms", 20);
        int nrInstructors = cfg.getPropertyInt("Generator.NrInstructors", 20);
        int nrClasses = cfg.getPropertyInt("Generator.NrClasses", 20);
        int nrGroupsOfRooms = cfg.getPropertyInt("Generator.NrGroupsOfRooms", 20);
        int nrRoomsInGroupMin = cfg.getPropertyInt("Generator.NrRoomsInGroupMin", 1);
        int nrRoomsInGroupMax = cfg.getPropertyInt("Generator.NrRoomsInGroupMax", 10);
        int nrRoomInGroupMin = cfg.getPropertyInt("Generator.NrRoomInGroupMin", 1);
        double fillFactor = cfg.getPropertyDouble("Generator.FillFactor", 0.8);
        int maxLength = cfg.getPropertyInt("Generator.ActivityLengthMax", 5);
        double hardFreeResource = cfg.getPropertyDouble("Generator.HardFreeResource", 0.05);
        double softFreeResource = cfg.getPropertyDouble("Generator.SoftFreeResource", 0.3);
        double softUsedResource = cfg.getPropertyDouble("Generator.SoftUsedResource", 0.05);
        double softUsedActivity = cfg.getPropertyDouble("Generator.SoftUsedActivity", 0.05);
        double softFreeActivity = cfg.getPropertyDouble("Generator.SoftFreeActivity", 0.3);
        double hardFreeActivity = cfg.getPropertyDouble("Generator.HardFreeActivity", 0.05);
        int nrDependencies = cfg.getPropertyInt("Generator.NrDependencies", 50);
        Resource[] rooms = new Resource[nrRooms];
        ArrayList[] groupForRoom = new ArrayList[nrRooms];
        for (int i4 = 0; i4 < nrRooms; ++i4) {
            rooms[i4] = new Resource("r" + (i4 + 1), 0, "Room " + (i4 + 1));
            groupForRoom[i4] = new ArrayList();
            m.addConstraint(rooms[i4]);
        }
        ArrayList[] groupOfRooms = new ArrayList[nrGroupsOfRooms];
        for (int i3 = 0; i3 < nrGroupsOfRooms; ++i3) {
            groupOfRooms[i3] = new ArrayList();
            for (int j2 = 0; j2 < ToolBox.random(1 + nrRoomsInGroupMax - nrRoomsInGroupMin) + nrRoomsInGroupMin; ++j2) {
                r = 0;
                while (groupOfRooms[i3].contains(rooms[r = ToolBox.random(nrRooms)])) {
                }
                groupOfRooms[i3].add(rooms[r]);
                groupForRoom[r].add(groupOfRooms[i3]);
            }
        }
        for (int i3 = 0; i3 < nrRooms; ++i3) {
            int cnt = 0;
            for (int j3 = 0; j3 < nrGroupsOfRooms; ++j3) {
                if (!groupOfRooms[j3].contains(rooms[i3])) continue;
                ++cnt;
            }
            while (cnt < nrRoomInGroupMin) {
                r = 0;
                while (groupOfRooms[r = ToolBox.random(nrGroupsOfRooms)].contains(rooms[i3])) {
                }
                groupOfRooms[r].add(rooms[i3]);
                groupForRoom[i3].add(groupOfRooms[r]);
                ++cnt;
            }
        }
        Resource[] instructors = new Resource[nrInstructors];
        for (int i5 = 0; i5 < nrInstructors; ++i5) {
            instructors[i5] = new Resource("t" + (i5 + 1), 1, "Teacher " + (i5 + 1));
            m.addConstraint(instructors[i5]);
        }
        Resource[] classes = new Resource[nrClasses];
        for (int i6 = 0; i6 < nrClasses; ++i6) {
            classes[i6] = new Resource("c" + (i6 + 1), 2, "Class " + (i6 + 1));
            m.addConstraint(classes[i6]);
        }
        int[][] timetable4room = new int[nrRooms][nrSlots];
        int[][] timetable4instr = new int[nrInstructors][nrSlots];
        int[][] timetable4class = new int[nrClasses][nrSlots];
        int act = 0;
        for (int i22 = 0; i22 < timetable4room.length; ++i22) {
            for (j = 0; j < timetable4room[i22].length; ++j) {
                timetable4room[i22][j] = 0;
            }
        }
        for (i2 = 0; i2 < timetable4instr.length; ++i2) {
            for (j = 0; j < timetable4instr[i2].length; ++j) {
                timetable4instr[i2][j] = 0;
            }
        }
        for (i2 = 0; i2 < timetable4class.length; ++i2) {
            for (j = 0; j < timetable4class[i2].length; ++j) {
                timetable4class[i2][j] = 0;
            }
        }
        int totalSlots = nrRooms * nrSlots;
        int usedSlots = 0;
        ArrayList<Integer> starts = new ArrayList<Integer>();
        ArrayList<Integer> arooms = new ArrayList<Integer>();
        while ((double)usedSlots / (double)totalSlots < fillFactor) {
            int len;
            int attempt = 0;
            int slot = ToolBox.random(nrSlots);
            int room = ToolBox.random(nrRooms);
            while (attempt < 500 && timetable4room[room][slot] != 0) {
                slot = ToolBox.random(nrSlots);
                room = ToolBox.random(nrRooms);
            }
            if (attempt == 500) {
                int s = slot;
                int r2 = room;
                while (timetable4room[r2][s] != 0) {
                    if (++r2 == nrRooms) {
                        r2 = 0;
                    }
                    if (r2 == room) {
                        ++s;
                    }
                    if (s != nrSlots) continue;
                    s = 0;
                }
                slot = s;
                room = r2;
            }
            int length = maxLength;
            aclass = ToolBox.random(nrClasses);
            int instr = ToolBox.random(nrInstructors);
            attempt = 0;
            while (attempt < 500 && (timetable4class[aclass][slot] != 0 || timetable4instr[instr][slot] != 0)) {
                aclass = ToolBox.random(nrClasses);
                instr = ToolBox.random(nrInstructors);
            }
            if (attempt == 500) continue;
            for (len = 1; len < length && (slot + len) % nrHours != 0 && timetable4room[room][slot + len] == 0 && timetable4instr[instr][slot + len] == 0 && timetable4class[aclass][slot + len] == 0; ++len) {
            }
            ArrayList roomGr = (ArrayList)ToolBox.random(groupForRoom[room]);
            usedSlots += len;
            Activity a = new Activity(len, "a" + ++act, "Activity " + act);
            a.addResourceGroup(roomGr);
            a.addResourceGroup(instructors[instr]);
            a.addResourceGroup(classes[aclass]);
            m.addVariable(a);
            starts.add(slot);
            arooms.add(room);
            for (int i7 = slot; i7 < slot + len; ++i7) {
                timetable4room[room][i7] = act;
                timetable4instr[instr][i7] = act;
                timetable4class[aclass][i7] = act;
            }
        }
        int nrHardFreeRes = 0;
        int nrSoftFreeRes = 0;
        int nrSoftUsedRes = 0;
        for (int slot = 0; slot < nrSlots; ++slot) {
            for (int room = 0; room < nrRooms; ++room) {
                if (timetable4room[room][slot] == 0) {
                    if (ToolBox.random() < hardFreeResource) {
                        ++nrHardFreeRes;
                        rooms[room].addProhibitedSlot(slot);
                        continue;
                    }
                    if (!(ToolBox.random() < softFreeResource / (1.0 - hardFreeResource))) continue;
                    ++nrSoftFreeRes;
                    rooms[room].addDiscouragedSlot(slot);
                    continue;
                }
                if (!(ToolBox.random() < softUsedResource)) continue;
                ++nrSoftUsedRes;
                rooms[room].addDiscouragedSlot(slot);
            }
            for (int instr = 0; instr < nrInstructors; ++instr) {
                if (timetable4instr[instr][slot] == 0) {
                    if (ToolBox.random() < hardFreeResource) {
                        ++nrHardFreeRes;
                        instructors[instr].addProhibitedSlot(slot);
                        continue;
                    }
                    if (!(ToolBox.random() < softFreeResource / (1.0 - hardFreeResource))) continue;
                    ++nrSoftFreeRes;
                    instructors[instr].addDiscouragedSlot(slot);
                    continue;
                }
                if (!(ToolBox.random() < softUsedResource)) continue;
                ++nrSoftUsedRes;
                instructors[instr].addDiscouragedSlot(slot);
            }
            for (aclass = 0; aclass < nrClasses; ++aclass) {
                if (timetable4class[aclass][slot] == 0) {
                    if (ToolBox.random() < hardFreeResource) {
                        ++nrHardFreeRes;
                        classes[aclass].addProhibitedSlot(slot);
                        continue;
                    }
                    if (!(ToolBox.random() < softFreeResource / (1.0 - hardFreeResource))) continue;
                    ++nrSoftFreeRes;
                    classes[aclass].addDiscouragedSlot(slot);
                    continue;
                }
                if (!(ToolBox.random() < softUsedResource)) continue;
                ++nrSoftUsedRes;
                classes[aclass].addDiscouragedSlot(slot);
            }
        }
        int nrSoftFreeAct = 0;
        int nrSoftUsedAct = 0;
        int nrHardFreeAct = 0;
        for (i = 0; i < m.variables().size(); ++i) {
            Activity activity = (Activity)m.variables().get(i);
            for (int slot = 0; slot < nrSlots; ++slot) {
                int start = (Integer)starts.get(i);
                if (slot < start || slot >= start + activity.getLength()) {
                    if (ToolBox.random() < hardFreeActivity) {
                        ++nrHardFreeAct;
                        activity.addProhibitedSlot(slot);
                        continue;
                    }
                    if (!(ToolBox.random() < softFreeActivity / (1.0 - hardFreeActivity))) continue;
                    ++nrSoftFreeAct;
                    activity.addDiscouragedSlot(slot);
                    continue;
                }
                if (!(ToolBox.random() < softUsedActivity)) continue;
                ++nrSoftUsedAct;
                activity.addDiscouragedSlot(slot);
            }
            activity.init();
        }
        i = 0;
        while (i < nrDependencies) {
            void var55_65;
            int ac1 = ToolBox.random(m.variables().size());
            int ac2 = ToolBox.random(m.variables().size());
            while (ac1 == ac2) {
                ac2 = ToolBox.random(m.variables().size());
            }
            int s1 = (Integer)starts.get(ac1);
            int s2 = (Integer)starts.get(ac2);
            Activity a1 = (Activity)m.variables().get(ac1);
            Activity a2 = (Activity)m.variables().get(ac2);
            Object var55_66 = null;
            if (s1 < s2) {
                if (s1 + a1.getLength() == s2) {
                    Dependence dependence = new Dependence("d" + (i + 1), 2);
                } else if (s1 + a1.getLength() < s2) {
                    Dependence dependence = new Dependence("d" + (i + 1), 1);
                }
            } else if (s2 == s1 + a1.getLength()) {
                Dependence dependence = new Dependence("d" + (i + 1), 4);
            } else if (s2 > s1 + a1.getLength()) {
                Dependence dependence = new Dependence("d" + (i + 1), 3);
            }
            if (var55_65 == null) continue;
            var55_65.addVariable(a1);
            var55_65.addVariable(a2);
            m.addConstraint(var55_65);
            ++i;
        }
        for (i = 0; i < m.variables().size(); ++i) {
            Activity activity = (Activity)m.variables().get(i);
            int start = (Integer)starts.get(i);
            int room = (Integer)arooms.get(i);
            Location location = null;
            for (Location l : activity.values(assignment)) {
                if (l.getSlot() != start || !l.getResource(0).getResourceId().equals("r" + (room + 1))) continue;
                location = l;
                break;
            }
            if (location != null) {
                Set<Object> conflicts = m.conflictValues(assignment, location);
                if (!conflicts.isEmpty()) {
                    sLogger.warn((Object)("Unable to assign " + location.getName() + " to " + activity.getName() + ", reason:"));
                    for (Constraint<Activity, Location> constraint : activity.constraints()) {
                        HashSet cc = new HashSet();
                        constraint.computeConflicts(assignment, location, cc);
                        if (cc.isEmpty()) continue;
                        sLogger.warn((Object)("  -- Constraint " + constraint.getName() + " causes conflicts " + cc));
                    }
                } else {
                    assignment.assign(0L, location);
                    activity.setInitialAssignment(location);
                }
                activity.setInitialAssignment(location);
                continue;
            }
            sLogger.warn((Object)("Unable to assign " + activity.getName() + " -- no location matching slot=" + start + " room='R" + (room + 1) + "'"));
        }
        if (!cfg.getPropertyBoolean("General.InitialAssignment", true)) {
            for (i = 0; i < m.variables().size(); ++i) {
                Activity activity = (Activity)m.variables().get(i);
                assignment.unassign(0L, activity);
            }
        }
        if ((forcedPerturbances = cfg.getPropertyInt("General.ForcedPerturbances", 0)) > 0) {
            ArrayList<Activity> initialVariables = new ArrayList<Activity>();
            for (Activity v : m.variables()) {
                if (v.getInitialAssignment() == null) continue;
                initialVariables.add(v);
            }
            for (int i8 = 0; i8 < forcedPerturbances && !initialVariables.isEmpty(); ++i8) {
                Activity var = (Activity)ToolBox.random(initialVariables);
                initialVariables.remove(var);
                var.removeInitialValue();
            }
        }
        sLogger.debug((Object)"-- Generator Info ---------------------------------------------------------");
        sLogger.debug((Object)("  Total number of " + m.variables().size() + " activities generated."));
        sLogger.debug((Object)("  Total number of " + usedSlots + " slots are filled (" + 100.0 * (double)usedSlots / (double)totalSlots + "% filled)."));
        sLogger.debug((Object)("  Average length of an activity is " + (double)usedSlots / (double)m.variables().size()));
        sLogger.debug((Object)("  Total number of hard constraints posted on free slots on activities: " + nrHardFreeAct));
        sLogger.debug((Object)("  Total number of soft constraints posted on free slots on activities: " + nrSoftFreeAct));
        sLogger.debug((Object)("  Total number of soft constraints posted on used slots on activities: " + nrSoftUsedAct));
        sLogger.debug((Object)("  Total number of hard constraints posted on free slots on resources: " + nrHardFreeRes));
        sLogger.debug((Object)("  Total number of soft constraints posted on free slots on resources: " + nrSoftFreeRes));
        sLogger.debug((Object)("  Total number of soft constraints posted on used slots on resources: " + nrSoftUsedRes));
        sLogger.debug((Object)("  Total number of " + nrDependencies + " dependencies generated."));
        sLogger.debug((Object)"---------------------------------------------------------------------------");
        return m;
    }

    public static void main(String[] args) {
        try {
            BasicConfigurator.configure();
            DataProperties properties = new DataProperties();
            properties.load(new FileInputStream(args[0]));
            DefaultSingleAssignment<Activity, Location> assignment = new DefaultSingleAssignment<Activity, Location>();
            TimetableModel model = TimetableModel.generate(new DataProperties(), assignment);
            System.out.println(model.getInfo(assignment));
            model.saveAsXML(properties, true, new Solution<Activity, Location>(model, assignment), assignment, new File(args[1]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveAsXML(DataProperties cfg, boolean gen, Solution<Activity, Location> solution, Assignment<Activity, Location> assignment, File outFile) throws IOException {
        Element pref;
        Element el;
        outFile.getParentFile().mkdirs();
        sLogger.debug((Object)("Writting XML data to:" + outFile));
        Document document = DocumentHelper.createDocument();
        document.addComment("Interactive Timetabling - University Timetable Generator (version 2.0)");
        if (assignment == null && solution != null) {
            assignment = solution.getAssignment();
        }
        if (assignment == null) {
            assignment = new DefaultSingleAssignment<Activity, Location>();
        }
        if (!this.assignedVariables(assignment).isEmpty()) {
            StringBuffer comments = new StringBuffer("Solution Info:\n");
            Map<String, String> solutionInfo = solution == null ? this.getInfo(assignment) : solution.getInfo();
            for (String key : new TreeSet<String>(solutionInfo.keySet())) {
                String value = solutionInfo.get(key);
                comments.append("    " + key + ": " + value + "\n");
            }
            document.addComment(comments.toString());
        }
        Element root = document.addElement("Timetable");
        if (gen) {
            Element generator = root.addElement("Generator");
            generator.addAttribute("version", "2.0");
            generator.addElement("DaysPerWeek").setText(String.valueOf(this.iNrDays));
            generator.addElement("SlotsPerDay").setText(String.valueOf(this.iNrHours));
            generator.addElement("NrRooms").setText(cfg.getProperty("Generator.NrRooms", "20"));
            generator.addElement("NrInstructors").setText(cfg.getProperty("Generator.NrInstructors", "20"));
            generator.addElement("NrClasses").setText(cfg.getProperty("Generator.NrClasses", "20"));
            generator.addElement("FillFactor").setText(cfg.getProperty("Generator.FillFactor", "0.8"));
            generator.addElement("ActivityLengthMax").setText(cfg.getProperty("Generator.ActivityLengthMax", "5"));
            generator.addElement("NrGroupsOfRooms").setText(cfg.getProperty("Generator.NrGroupsOfRooms", "20"));
            generator.addElement("NrRoomsInGroupMin").setText(cfg.getProperty("Generator.NrRoomsInGroupMin", "1"));
            generator.addElement("NrRoomsInGroupMax").setText(cfg.getProperty("Generator.NrRoomsInGroupMax", "10"));
            generator.addElement("NrRoomInGroupMin").setText(cfg.getProperty("Generator.NrRoomInGroupMin", "1"));
            generator.addElement("HardFreeResource").setText(cfg.getProperty("Generator.HardFreeResource", "0.05"));
            generator.addElement("SoftFreeResource").setText(cfg.getProperty("Generator.SoftFreeResource", "0.3"));
            generator.addElement("SoftUsedResource").setText(cfg.getProperty("Generator.SoftUsedResource", "0.05"));
            generator.addElement("SoftUsedActivity").setText(cfg.getProperty("Generator.SoftUsedActivity", "0.05"));
            generator.addElement("SoftFreeActivity").setText(cfg.getProperty("Generator.SoftFreeActivity", "0.3"));
            generator.addElement("HardFreeActivity").setText(cfg.getProperty("Generator.HardFreeActivity", "0.05"));
            generator.addElement("NrDependencies").setText(cfg.getProperty("Generator.NrDependencies", "50"));
        }
        ArrayList<Resource> rooms = new ArrayList<Resource>();
        ArrayList<Resource> classes = new ArrayList<Resource>();
        ArrayList<Resource> instructors = new ArrayList<Resource>();
        ArrayList<Resource> specials = new ArrayList<Resource>();
        ArrayList<Dependence> dependencies = new ArrayList<Dependence>();
        for (Constraint c : this.constraints()) {
            if (c instanceof Resource) {
                Resource r = (Resource)c;
                switch (r.getType()) {
                    case 0: {
                        rooms.add(r);
                        break;
                    }
                    case 2: {
                        classes.add(r);
                        break;
                    }
                    case 1: {
                        instructors.add(r);
                        break;
                    }
                    default: {
                        specials.add(r);
                        break;
                    }
                }
                continue;
            }
            if (!(c instanceof Dependence)) continue;
            dependencies.add((Dependence)c);
        }
        Element problem = root.addElement("Problem");
        problem.addAttribute("version", "2.0");
        Element problemGen = problem.addElement("General");
        problemGen.addElement("DaysPerWeek").setText(String.valueOf(this.iNrDays));
        problemGen.addElement("SlotsPerDay").setText(String.valueOf(this.iNrHours));
        Element resourceGen = problemGen.addElement("Resources");
        resourceGen.addElement("Classrooms").setText(String.valueOf(rooms.size()));
        resourceGen.addElement("Teachers").setText(String.valueOf(instructors.size()));
        resourceGen.addElement("Classes").setText(String.valueOf(classes.size()));
        resourceGen.addElement("Special").setText(String.valueOf(specials.size()));
        problemGen.addElement("Activities").setText(String.valueOf(this.variables().size()));
        problemGen.addElement("Dependences").setText(String.valueOf(dependencies.size()));
        Element resources = problem.addElement("Resources");
        Element resEl = resources.addElement("Classrooms");
        for (Resource r : rooms) {
            el = resEl.addElement("Resource");
            el.addAttribute("id", r.getResourceId());
            el.addElement("Name").setText(r.getName());
            pref = el.addElement("TimePreferences");
            for (Integer slot : new TreeSet<Integer>(r.getDiscouragedSlots())) {
                pref.addElement("Soft").setText(slot.toString());
            }
            for (Integer slot : new TreeSet<Integer>(r.getProhibitedSlots())) {
                pref.addElement("Hard").setText(slot.toString());
            }
        }
        resEl = resources.addElement("Teachers");
        for (Resource r : instructors) {
            el = resEl.addElement("Resource");
            el.addAttribute("id", r.getResourceId());
            el.addElement("Name").setText(r.getName());
            pref = el.addElement("TimePreferences");
            for (Integer slot : new TreeSet<Integer>(r.getDiscouragedSlots())) {
                pref.addElement("Soft").setText(slot.toString());
            }
            for (Integer slot : new TreeSet<Integer>(r.getProhibitedSlots())) {
                pref.addElement("Hard").setText(slot.toString());
            }
        }
        resEl = resources.addElement("Classes");
        for (Resource r : classes) {
            el = resEl.addElement("Resource");
            el.addAttribute("id", r.getResourceId());
            el.addElement("Name").setText(r.getName());
            pref = el.addElement("TimePreferences");
            for (Integer slot : new TreeSet<Integer>(r.getDiscouragedSlots())) {
                pref.addElement("Soft").setText(slot.toString());
            }
            for (Integer slot : new TreeSet<Integer>(r.getProhibitedSlots())) {
                pref.addElement("Hard").setText(slot.toString());
            }
        }
        resEl = resources.addElement("Special");
        for (Resource r : specials) {
            el = resEl.addElement("Resource");
            el.addAttribute("id", r.getResourceId());
            el.addElement("Name").setText(r.getName());
            pref = el.addElement("TimePreferences");
            for (Integer slot : new TreeSet<Integer>(r.getDiscouragedSlots())) {
                pref.addElement("Soft").setText(slot.toString());
            }
            for (Integer slot : new TreeSet<Integer>(r.getProhibitedSlots())) {
                pref.addElement("Hard").setText(slot.toString());
            }
        }
        boolean hasSolution = false;
        Element actEl = problem.addElement("Activities");
        for (Activity a : this.variables()) {
            Element el2 = actEl.addElement("Activity");
            el2.addAttribute("id", a.getActivityId());
            el2.addElement("Name").setText(a.getName());
            el2.addElement("Length").setText(String.valueOf(a.getLength()));
            if (assignment.getValue(a) != null) {
                hasSolution = true;
            }
            Element pref2 = el2.addElement("TimePreferences");
            for (Integer slot : new TreeSet<Integer>(a.getDiscouragedSlots())) {
                pref2.addElement("Soft").setText(slot.toString());
            }
            for (Integer slot : new TreeSet<Integer>(a.getProhibitedSlots())) {
                pref2.addElement("Hard").setText(slot.toString());
            }
            Element reqRes = el2.addElement("RequiredResources");
            for (List<Resource> gr : a.getResourceGroups()) {
                if (gr.size() == 1) {
                    reqRes.addElement("Resource").setText(gr.get(0).getResourceId());
                    continue;
                }
                Element grEl = reqRes.addElement("Group").addAttribute("conjunctive", "no");
                for (Resource r : gr) {
                    grEl.addElement("Resource").setText(r.getResourceId());
                }
            }
        }
        Element depEl = problem.addElement("Dependences");
        block31: for (Dependence d : dependencies) {
            Element el3 = depEl.addElement("Dependence");
            el3.addAttribute("id", d.getResourceId());
            el3.addElement("FirstActivity").setText(((Activity)d.first()).getActivityId());
            el3.addElement("SecondActivity").setText(((Activity)d.second()).getActivityId());
            switch (d.getType()) {
                case 3: {
                    el3.addElement("Operator").setText("After");
                    continue block31;
                }
                case 1: {
                    el3.addElement("Operator").setText("Before");
                    continue block31;
                }
                case 2: {
                    el3.addElement("Operator").setText("Closely before");
                    continue block31;
                }
                case 4: {
                    el3.addElement("Operator").setText("Closely after");
                    continue block31;
                }
                case 5: {
                    el3.addElement("Operator").setText("Concurrently");
                    continue block31;
                }
            }
            el3.addElement("Operator").setText("Unknown");
        }
        if (hasSolution) {
            Element solutionEl = root.addElement("Solution");
            solutionEl.addAttribute("version", "2.0");
            for (Activity a : this.variables()) {
                Element el4 = solutionEl.addElement("Activity");
                el4.addAttribute("id", a.getActivityId());
                Location location = assignment.getValue(a);
                if (location == null) continue;
                el4.addElement("StartTime").setText(String.valueOf(location.getSlot()));
                Element res = el4.addElement("UsedResources");
                for (int i = 0; i < location.getResources().length; ++i) {
                    res.addElement("Resource").setText(location.getResources()[i].getResourceId());
                }
            }
        }
        FileOutputStream fos = new FileOutputStream(outFile);
        new XMLWriter((OutputStream)fos, OutputFormat.createPrettyPrint()).write(document);
        fos.flush();
        fos.close();
    }

    public static TimetableModel loadFromXML(File inFile, Assignment<Activity, Location> assignment) throws IOException, DocumentException {
        Iterator j;
        Element pref;
        Resource r;
        Element el;
        Document document = new SAXReader().read(inFile);
        Element root = document.getRootElement();
        if (!"Timetable".equals(root.getName())) {
            sLogger.error((Object)"Given XML file is not interactive timetabling problem.");
            return null;
        }
        Element problem = root.element("Problem");
        Element problemGen = problem.element("General");
        TimetableModel m = new TimetableModel(Integer.parseInt(problemGen.elementText("DaysPerWeek")), Integer.parseInt(problemGen.elementText("SlotsPerDay")));
        Element resources = problem.element("Resources");
        HashMap<String, Resource> resTab = new HashMap<String, Resource>();
        Element resEl = resources.element("Classrooms");
        Iterator i = resEl.elementIterator("Resource");
        while (i.hasNext()) {
            el = (Element)i.next();
            r = new Resource(el.attributeValue("id"), 0, el.elementText("Name"));
            pref = el.element("TimePreferences");
            j = pref.elementIterator("Soft");
            while (j.hasNext()) {
                r.addDiscouragedSlot(Integer.parseInt(((Element)j.next()).getText()));
            }
            j = pref.elementIterator("Hard");
            while (j.hasNext()) {
                r.addProhibitedSlot(Integer.parseInt(((Element)j.next()).getText()));
            }
            m.addConstraint(r);
            resTab.put(r.getResourceId(), r);
        }
        resEl = resources.element("Teachers");
        i = resEl.elementIterator("Resource");
        while (i.hasNext()) {
            el = (Element)i.next();
            r = new Resource(el.attributeValue("id"), 1, el.elementText("Name"));
            pref = el.element("TimePreferences");
            j = pref.elementIterator("Soft");
            while (j.hasNext()) {
                r.addDiscouragedSlot(Integer.parseInt(((Element)j.next()).getText()));
            }
            j = pref.elementIterator("Hard");
            while (j.hasNext()) {
                r.addProhibitedSlot(Integer.parseInt(((Element)j.next()).getText()));
            }
            m.addConstraint(r);
            resTab.put(r.getResourceId(), r);
        }
        resEl = resources.element("Classes");
        i = resEl.elementIterator("Resource");
        while (i.hasNext()) {
            el = (Element)i.next();
            r = new Resource(el.attributeValue("id"), 2, el.elementText("Name"));
            pref = el.element("TimePreferences");
            j = pref.elementIterator("Soft");
            while (j.hasNext()) {
                r.addDiscouragedSlot(Integer.parseInt(((Element)j.next()).getText()));
            }
            j = pref.elementIterator("Hard");
            while (j.hasNext()) {
                r.addProhibitedSlot(Integer.parseInt(((Element)j.next()).getText()));
            }
            m.addConstraint(r);
            resTab.put(r.getResourceId(), r);
        }
        resEl = resources.element("Special");
        i = resEl.elementIterator("Resource");
        while (i.hasNext()) {
            el = (Element)i.next();
            r = new Resource(el.attributeValue("id"), 3, el.elementText("Name"));
            pref = el.element("TimePreferences");
            j = pref.elementIterator("Soft");
            while (j.hasNext()) {
                r.addDiscouragedSlot(Integer.parseInt(((Element)j.next()).getText()));
            }
            j = pref.elementIterator("Hard");
            while (j.hasNext()) {
                r.addProhibitedSlot(Integer.parseInt(((Element)j.next()).getText()));
            }
            m.addConstraint(r);
            resTab.put(r.getResourceId(), r);
        }
        Element actEl = problem.element("Activities");
        HashMap<String, Activity> actTab = new HashMap<String, Activity>();
        Iterator i2 = actEl.elementIterator("Activity");
        while (i2.hasNext()) {
            Element el2 = (Element)i2.next();
            Activity a = new Activity(Integer.parseInt(el2.elementText("Length")), el2.attributeValue("id"), el2.elementText("Name"));
            Element pref2 = el2.element("TimePreferences");
            Iterator j2 = pref2.elementIterator("Soft");
            while (j2.hasNext()) {
                a.addDiscouragedSlot(Integer.parseInt(((Element)j2.next()).getText()));
            }
            j2 = pref2.elementIterator("Hard");
            while (j2.hasNext()) {
                a.addProhibitedSlot(Integer.parseInt(((Element)j2.next()).getText()));
            }
            Element req = el2.element("RequiredResources");
            Iterator j3 = req.elementIterator();
            while (j3.hasNext()) {
                Element rqEl = (Element)j3.next();
                if ("Resource".equals(rqEl.getName())) {
                    a.addResourceGroup((Resource)resTab.get(rqEl.getText()));
                    continue;
                }
                if (!"Group".equals(rqEl.getName())) continue;
                if ("no".equalsIgnoreCase(rqEl.attributeValue("conjunctive")) || "false".equalsIgnoreCase(rqEl.attributeValue("conjunctive"))) {
                    ArrayList<Resource> gr = new ArrayList<Resource>();
                    Iterator k = rqEl.elementIterator("Resource");
                    while (k.hasNext()) {
                        gr.add((Resource)resTab.get(((Element)k.next()).getText()));
                    }
                    a.addResourceGroup(gr);
                    continue;
                }
                Iterator k = rqEl.elementIterator("Resource");
                while (k.hasNext()) {
                    a.addResourceGroup((Resource)resTab.get(((Element)k.next()).getText()));
                }
            }
            m.addVariable(a);
            a.init();
            actTab.put(a.getActivityId(), a);
        }
        Element depEl = problem.element("Dependences");
        Iterator i3 = depEl.elementIterator("Dependence");
        while (i3.hasNext()) {
            Element el3 = (Element)i3.next();
            int type = 0;
            String typeStr = el3.elementText("Operator");
            if ("After".equals(typeStr)) {
                type = 3;
            } else if ("Before".equals(typeStr)) {
                type = 1;
            } else if ("After".equals(typeStr)) {
                type = 3;
            } else if ("Closely before".equals(typeStr)) {
                type = 2;
            } else if ("Closely after".equals(typeStr)) {
                type = 4;
            } else if ("Concurrently".equals(typeStr)) {
                type = 5;
            }
            Dependence d = new Dependence(el3.attributeValue("id"), type);
            d.addVariable((Variable)actTab.get(el3.elementText("FirstActivity")));
            d.addVariable((Variable)actTab.get(el3.elementText("SecondActivity")));
            m.addConstraint(d);
        }
        Element solEl = root.element("Solution");
        if (solEl != null) {
            Iterator i4 = solEl.elementIterator("Activity");
            block19: while (i4.hasNext()) {
                Element el4 = (Element)i4.next();
                Activity a = (Activity)actTab.get(el4.attributeValue("id"));
                if (a == null) continue;
                int slot = Integer.parseInt(el4.elementText("StartTime"));
                Element usResEl = el4.element("UsedResources");
                ArrayList res = new ArrayList();
                Iterator j4 = usResEl.elementIterator("Resource");
                while (j4.hasNext()) {
                    res.add(resTab.get(((Element)j4.next()).getText()));
                }
                for (Location loc : a.values(assignment)) {
                    if (loc.getSlot() != slot || loc.getResources().length != res.size()) continue;
                    boolean same = true;
                    for (int j5 = 0; j5 < loc.getResources().length && same; ++j5) {
                        if (((Resource)res.get(j5)).equals(loc.getResources()[j5])) continue;
                        same = false;
                    }
                    if (!same) continue;
                    a.setInitialAssignment(loc);
                    if (assignment == null) continue block19;
                    assignment.assign(0L, loc);
                    continue block19;
                }
            }
        }
        return m;
    }
}

