/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.dbt;

import org.cpsolver.ifs.dbt.DbtPropagation;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.heuristics.VariableSelection;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class DbtVariableSelection<V extends Variable<V, T>, T extends Value<V, T>>
implements VariableSelection<V, T> {
    private DbtPropagation<V, T> iProp = null;

    public DbtVariableSelection(DataProperties properties) {
    }

    @Override
    public void init(Solver<V, T> solver) {
        for (Extension<V, T> extension : solver.getExtensions()) {
            if (!(extension instanceof DbtPropagation)) continue;
            this.iProp = (DbtPropagation)extension;
        }
    }

    @Override
    public V selectVariable(Solution<V, T> solution) {
        if (solution.getAssignment().nrAssignedVariables() == solution.getModel().variables().size()) {
            return null;
        }
        if (this.iProp != null) {
            for (Variable variable : solution.getAssignment().unassignedVariables(solution.getModel())) {
                if (!this.iProp.goodValues(solution.getAssignment(), variable).isEmpty()) continue;
                return (V)variable;
            }
        }
        return (V)((Variable)ToolBox.random(solution.getAssignment().unassignedVariables(solution.getModel())));
    }
}

