/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.dbt;

import java.util.HashSet;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.extension.MacPropagation;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.solver.SolverListener;
import org.cpsolver.ifs.util.DataProperties;

public class DbtPropagation<V extends Variable<V, T>, T extends Value<V, T>>
extends MacPropagation<V, T>
implements SolverListener<V, T> {
    private static Logger sLogger = Logger.getLogger(DbtPropagation.class);

    public DbtPropagation(Solver<V, T> solver, DataProperties properties) {
        super(solver, properties);
        solver.addSolverListener(this);
    }

    @Override
    public void afterAssigned(Assignment<V, T> assignment, long iteration, T value) {
        this.iIteration = iteration;
        if (!this.isGood(assignment, value)) {
            sLogger.warn((Object)(((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName() + " -- not good value assigned (noGood:" + this.noGood(assignment, value) + ")"));
            this.setGood(assignment, value);
        }
        HashSet<T> noGood = new HashSet<T>(1);
        noGood.add(value);
        for (Value anotherValue : ((Variable)((Value)value).variable()).values(assignment)) {
            if (anotherValue.equals(value) || !this.isGood(assignment, anotherValue)) continue;
            this.setNoGood(assignment, anotherValue, noGood);
        }
        this.propagate(assignment, ((Value)value).variable());
    }

    @Override
    public void afterUnassigned(Assignment<V, T> assignment, long iteration, T value) {
        this.iIteration = iteration;
        if (!this.isGood(assignment, value)) {
            sLogger.error((Object)(((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName() + " -- not good value unassigned (noGood:" + this.noGood(assignment, value) + ")"));
        }
        this.undoPropagate(assignment, ((Value)value).variable());
    }

    @Override
    public boolean variableSelected(Assignment<V, T> assignment, long iteration, V variable) {
        if (variable == null) {
            sLogger.debug((Object)"No variable selected -> backtrack.");
            Variable lastVariable = null;
            for (Variable var : assignment.assignedVariables()) {
                if (lastVariable != null && assignment.getIteration(lastVariable) >= assignment.getIteration(var)) continue;
                lastVariable = var;
            }
            if (lastVariable == null) {
                sLogger.error((Object)"No assignment -> fail");
                this.getSolver().stopSolver();
                return false;
            }
            sLogger.debug((Object)("Unassign:" + lastVariable.getName()));
            HashSet<T> noGoods = new HashSet<T>();
            for (Variable var : assignment.assignedVariables()) {
                if (var.equals(lastVariable)) continue;
                noGoods.add(assignment.getValue(var));
            }
            T value = assignment.getValue(lastVariable);
            assignment.unassign(iteration, lastVariable);
            this.setNoGood(assignment, value, noGoods);
            return false;
        }
        if (assignment.getValue((Variable)variable) != null) {
            sLogger.error((Object)"Assigned value selected -- not supported by DBT.");
            return false;
        }
        return true;
    }

    @Override
    public boolean valueSelected(Assignment<V, T> assignment, long iteration, V variable, T value) {
        if (variable != null && value == null) {
            HashSet<Value> noGoods = new HashSet<Value>();
            for (Value val : ((Variable)variable).values(assignment)) {
                if (this.noGood(assignment, val) == null) continue;
                noGoods.addAll(this.noGood(assignment, val));
            }
            if (noGoods.isEmpty()) {
                sLogger.debug((Object)"Fail");
                this.getSolver().stopSolver();
                return false;
            }
            Object lastVariable = null;
            for (Value val : noGoods) {
                Object var = val.variable();
                if (lastVariable != null && assignment.getIteration(lastVariable) >= assignment.getIteration(var)) continue;
                lastVariable = var;
            }
            T current = assignment.getValue(lastVariable);
            noGoods.remove(current);
            assignment.unassign(iteration, lastVariable);
            this.setNoGood(assignment, current, noGoods);
        }
        return true;
    }

    @Override
    public boolean neighbourSelected(Assignment<V, T> assignment, long iteration, Neighbour<V, T> neighbour) {
        return true;
    }

    @Override
    public void neighbourFailed(Assignment<V, T> assignment, long iteration, Neighbour<V, T> neighbour) {
    }
}

