/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.constant;

import java.util.ArrayList;
import java.util.List;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.constant.ConstantVariable;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;

public class ConstantModel<V extends Variable<V, T>, T extends Value<V, T>>
extends Model<V, T> {
    private List<V> iConstantVariables = null;

    public List<V> constantVariables() {
        return this.iConstantVariables;
    }

    public boolean hasConstantVariables() {
        return this.iConstantVariables != null && !this.iConstantVariables.isEmpty();
    }

    public boolean isConstant(V variable) {
        return this.iConstantVariables != null && variable instanceof ConstantVariable && ((ConstantVariable)variable).isConstant();
    }

    @Override
    public void addVariable(V variable) {
        if (variable instanceof ConstantVariable && ((ConstantVariable)variable).isConstant()) {
            if (this.iConstantVariables == null) {
                this.iConstantVariables = new ArrayList<V>();
            }
            ((Variable)variable).setModel(this);
            this.iConstantVariables.add(variable);
        } else {
            super.addVariable(variable);
        }
    }

    @Override
    public void removeVariable(V variable) {
        if (this.isConstant(variable)) {
            ((Variable)variable).setModel(null);
            this.iConstantVariables.remove(variable);
        } else {
            super.removeVariable(variable);
        }
    }

    @Override
    public void beforeAssigned(Assignment<V, T> assignment, long iteration, T value) {
        if (!this.isConstant(((Value)value).variable())) {
            super.beforeAssigned(assignment, iteration, value);
        }
    }

    @Override
    public void beforeUnassigned(Assignment<V, T> assignment, long iteration, T value) {
        if (!this.isConstant(((Value)value).variable())) {
            super.beforeUnassigned(assignment, iteration, value);
        }
    }

    @Override
    public void afterAssigned(Assignment<V, T> assignment, long iteration, T value) {
        if (!this.isConstant(((Value)value).variable())) {
            super.afterAssigned(assignment, iteration, value);
        }
    }

    @Override
    public void afterUnassigned(Assignment<V, T> assignment, long iteration, T value) {
        if (!this.isConstant(((Value)value).variable())) {
            super.afterUnassigned(assignment, iteration, value);
        }
    }
}

