/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.assignment.context;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.InheritedAssignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.CanHoldContext;
import org.cpsolver.ifs.assignment.context.CanInheritContext;
import org.cpsolver.ifs.assignment.context.HasAssignmentContext;
import org.cpsolver.ifs.assignment.context.InheritedAssignmentContextHolder;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;

public class AssignmentContextHelper {
    public static <V extends Variable<V, T>, T extends Value<V, T>, C extends AssignmentContext> C getContext(HasAssignmentContext<V, T, C> source, Assignment<V, T> assignment) {
        if (assignment.getIndex() >= 0 && assignment.getIndex() < 17) {
            AssignmentContext[] contexts = ((CanHoldContext)((Object)source)).getContext();
            if (assignment.getIndex() > 0 && assignment instanceof InheritedAssignment) {
                long version = ((InheritedAssignment)assignment).getVersion();
                InheritedAssignmentContextHolder.VersionedContext<AssignmentContext> context = (InheritedAssignmentContextHolder.VersionedContext<AssignmentContext>)contexts[assignment.getIndex()];
                if (context == null) {
                    contexts[assignment.getIndex()] = context = new InheritedAssignmentContextHolder.VersionedContext<AssignmentContext>();
                }
                if (!context.isCurrent(version)) {
                    if (source instanceof CanInheritContext) {
                        context.setContent(((CanInheritContext)((Object)source)).inheritAssignmentContext(assignment, contexts[0]), version);
                    } else {
                        context.setContent((AssignmentContext)source.createAssignmentContext(assignment), version);
                    }
                }
                return (C)context.getContent();
            }
            AssignmentContext context = contexts[assignment.getIndex()];
            if (context == null) {
                contexts[assignment.getIndex()] = context = source.createAssignmentContext(assignment);
            }
            return (C)context;
        }
        return assignment.getAssignmentContext(source.getAssignmentContextReference());
    }
}

