/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.algorithms;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.algorithms.NeighbourSelector;
import org.cpsolver.ifs.algorithms.neighbourhoods.HillClimberSelection;
import org.cpsolver.ifs.algorithms.neighbourhoods.RandomMove;
import org.cpsolver.ifs.algorithms.neighbourhoods.RandomSwapMove;
import org.cpsolver.ifs.algorithms.neighbourhoods.SuggestionMove;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.NeighbourSelectionWithContext;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.LazyNeighbour;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solution.SolutionListener;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;

public abstract class NeighbourSearch<V extends Variable<V, T>, T extends Value<V, T>>
extends NeighbourSelectionWithContext<V, T, NeighbourSearchContext>
implements LazyNeighbour.LazyNeighbourAcceptanceCriterion<V, T>,
SolutionListener<V, T> {
    private Logger iLog;
    protected DecimalFormat iDF2 = new DecimalFormat("0.00");
    private Progress iProgress = null;
    protected String iPhase = this.getClass().getSimpleName().replaceAll("(?<=[^A-Z])([A-Z])", " $1");
    private List<NeighbourSelector<V, T>> iNeighbours = null;
    private boolean iRandomSelection = false;
    private boolean iUpdatePoints = false;
    private double iTotalBonus;
    private Solver<V, T> iSolver = null;

    public NeighbourSearch(DataProperties properties) {
        this.iLog = Logger.getLogger(this.getClass());
        this.iRandomSelection = properties.getPropertyBoolean(this.getParameterBaseName() + ".Random", this.iRandomSelection);
        this.iUpdatePoints = properties.getPropertyBoolean(this.getParameterBaseName() + ".Update", this.iUpdatePoints);
        String neighbours = properties.getProperty(this.getParameterBaseName() + ".Neighbours", RandomMove.class.getName() + ";" + RandomSwapMove.class.getName() + "@0.01;" + SuggestionMove.class.getName() + "@0.01");
        neighbours = neighbours + ";" + properties.getProperty(this.getParameterBaseName() + ".AdditionalNeighbours", "");
        this.iNeighbours = new ArrayList<NeighbourSelector<V, T>>();
        for (String neighbour : neighbours.split("\\;")) {
            if (neighbour == null || neighbour.isEmpty()) continue;
            try {
                double bonus = 1.0;
                if (neighbour.indexOf(64) >= 0) {
                    bonus = Double.parseDouble(neighbour.substring(neighbour.indexOf(64) + 1));
                    neighbour = neighbour.substring(0, neighbour.indexOf(64));
                }
                Class<?> clazz = Class.forName(neighbour);
                NeighbourSelection selection = (NeighbourSelection)clazz.getConstructor(DataProperties.class).newInstance(properties);
                this.addNeighbourSelection(selection, bonus);
            }
            catch (Exception e) {
                this.iLog.error((Object)("Unable to use " + neighbour + ": " + e.getMessage()));
            }
        }
    }

    protected void info(String message) {
        this.iProgress.debug("[" + Thread.currentThread().getName() + "] " + this.iPhase + "> " + message);
    }

    protected void setProgress(long progress) {
    }

    protected void setProgressPhase(String phase) {
        this.iProgress.info("[" + Thread.currentThread().getName() + "] " + phase);
    }

    protected void addNeighbourSelection(NeighbourSelection<V, T> ns, double bonus) {
        this.iNeighbours.add(new NeighbourSelector<V, T>(ns, bonus, this.iUpdatePoints));
    }

    private double totalPoints() {
        if (!this.iUpdatePoints) {
            return this.iTotalBonus;
        }
        double total = 0.0;
        for (NeighbourSelector<V, T> ns : this.iNeighbours) {
            total += ns.getPoints();
        }
        return total;
    }

    protected void setHCMode(boolean hcMode) {
        for (NeighbourSelector<V, T> s : this.iNeighbours) {
            if (!(s.selection() instanceof HillClimberSelection)) continue;
            ((HillClimberSelection)((Object)s.selection())).setHcMode(hcMode);
        }
    }

    protected List<? extends NeighbourSelection<V, T>> getNeighbours() {
        return this.iNeighbours;
    }

    @Override
    public void init(Solver<V, T> solver) {
        super.init(solver);
        this.iProgress = Progress.getInstance(solver.currentSolution().getModel());
        this.iSolver = solver;
        solver.currentSolution().addSolutionListener(this);
        for (NeighbourSelection neighbourSelection : this.iNeighbours) {
            neighbourSelection.init(solver);
        }
        this.iTotalBonus = 0.0;
        for (NeighbourSelector<V, T> neighbourSelector : this.iNeighbours) {
            neighbourSelector.init(solver);
            this.iTotalBonus += neighbourSelector.getBonus();
        }
    }

    protected NeighbourSelection<V, T> nextNeighbourSelection() {
        NeighbourSelector<V, T> ns2 = null;
        if (this.iRandomSelection) {
            ns2 = ToolBox.random(this.iNeighbours);
        } else {
            double points = ToolBox.random() * this.totalPoints();
            for (NeighbourSelector<V, T> ns2 : this.iNeighbours) {
                double d = this.iUpdatePoints ? ns2.getPoints() : ns2.getBonus();
                if (!((points -= d) <= 0.0)) continue;
                break;
            }
        }
        return ns2;
    }

    protected void logNeibourStatus() {
        if (this.iUpdatePoints) {
            for (NeighbourSelector<V, T> ns : this.iNeighbours) {
                this.iLog.info((Object)("  " + ns + " (" + this.iDF2.format(ns.getPoints()) + " pts, " + this.iDF2.format(100.0 * (this.iUpdatePoints ? ns.getPoints() : ns.getBonus()) / this.totalPoints()) + "%)"));
            }
        }
    }

    public Neighbour<V, T> generateMove(Solution<V, T> solution) {
        return this.nextNeighbourSelection().selectNeighbour(solution);
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        NeighbourSearchContext context = (NeighbourSearchContext)this.getContext(solution.getAssignment());
        context.activateIfNeeded(solution);
        while (context.canContinue(solution)) {
            if (this.iSolver != null && this.iSolver.isStop()) {
                return null;
            }
            context.incIteration(solution);
            Neighbour<V, T> n = this.generateMove(solution);
            if (n == null || !this.accept(context, solution, n)) continue;
            return n;
        }
        context.deactivateIfNeeded(solution);
        return null;
    }

    protected boolean accept(NeighbourSearchContext context, Solution<V, T> solution, Neighbour<V, T> neighbour) {
        if (neighbour instanceof LazyNeighbour) {
            ((LazyNeighbour)neighbour).setAcceptanceCriterion(this);
            return true;
        }
        return context.accept(solution.getAssignment(), solution.getModel(), neighbour, neighbour.value(solution.getAssignment()), false);
    }

    @Override
    public boolean accept(Assignment<V, T> assignment, LazyNeighbour<V, T> neighbour, double value) {
        return ((NeighbourSearchContext)this.getContext(assignment)).accept(assignment, neighbour.getModel(), neighbour, value, true);
    }

    public abstract String getParameterBaseName();

    @Override
    public void bestSaved(Solution<V, T> solution) {
        ((NeighbourSearchContext)this.getContext(solution.getAssignment())).bestSaved(solution);
    }

    @Override
    public void solutionUpdated(Solution<V, T> solution) {
        ((NeighbourSearchContext)this.getContext(solution.getAssignment())).solutionUpdated(solution);
    }

    @Override
    public void getInfo(Solution<V, T> solution, Map<String, String> info) {
        ((NeighbourSearchContext)this.getContext(solution.getAssignment())).getInfo(solution, info);
    }

    @Override
    public void getInfo(Solution<V, T> solution, Map<String, String> info, Collection<V> variables) {
        ((NeighbourSearchContext)this.getContext(solution.getAssignment())).getInfo(solution, info, variables);
    }

    @Override
    public void bestCleared(Solution<V, T> solution) {
        ((NeighbourSearchContext)this.getContext(solution.getAssignment())).bestCleared(solution);
    }

    @Override
    public void bestRestored(Solution<V, T> solution) {
        ((NeighbourSearchContext)this.getContext(solution.getAssignment())).bestRestored(solution);
    }

    public boolean isMaster(Solution<V, T> solution) {
        return !this.hasContextOverride() || solution.getAssignment().getIndex() <= 1;
    }

    public abstract class NeighbourSearchContext
    implements AssignmentContext,
    SolutionListener<V, T> {
        protected long iT0 = -1L;
        protected int iIter = 0;

        protected void activate(Solution<V, T> solution) {
            this.iT0 = JProf.currentTimeMillis();
            this.iIter = 0;
            NeighbourSearch.this.setProgressPhase(NeighbourSearch.this.iPhase + "...");
        }

        private synchronized void activateIfNeeded(Solution<V, T> solution) {
            if (this.iT0 < 0L) {
                this.activate(solution);
            }
        }

        protected void deactivate(Solution<V, T> solution) {
            this.iT0 = -1L;
        }

        private synchronized void deactivateIfNeeded(Solution<V, T> solution) {
            if (NeighbourSearch.this.isMaster(solution)) {
                this.deactivate(solution);
            }
        }

        protected void incIteration(Solution<V, T> solution) {
            ++this.iIter;
        }

        protected long getTimeMillis() {
            return JProf.currentTimeMillis() - this.iT0;
        }

        protected boolean canContinue(Solution<V, T> solution) {
            return true;
        }

        protected abstract boolean accept(Assignment<V, T> var1, Model<V, T> var2, Neighbour<V, T> var3, double var4, boolean var6);

        @Override
        public void bestSaved(Solution<V, T> solution) {
        }

        @Override
        public void solutionUpdated(Solution<V, T> solution) {
        }

        @Override
        public void getInfo(Solution<V, T> solution, Map<String, String> info) {
        }

        @Override
        public void getInfo(Solution<V, T> solution, Map<String, String> info, Collection<V> variables) {
        }

        @Override
        public void bestCleared(Solution<V, T> solution) {
        }

        @Override
        public void bestRestored(Solution<V, T> solution) {
        }
    }
}

