/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.reports;

import org.cpsolver.exam.criteria.StudentBackToBackConflicts;
import org.cpsolver.exam.criteria.StudentDistanceBackToBackConflicts;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamOwner;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.CSVFile;

public class ExamStudentConflicts {
    private ExamModel iModel = null;

    public ExamStudentConflicts(ExamModel model) {
        this.iModel = model;
    }

    public CSVFile report(Assignment<Exam, ExamPlacement> assignment) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField("Student"), new CSVFile.CSVField("Type"), new CSVFile.CSVField("Section/Course"), new CSVFile.CSVField("Period"), new CSVFile.CSVField("Day"), new CSVFile.CSVField("Time"), new CSVFile.CSVField("Room"), new CSVFile.CSVField("Distance")});
        boolean isDayBreakBackToBack = ((StudentBackToBackConflicts)this.iModel.getCriterion(StudentBackToBackConflicts.class)).isDayBreakBackToBack();
        double backToBackDistance = ((StudentDistanceBackToBackConflicts)this.iModel.getCriterion(StudentDistanceBackToBackConflicts.class)).getBackToBackDistance();
        for (ExamStudent student : this.iModel.getStudents()) {
            for (ExamPeriod period : this.iModel.getPeriods()) {
                int nrExamsADay;
                String periodTimes;
                String periodDays;
                String periods;
                int nrExams = student.getExams(assignment, period).size();
                if (nrExams > 1) {
                    String sections = "";
                    String rooms = "";
                    periods = String.valueOf(period.getIndex() + 1);
                    periodDays = period.getDayStr();
                    periodTimes = period.getTimeStr();
                    for (Exam exam : student.getExams(assignment, period)) {
                        ExamPlacement placement = assignment.getValue(exam);
                        String roomsThisExam = "";
                        for (ExamRoomPlacement room : placement.getRoomPlacements()) {
                            if (roomsThisExam.length() > 0) {
                                roomsThisExam = roomsThisExam + ", ";
                            }
                            roomsThisExam = roomsThisExam + room.getName();
                        }
                        boolean first = true;
                        for (ExamOwner cs : exam.getOwners(student)) {
                            if (sections.length() > 0) {
                                sections = sections + "\n";
                                rooms = rooms + "\n";
                                periods = periods + "\n";
                                periodDays = periodDays + "\n";
                                periodTimes = periodTimes + "\n";
                            }
                            sections = sections + cs.getName();
                            if (first) {
                                rooms = rooms + roomsThisExam;
                            }
                            first = false;
                        }
                        if (!exam.getOwners(student).isEmpty()) continue;
                        sections = sections + exam.getName();
                        rooms = rooms + roomsThisExam;
                    }
                    csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(student.getName()), new CSVFile.CSVField("direct"), new CSVFile.CSVField(sections), new CSVFile.CSVField(periods), new CSVFile.CSVField(periodDays), new CSVFile.CSVField(periodTimes), new CSVFile.CSVField(rooms)});
                }
                if (!(nrExams <= 0 || period.next() == null || student.getExams(assignment, period.next()).isEmpty() || isDayBreakBackToBack && period.next().getDay() != period.getDay())) {
                    for (Exam ex1 : student.getExams(assignment, period)) {
                        for (Exam ex2 : student.getExams(assignment, period.next())) {
                            double dist;
                            ExamPlacement placement = assignment.getValue(ex1);
                            String sections = "";
                            String rooms = "";
                            String roomsThisExam = "";
                            String periods2 = String.valueOf(period.getIndex() + 1);
                            String periodDays2 = period.getDayStr();
                            String periodTimes2 = period.getTimeStr();
                            for (ExamRoomPlacement room : placement.getRoomPlacements()) {
                                if (roomsThisExam.length() > 0) {
                                    roomsThisExam = roomsThisExam + ", ";
                                }
                                roomsThisExam = roomsThisExam + room.getName();
                            }
                            boolean first = true;
                            for (ExamOwner cs : ex1.getOwners(student)) {
                                if (sections.length() > 0) {
                                    sections = sections + "\n";
                                    rooms = rooms + "\n";
                                    periods2 = periods2 + "\n";
                                    periodDays2 = periodDays2 + "\n";
                                    periodTimes2 = periodTimes2 + "\n";
                                }
                                sections = sections + cs.getName();
                                if (first) {
                                    rooms = rooms + roomsThisExam;
                                }
                                first = false;
                            }
                            if (ex1.getOwners(student).isEmpty()) {
                                sections = sections + ex1.getName();
                                rooms = rooms + roomsThisExam;
                            }
                            placement = assignment.getValue(ex2);
                            roomsThisExam = "";
                            for (ExamRoomPlacement room : placement.getRoomPlacements()) {
                                if (roomsThisExam.length() > 0) {
                                    roomsThisExam = roomsThisExam + ", ";
                                }
                                roomsThisExam = roomsThisExam + room.getName();
                            }
                            first = true;
                            for (ExamOwner cs : ex2.getOwners(student)) {
                                sections = sections + "\n";
                                rooms = rooms + "\n";
                                periods2 = periods2 + "\n";
                                periodDays2 = periodDays2 + "\n";
                                periodTimes2 = periodTimes2 + "\n";
                                sections = sections + cs.getName();
                                if (first) {
                                    rooms = rooms + roomsThisExam;
                                    periods2 = periods2 + String.valueOf(period.next().getIndex() + 1);
                                    periodDays2 = periodDays2 + period.next().getDayStr();
                                    periodTimes2 = periodTimes2 + period.next().getTimeStr();
                                }
                                first = false;
                            }
                            if (ex2.getOwners(student).isEmpty()) {
                                sections = sections + "\n";
                                rooms = rooms + "\n";
                                periods2 = periods2 + "\n";
                                periodDays2 = periodDays2 + "\n";
                                periodTimes2 = periodTimes2 + "\n";
                                sections = sections + ex2.getName();
                                rooms = rooms + roomsThisExam;
                                periods2 = periods2 + String.valueOf(period.next().getIndex() + 1);
                                periodDays2 = periodDays2 + period.next().getDayStr();
                                periodTimes2 = periodTimes2 + period.next().getTimeStr();
                                rooms = rooms + roomsThisExam;
                            }
                            String distStr = "";
                            if (backToBackDistance >= 0.0 && (dist = assignment.getValue(ex1).getDistanceInMeters(assignment.getValue(ex2))) > 0.0) {
                                distStr = String.valueOf(dist);
                            }
                            csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(student.getName()), new CSVFile.CSVField("back-to-back"), new CSVFile.CSVField(sections), new CSVFile.CSVField(periods2), new CSVFile.CSVField(periodDays2), new CSVFile.CSVField(periodTimes2), new CSVFile.CSVField(rooms), new CSVFile.CSVField(distStr)});
                        }
                    }
                }
                if (period.next() != null && period.next().getDay() == period.getDay() || (nrExamsADay = student.getExamsADay(assignment, period.getDay()).size()) <= 2) continue;
                String sections = "";
                periods = "";
                periodDays = "";
                periodTimes = "";
                String rooms = "";
                for (Exam exam : student.getExamsADay(assignment, period.getDay())) {
                    ExamPlacement placement = assignment.getValue(exam);
                    String roomsThisExam = "";
                    for (ExamRoomPlacement room : placement.getRoomPlacements()) {
                        if (roomsThisExam.length() > 0) {
                            roomsThisExam = roomsThisExam + ", ";
                        }
                        roomsThisExam = roomsThisExam + room.getName();
                    }
                    boolean first = true;
                    for (ExamOwner cs : exam.getOwners(student)) {
                        if (sections.length() > 0) {
                            sections = sections + "\n";
                            rooms = rooms + "\n";
                            periods = periods + "\n";
                            periodDays = periodDays + "\n";
                            periodTimes = periodTimes + "\n";
                        }
                        sections = sections + cs.getName();
                        if (first) {
                            periods = periods + (placement.getPeriod().getIndex() + 1);
                            periodDays = periodDays + placement.getPeriod().getDayStr();
                            periodTimes = periodTimes + placement.getPeriod().getTimeStr();
                            rooms = rooms + roomsThisExam;
                        }
                        first = false;
                    }
                    if (!exam.getOwners(student).isEmpty()) continue;
                    if (sections.length() > 0) {
                        sections = sections + "\n";
                        rooms = rooms + "\n";
                        periods = periods + "\n";
                        periodDays = periodDays + "\n";
                        periodTimes = periodTimes + "\n";
                    }
                    sections = sections + exam.getName();
                    periods = periods + (placement.getPeriod().getIndex() + 1);
                    periodDays = periodDays + placement.getPeriod().getDayStr();
                    periodTimes = periodTimes + placement.getPeriod().getTimeStr();
                    rooms = rooms + roomsThisExam;
                }
                csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(student.getName()), new CSVFile.CSVField("more-2-day"), new CSVFile.CSVField(sections), new CSVFile.CSVField(periods), new CSVFile.CSVField(periodDays), new CSVFile.CSVField(periodTimes), new CSVFile.CSVField(rooms)});
            }
        }
        return csv;
    }
}

