/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.heuristics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.neighbours.ExamRandomMove;
import org.cpsolver.exam.neighbours.ExamRoomMove;
import org.cpsolver.exam.neighbours.ExamTimeMove;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.NeighbourSelectionWithContext;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.LazyNeighbour;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solution.SolutionListener;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;

@Deprecated
public class ExamHillClimbing
extends NeighbourSelectionWithContext<Exam, ExamPlacement, Context>
implements SolutionListener<Exam, ExamPlacement>,
LazyNeighbour.LazyNeighbourAcceptanceCriterion<Exam, ExamPlacement> {
    private static Logger sLog = Logger.getLogger(ExamHillClimbing.class);
    private List<NeighbourSelection<Exam, ExamPlacement>> iNeighbours = null;
    private int iMaxIdleIters = 25000;
    private Progress iProgress = null;
    private String iName = "Hill climbing";

    public ExamHillClimbing(DataProperties properties) {
        this(properties, "Hill Climbing");
    }

    public ExamHillClimbing(DataProperties properties, String name) {
        this.iMaxIdleIters = properties.getPropertyInt("HillClimber.MaxIdle", this.iMaxIdleIters);
        String neighbours = properties.getProperty("HillClimber.Neighbours", ExamRandomMove.class.getName() + ";" + ExamRoomMove.class.getName() + ";" + ExamTimeMove.class.getName());
        neighbours = neighbours + ";" + properties.getProperty("HillClimber.AdditionalNeighbours", "");
        this.iNeighbours = new ArrayList<NeighbourSelection<Exam, ExamPlacement>>();
        for (String neighbour : neighbours.split("\\;")) {
            if (neighbour == null || neighbour.isEmpty()) continue;
            try {
                Class<?> clazz = Class.forName(neighbour);
                this.iNeighbours.add((NeighbourSelection<Exam, ExamPlacement>)clazz.getConstructor(DataProperties.class).newInstance(properties));
            }
            catch (Exception e) {
                sLog.error((Object)("Unable to use " + neighbour + ": " + e.getMessage()));
            }
        }
        this.iName = name;
    }

    @Override
    public void init(Solver<Exam, ExamPlacement> solver) {
        super.init(solver);
        solver.currentSolution().addSolutionListener(this);
        for (NeighbourSelection<Exam, ExamPlacement> neighbour : this.iNeighbours) {
            neighbour.init(solver);
        }
        solver.setUpdateProgress(false);
        this.iProgress = Progress.getInstance(solver.currentSolution().getModel());
        ((Context)this.getContext(solver.currentSolution().getAssignment())).reset();
    }

    @Override
    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        Context context = (Context)this.getContext(solution.getAssignment());
        context.activateIfNeeded();
        while (!context.incIter(solution)) {
            NeighbourSelection<Exam, ExamPlacement> ns = this.iNeighbours.get(ToolBox.random(this.iNeighbours.size()));
            Neighbour<Exam, ExamPlacement> n = ns.selectNeighbour(solution);
            if (n == null) continue;
            if (n instanceof LazyNeighbour) {
                ((LazyNeighbour)n).setAcceptanceCriterion(this);
                return n;
            }
            if (!(n.value(solution.getAssignment()) <= 0.0)) continue;
            return n;
        }
        context.reset();
        return null;
    }

    @Override
    public void bestSaved(Solution<Exam, ExamPlacement> solution) {
        ((Context)this.getContext(solution.getAssignment())).bestSaved(solution.getModel());
    }

    @Override
    public void solutionUpdated(Solution<Exam, ExamPlacement> solution) {
    }

    @Override
    public void getInfo(Solution<Exam, ExamPlacement> solution, Map<String, String> info) {
    }

    @Override
    public void getInfo(Solution<Exam, ExamPlacement> solution, Map<String, String> info, Collection<Exam> variables) {
    }

    @Override
    public void bestCleared(Solution<Exam, ExamPlacement> solution) {
    }

    @Override
    public void bestRestored(Solution<Exam, ExamPlacement> solution) {
    }

    @Override
    public boolean accept(Assignment<Exam, ExamPlacement> assignment, LazyNeighbour<Exam, ExamPlacement> neighbour, double value) {
        return value <= 0.0;
    }

    @Override
    public Context createAssignmentContext(Assignment<Exam, ExamPlacement> assignment) {
        return new Context();
    }

    public class Context
    implements AssignmentContext {
        private int iLastImprovingIter = 0;
        private double iBestValue = 0.0;
        private int iIter = 0;
        private boolean iActive;

        protected void reset() {
            this.iIter = 0;
            this.iLastImprovingIter = 0;
            this.iActive = false;
        }

        protected void activateIfNeeded() {
            if (!this.iActive) {
                ExamHillClimbing.this.iProgress.setPhase(ExamHillClimbing.this.iName + "...");
                this.iActive = true;
            }
        }

        protected boolean incIter(Solution<Exam, ExamPlacement> solution) {
            ++this.iIter;
            ExamHillClimbing.this.iProgress.setProgress(Math.round(100.0 * (double)(this.iIter - this.iLastImprovingIter) / (double)ExamHillClimbing.this.iMaxIdleIters));
            return this.iIter - this.iLastImprovingIter >= ExamHillClimbing.this.iMaxIdleIters;
        }

        protected void bestSaved(Model<Exam, ExamPlacement> model) {
            if (Math.abs(this.iBestValue - model.getBestValue()) >= 1.0) {
                this.iLastImprovingIter = this.iIter;
                this.iBestValue = model.getBestValue();
            }
        }
    }
}

