/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.heuristics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamInstructor;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriodPlacement;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.Progress;

public class ExamColoringConstruction
implements NeighbourSelection<Exam, ExamPlacement> {
    private Progress iProgress;
    private double iT0;
    private double iTimeLimit = 300.0;
    private boolean iTimeLimitReached = false;
    private Mode iMode = Mode.Full;
    private Solver<Exam, ExamPlacement> iSolver;

    public ExamColoringConstruction(DataProperties config) {
        this.iTimeLimit = config.getPropertyDouble("Exam.ColoringConstructionTimeLimit", this.iTimeLimit);
        this.iMode = Mode.valueOf(config.getProperty("Exam.ColoringConstructionMode", this.iMode.name()));
    }

    private boolean backTrack(Solution<Exam, ExamPlacement> solution, int index, HashSet<Integer> colorsUsedSoFar, Collection<Vertex> vertices) {
        Iterator<Comparable<Vertex>> i$;
        Assignment<Exam, ExamPlacement> assignment = solution.getAssignment();
        if (this.iTimeLimitReached || this.iSolver.isStop()) {
            return false;
        }
        if (JProf.currentTimeSec() - this.iT0 > this.iTimeLimit) {
            this.iTimeLimitReached = true;
            return false;
        }
        if (index == vertices.size()) {
            return true;
        }
        if (this.iProgress.getProgress() < (long)index) {
            this.iProgress.setProgress(index);
            if (this.iMode.isConstraintCheck()) {
                solution.saveBest();
            }
        }
        Vertex vertex = null;
        for (Vertex v : vertices) {
            if (v.color() >= 0 || vertex != null && v.compareTo(vertex) >= 0) continue;
            vertex = v;
        }
        if (colorsUsedSoFar != null) {
            i$ = new TreeSet<Integer>(colorsUsedSoFar).iterator();
            while (i$.hasNext()) {
                int color = (Integer)i$.next();
                if (!vertex.colorize(assignment, color) || !this.backTrack(solution, 1 + index, colorsUsedSoFar, vertices)) continue;
                return true;
            }
            i$ = vertex.domain().iterator();
            while (i$.hasNext()) {
                int color = (Integer)i$.next();
                if (colorsUsedSoFar.contains(color)) continue;
                if (!vertex.colorize(assignment, color)) break;
                colorsUsedSoFar.add(color);
                if (this.backTrack(solution, 1 + index, colorsUsedSoFar, vertices)) {
                    return true;
                }
                colorsUsedSoFar.remove(color);
                break;
            }
        } else {
            i$ = vertex.domain().iterator();
            while (i$.hasNext()) {
                int color = (Integer)i$.next();
                if (!vertex.colorize(assignment, color) || !this.backTrack(solution, 1 + index, colorsUsedSoFar, vertices)) continue;
                return true;
            }
        }
        vertex.colorize(assignment, -1);
        return false;
    }

    @Override
    public void init(Solver<Exam, ExamPlacement> solver) {
        this.iProgress = Progress.getInstance(solver.currentSolution().getModel());
        this.iSolver = solver;
    }

    public Set<ExamRoomPlacement> findRooms(Assignment<Exam, ExamPlacement> assignment, Exam exam, ExamPeriodPlacement period) {
        int bestSize;
        Set<ExamRoomPlacement> rooms = exam.findBestAvailableRooms(assignment, period);
        if (rooms != null) {
            return rooms;
        }
        rooms = new HashSet<ExamRoomPlacement>();
        for (int size = 0; size < exam.getSize(); size += bestSize) {
            ExamRoomPlacement bestRoom = null;
            bestSize = 0;
            for (ExamRoomPlacement r : exam.getRoomPlacements()) {
                if (!r.isAvailable(period.getPeriod()) || rooms.contains(r) || !r.getRoom().getPlacements(assignment, period.getPeriod()).isEmpty()) continue;
                int s = r.getSize(exam.hasAltSeating());
                if (bestRoom != null && s <= bestSize) continue;
                bestRoom = r;
                bestSize = s;
            }
            if (bestRoom == null) {
                return rooms;
            }
            rooms.add(bestRoom);
        }
        return rooms;
    }

    @Override
    public Neighbour<Exam, ExamPlacement> selectNeighbour(final Solution<Exam, ExamPlacement> solution) {
        ExamModel model = (ExamModel)solution.getModel();
        final HashMap<Exam, Vertex> vertices = new HashMap<Exam, Vertex>();
        for (Exam x : model.variables()) {
            vertices.put(x, new Vertex(x));
        }
        for (ExamStudent s : model.getStudents()) {
            for (Exam x : s.variables()) {
                for (Exam y : s.variables()) {
                    if (x.equals(y)) continue;
                    ((Vertex)vertices.get(x)).neighbors().add((Vertex)vertices.get(y));
                    ((Vertex)vertices.get(y)).neighbors().add((Vertex)vertices.get(x));
                }
            }
        }
        for (ExamInstructor i : model.getInstructors()) {
            for (Exam x : i.variables()) {
                for (Exam y : i.variables()) {
                    if (x.equals(y)) continue;
                    ((Vertex)vertices.get(x)).neighbors().add((Vertex)vertices.get(y));
                    ((Vertex)vertices.get(y)).neighbors().add((Vertex)vertices.get(x));
                }
            }
        }
        this.iProgress.setPhase("Graph coloring-based construction", vertices.size());
        this.iProgress.info("Looking for a conflict-free assignment using " + model.getPeriods().size() + " periods.");
        this.iT0 = JProf.currentTimeSec();
        this.iTimeLimitReached = false;
        if (this.iMode.isGreedy()) {
            this.iProgress.info("Using greedy heuristics only (no backtracking)...");
        } else if (this.backTrack(solution, 0, this.iMode.isRedundant() ? null : new HashSet<Integer>(), vertices.values())) {
            this.iProgress.info("Success!");
        } else if (this.iTimeLimitReached) {
            this.iProgress.info("There was no conflict-free schedule found during the given time.");
        } else if (this.iSolver.isStop()) {
            this.iProgress.info("Solver was stopped.");
        } else if (this.iMode.isRedundant()) {
            this.iProgress.info("There is no conflict-free schedule!");
        } else {
            this.iProgress.info("Conflict-free schedule not found.");
        }
        if (this.iMode.isConstraintCheck()) {
            solution.restoreBest();
        }
        HashSet<Vertex> remaning = new HashSet<Vertex>();
        for (Vertex v : vertices.values()) {
            if (v.color() >= 0) continue;
            remaning.add(v);
        }
        block8: while (!remaning.isEmpty()) {
            Vertex vertex = null;
            for (Vertex v : remaning) {
                if (vertex != null && v.compareTo(vertex) >= 0) continue;
                vertex = v;
            }
            remaning.remove(vertex);
            Iterator<Object> i$ = vertex.domain().iterator();
            while (i$.hasNext()) {
                int color = (Integer)i$.next();
                if (!vertex.colorize(solution.getAssignment(), color)) continue;
                continue block8;
            }
        }
        if (!this.iMode.isConstraintCheck()) {
            return new Neighbour<Exam, ExamPlacement>(){

                @Override
                public void assign(Assignment<Exam, ExamPlacement> assignment, long iteration) {
                    ExamColoringConstruction.this.iProgress.info("Using graph coloring solution ...");
                    for (Vertex vertex : new TreeSet(vertices.values())) {
                        Set<ExamRoomPlacement> rooms;
                        ExamPeriodPlacement period = vertex.period();
                        if (period == null || !vertex.exam().checkDistributionConstraints(assignment, period) || (rooms = ExamColoringConstruction.this.findRooms(assignment, vertex.exam(), period)) == null) continue;
                        assignment.assign(iteration, new ExamPlacement(vertex.exam(), period, rooms));
                    }
                    HashSet<Vertex> unassigned = new HashSet<Vertex>();
                    for (Vertex vertex : vertices.values()) {
                        if (assignment.getValue(vertex.exam()) != null) continue;
                        unassigned.add(vertex);
                        vertex.colorize(assignment, -1);
                    }
                    solution.saveBest();
                    ExamColoringConstruction.this.iProgress.info("Extending ...");
                    block2: while (!unassigned.isEmpty()) {
                        Vertex vertex;
                        vertex = null;
                        for (Vertex v : unassigned) {
                            if (vertex != null && v.compareTo(vertex) >= 0) continue;
                            vertex = v;
                        }
                        unassigned.remove(vertex);
                        Iterator<Object> i$ = vertex.domain().iterator();
                        while (i$.hasNext()) {
                            Set<ExamRoomPlacement> rooms;
                            ExamPeriodPlacement period;
                            int color = (Integer)i$.next();
                            if (!vertex.colorize(assignment, color) || (period = vertex.period(color)) == null || !vertex.exam().checkDistributionConstraints(assignment, period) || (rooms = ExamColoringConstruction.this.findRooms(assignment, vertex.exam(), period)) == null) continue;
                            assignment.assign(iteration, new ExamPlacement(vertex.exam(), period, rooms));
                            continue block2;
                        }
                        vertex.colorize(assignment, -1);
                    }
                    solution.saveBest();
                    ExamColoringConstruction.this.iProgress.info("Construction done.");
                }

                @Override
                public double value(Assignment<Exam, ExamPlacement> assignment) {
                    return 0.0;
                }

                @Override
                public Map<Exam, ExamPlacement> assignments() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return null;
    }

    private class Vertex
    implements Comparable<Vertex> {
        private Exam iExam;
        private List<Vertex> iNeighbors = new ArrayList<Vertex>();
        private int iColor = -1;
        private HashMap<Integer, ExamPeriodPlacement> iDomain = new HashMap();
        private HashMap<Integer, Vertex> iTaken = new HashMap();

        public Vertex(Exam exam) {
            this.iExam = exam;
            for (ExamPeriodPlacement period : exam.getPeriodPlacements()) {
                this.iDomain.put(period.getIndex(), period);
            }
        }

        public List<Vertex> neighbors() {
            return this.iNeighbors;
        }

        public Set<Integer> domain() {
            return this.iDomain.keySet();
        }

        public ExamPeriodPlacement period() {
            return this.iColor < 0 ? null : this.iDomain.get(this.iColor);
        }

        public ExamPeriodPlacement period(int color) {
            return color < 0 ? null : this.iDomain.get(color);
        }

        private boolean neighborColored(Vertex v, int color) {
            if (!this.iDomain.containsKey(color)) {
                return true;
            }
            if (this.iTaken.get(color) == null) {
                this.iTaken.put(color, v);
            }
            return this.iTaken.size() < this.iDomain.size();
        }

        private void neighborUncolored(Vertex v, int color) {
            if (!this.iDomain.containsKey(color)) {
                return;
            }
            if (v.equals(this.iTaken.get(color))) {
                for (Vertex w : this.neighbors()) {
                    if (w.equals(v) || w.color() != color) continue;
                    this.iTaken.put(color, w);
                    return;
                }
                this.iTaken.remove(color);
            }
        }

        public int color() {
            return this.iColor;
        }

        public boolean colorize(Assignment<Exam, ExamPlacement> assignment, int color) {
            if (this.iColor == color) {
                return true;
            }
            ExamPlacement placement = null;
            if (color >= 0) {
                if (this.iTaken.get(color) != null || !this.iDomain.containsKey(color)) {
                    return false;
                }
                if (ExamColoringConstruction.this.iMode.isConstraintCheck()) {
                    ExamPeriodPlacement period = this.iDomain.get(color);
                    if (!this.iExam.checkDistributionConstraints(assignment, period)) {
                        return false;
                    }
                    Set<ExamRoomPlacement> rooms = ExamColoringConstruction.this.findRooms(assignment, this.iExam, period);
                    if (rooms == null) {
                        return false;
                    }
                    placement = new ExamPlacement(this.iExam, period, rooms);
                }
            }
            if (this.iColor >= 0) {
                for (Vertex v : this.neighbors()) {
                    v.neighborUncolored(this, this.iColor);
                }
            }
            boolean success = true;
            if (color >= 0) {
                for (Vertex v : this.neighbors()) {
                    if (v.neighborColored(this, color)) continue;
                    success = false;
                    break;
                }
            }
            if (success) {
                this.iColor = color;
                if (ExamColoringConstruction.this.iMode.isConstraintCheck()) {
                    if (placement != null) {
                        assignment.assign(0L, placement);
                    } else {
                        assignment.unassign(0L, this.iExam);
                    }
                }
            } else {
                for (Vertex v : this.neighbors()) {
                    v.neighborUncolored(this, color);
                    if (this.iColor < 0) continue;
                    v.neighborColored(this, this.iColor);
                }
            }
            return success;
        }

        public int degree() {
            return this.iNeighbors.size();
        }

        public int available() {
            return this.iDomain.size() - this.iTaken.size();
        }

        public int degreeNotColored() {
            int ret = 0;
            for (Vertex v : this.neighbors()) {
                if (v.color() >= 0) continue;
                ++ret;
            }
            return ret;
        }

        public Exam exam() {
            return this.iExam;
        }

        @Override
        public int compareTo(Vertex v) {
            if (this.available() < v.available()) {
                return -1;
            }
            if (v.available() < this.available()) {
                return 1;
            }
            if (this.degree() > v.degree()) {
                return -1;
            }
            if (v.degree() > this.degree()) {
                return 1;
            }
            if (this.degreeNotColored() > v.degreeNotColored()) {
                return -1;
            }
            if (v.degreeNotColored() > this.degreeNotColored()) {
                return 1;
            }
            return Double.compare(this.exam().getId(), v.exam().getId());
        }
    }

    private static enum Mode {
        Greedy(true, false, true),
        ColorOnly(false, false, false),
        Irredundant(false, false, false),
        Full(false, true, true);

        boolean iGreedy;
        boolean iRedundant;
        boolean iConstraintCheck;

        private Mode(boolean gr, boolean r, boolean ch) {
            this.iGreedy = gr;
            this.iRedundant = r;
            this.iConstraintCheck = ch;
        }

        public boolean isGreedy() {
            return this.iGreedy;
        }

        public boolean isRedundant() {
            return this.iRedundant;
        }

        public boolean isConstraintCheck() {
            return this.iConstraintCheck;
        }
    }
}

