/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.StudentDirectConflicts;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.Assignment;

public class StudentNotAvailableConflicts
extends StudentDirectConflicts {
    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        int penalty = 0;
        for (ExamStudent s : exam.getStudents()) {
            if (s.isAvailable(value.getPeriod())) continue;
            ++penalty;
        }
        return penalty;
    }

    @Override
    public String getName() {
        return "Not Available Conflicts";
    }

    @Override
    public void getInfo(Assignment<Exam, ExamPlacement> assignment, Map<String, String> info) {
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return this.getValue(assignment) <= 0.0 ? "" : "NA:" + sDoubleFormat.format(this.getValue(assignment));
    }
}

