/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;

public class RoomSizePenalty
extends ExamCriterion {
    private double iRoomSizeFactor = 1.0;

    @Override
    public boolean init(Solver<Exam, ExamPlacement> solver) {
        this.iRoomSizeFactor = solver.getProperties().getPropertyDouble("Exams.RoomSizeFactor", 1.0);
        return super.init(solver);
    }

    @Override
    public void setModel(Model<Exam, ExamPlacement> model) {
        super.setModel(model);
        this.iRoomSizeFactor = ((ExamModel)model).getProperties().getPropertyDouble("Exams.RoomSizeFactor", 1.0);
    }

    @Override
    public String getWeightName() {
        return "Exams.RoomSizeWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "roomSizeWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1.0E-4;
    }

    @Override
    public void getXmlParameters(Map<String, String> params) {
        params.put(this.getXmlWeightName(), String.valueOf(this.getWeight()));
        params.put("roomSizeFactor", String.valueOf(this.iRoomSizeFactor));
    }

    @Override
    public void setXmlParameters(Map<String, String> params) {
        try {
            this.setWeight(Double.valueOf(params.get(this.getXmlWeightName())));
        }
        catch (NumberFormatException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.iRoomSizeFactor = Double.valueOf(params.get("roomSizeFactor"));
        }
        catch (NumberFormatException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        int diff;
        Exam exam = (Exam)value.variable();
        int size = 0;
        if (value.getRoomPlacements() != null) {
            for (ExamRoomPlacement r : value.getRoomPlacements()) {
                size += r.getSize(exam.hasAltSeating());
            }
        }
        return (diff = size - exam.getSize()) < 0 ? 0.0 : Math.pow(diff, this.iRoomSizeFactor);
    }

    @Override
    public void getInfo(Assignment<Exam, ExamPlacement> assignment, Map<String, String> info) {
        if (this.getValue(assignment) != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue(assignment) / (double)assignment.nrAssignedVariables()));
        }
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return "RSz:" + sDoubleFormat.format(this.getValue(assignment) / (double)assignment.nrAssignedVariables());
    }

    @Override
    public boolean isPeriodCriterion() {
        return false;
    }
}

