/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPeriodPlacement;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;

public abstract class ExamCriterion
extends AbstractCriterion<Exam, ExamPlacement> {
    public void setWeight(double weight) {
        this.iWeight = weight;
    }

    @Override
    public String getWeightName() {
        return "Exams." + this.getClass().getName().substring(1 + this.getClass().getName().lastIndexOf(46)) + "Weight";
    }

    @Override
    public double[] getBounds(Assignment<Exam, ExamPlacement> assignment, Collection<Exam> exams) {
        double[] bounds = new double[]{0.0, 0.0};
        for (Exam exam : exams) {
            Double min = null;
            Double max = null;
            for (ExamPeriodPlacement period : exam.getPeriodPlacements()) {
                if (exam.getMaxRooms() == 0) {
                    double value = this.getValue(assignment, new ExamPlacement(exam, period, null), null);
                    if (min == null) {
                        min = value;
                        max = value;
                        continue;
                    }
                    min = Math.min(min, value);
                    max = Math.max(max, value);
                    continue;
                }
                for (ExamRoomPlacement room : exam.getRoomPlacements()) {
                    HashSet<ExamRoomPlacement> rooms = new HashSet<ExamRoomPlacement>();
                    rooms.add(room);
                    double value = this.getValue(assignment, new ExamPlacement(exam, period, rooms), null);
                    if (min == null) {
                        min = value;
                        max = value;
                        continue;
                    }
                    min = Math.min(min, value);
                    max = Math.max(max, value);
                }
            }
            if (min == null) continue;
            bounds[0] = bounds[0] + min;
            bounds[1] = bounds[1] + max;
        }
        return bounds;
    }

    @Override
    public void getInfo(Assignment<Exam, ExamPlacement> assignment, Map<String, String> info) {
        double val = this.getValue(assignment);
        double[] bounds = this.getBounds(assignment);
        if (bounds[0] <= val && val <= bounds[1] && bounds[0] < bounds[1]) {
            info.put(this.getName(), this.getPerc(val, bounds[0], bounds[1]) + "% (" + sDoubleFormat.format(val) + ")");
        } else if (bounds[1] <= val && val <= bounds[0] && bounds[1] < bounds[0]) {
            info.put(this.getName(), this.getPercRev(val, bounds[1], bounds[0]) + "% (" + sDoubleFormat.format(val) + ")");
        } else if (bounds[0] != val || val != bounds[1]) {
            info.put(this.getName(), sDoubleFormat.format(val));
        }
    }

    public boolean isPeriodCriterion() {
        return true;
    }

    public double getPeriodValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value) {
        return this.isPeriodCriterion() ? this.getValue(assignment, value, null) : 0.0;
    }

    public boolean isRoomCriterion() {
        return !this.isPeriodCriterion();
    }

    public double getRoomValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value) {
        return this.isRoomCriterion() ? this.getValue(assignment, value, null) : 0.0;
    }

    public String getXmlWeightName() {
        String name = this.getClass().getName().substring(1 + this.getClass().getName().lastIndexOf(46));
        return Character.toString(name.charAt(0)) + name.substring(1);
    }

    public void getXmlParameters(Map<String, String> params) {
        params.put(this.getXmlWeightName(), String.valueOf(this.getWeight()));
    }

    public void setXmlParameters(Map<String, String> params) {
        try {
            this.setWeight(Double.valueOf(params.get(this.getXmlWeightName())));
        }
        catch (NumberFormatException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

