/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.preference;

import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.preference.SumPreferenceCombination;

public abstract class PreferenceCombination {
    boolean iIsRequired = false;
    boolean iIsProhibited = false;

    public void addPreferenceProlog(String prologPref) {
        this.addPreferenceInt(Constants.preference2preferenceLevel(prologPref));
    }

    public void addPreferenceInt(int intPref) {
        String prologPref = Constants.preferenceLevel2preference(intPref);
        if ("R".equals(prologPref)) {
            this.iIsRequired = true;
        }
        if ("P".equals(prologPref)) {
            this.iIsProhibited = true;
        }
    }

    public boolean isRequired() {
        return this.iIsRequired && !this.iIsProhibited;
    }

    public boolean isProhibited() {
        return this.iIsProhibited;
    }

    public abstract int getPreferenceInt();

    public String getPreferenceProlog() {
        if (this.iIsProhibited) {
            return "P";
        }
        if (this.iIsRequired) {
            return "R";
        }
        return Constants.preferenceLevel2preference(this.getPreferenceInt());
    }

    public static PreferenceCombination getDefault() {
        return new SumPreferenceCombination();
    }
}

