/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.ClassLimitConstraint;
import org.cpsolver.coursett.constraint.DepartmentSpreadConstraint;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.IgnoreStudentConflictsConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.constraint.RoomConstraint;
import org.cpsolver.coursett.constraint.SpreadConstraint;
import org.cpsolver.coursett.criteria.StudentCommittedConflict;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.model.Configuration;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.VariableWithContext;
import org.cpsolver.ifs.constant.ConstantVariable;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.model.WeakeningConstraint;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.ifs.util.ToolBox;

public class Lecture
extends VariableWithContext<Lecture, Placement, LectureContext>
implements ConstantVariable<Placement> {
    private Long iClassId;
    private Long iSolverGroupId;
    private Long iSchedulingSubpartId;
    private String iName;
    private Long iDept;
    private Long iScheduler;
    private List<TimeLocation> iTimeLocations;
    private List<RoomLocation> iRoomLocations;
    private String iNote = null;
    private int iMinClassLimit;
    private int iMaxClassLimit;
    private float iRoomToLimitRatio;
    private int iNrRooms;
    private int iOrd;
    private double iWeight = 1.0;
    private Set<Student> iStudents = new HashSet<Student>();
    private DepartmentSpreadConstraint iDeptSpreadConstraint = null;
    private Set<SpreadConstraint> iSpreadConstraints = new HashSet<SpreadConstraint>();
    private Set<Constraint<Lecture, Placement>> iWeakeningConstraints = new HashSet<Constraint<Lecture, Placement>>();
    private List<InstructorConstraint> iInstructorConstraints = new ArrayList<InstructorConstraint>();
    private AtomicReference<Set<Long>> iIgnoreStudentConflictsWith = new AtomicReference();
    private ClassLimitConstraint iClassLimitConstraint = null;
    private Lecture iParent = null;
    private HashMap<Long, List<Lecture>> iChildren = null;
    private List<Lecture> iSameSubpartLectures = null;
    private Configuration iParentConfiguration = null;
    private List<JenrlConstraint> iJenrlConstraints = new ArrayList<JenrlConstraint>();
    private HashMap<Lecture, JenrlConstraint> iJenrlConstraintsHash = new HashMap();
    private HashMap<Placement, Integer> iCommitedConflicts = new HashMap();
    private Set<GroupConstraint> iGroupConstraints = new HashSet<GroupConstraint>();
    private Set<GroupConstraint> iHardGroupSoftConstraints = new HashSet<GroupConstraint>();
    private Set<GroupConstraint> iCanShareRoomGroupConstraints = new HashSet<GroupConstraint>();
    private Set<FlexibleConstraint> iFlexibleGroupConstraints = new HashSet<FlexibleConstraint>();
    public boolean iCommitted = false;
    public static boolean sSaveMemory = false;
    public static boolean sAllowBreakHard = false;
    private int iMaxRoomCombinations = -1;
    private Integer iCacheMinRoomSize = null;
    private Integer iCacheMaxRoomSize = null;
    private Integer iCacheMaxAchievableClassLimit = null;
    private final ReentrantReadWriteLock iLock = new ReentrantReadWriteLock();
    private Double iBestTimePreferenceCache = null;
    private int[] iMinMaxRoomPreference = null;
    private double[] iMinMaxTimePreference = null;

    public Lecture(Long id, Long solverGroupId, Long schedulingSubpartId, String name, List<TimeLocation> timeLocations, List<RoomLocation> roomLocations, int nrRooms, Placement initialPlacement, int minClassLimit, int maxClassLimit, double room2limitRatio) {
        super(initialPlacement);
        this.iClassId = id;
        this.iSchedulingSubpartId = schedulingSubpartId;
        this.iTimeLocations = new ArrayList<TimeLocation>(timeLocations);
        this.iRoomLocations = new ArrayList<RoomLocation>(roomLocations);
        this.iName = name;
        this.iMinClassLimit = minClassLimit;
        this.iMaxClassLimit = maxClassLimit;
        this.iRoomToLimitRatio = (float)room2limitRatio;
        this.iNrRooms = nrRooms;
        this.iSolverGroupId = solverGroupId;
    }

    public Lecture(Long id, Long solverGroupId, String name) {
        super(null);
        this.iClassId = id;
        this.iSolverGroupId = solverGroupId;
        this.iName = name;
    }

    public Long getSolverGroupId() {
        return this.iSolverGroupId;
    }

    public void addActiveJenrl(Assignment<Lecture, Placement> assignment, JenrlConstraint constr) {
        ((LectureContext)this.getContext(assignment)).addActiveJenrl(constr);
    }

    public Set<JenrlConstraint> activeJenrls(Assignment<Lecture, Placement> assignment) {
        return ((LectureContext)this.getContext(assignment)).activeJenrls();
    }

    public void removeActiveJenrl(Assignment<Lecture, Placement> assignment, JenrlConstraint constr) {
        ((LectureContext)this.getContext(assignment)).removeActiveJenrl(constr);
    }

    public Long getClassId() {
        return this.iClassId;
    }

    public Long getSchedulingSubpartId() {
        return this.iSchedulingSubpartId;
    }

    @Override
    public String getName() {
        return this.iName;
    }

    @Override
    public long getId() {
        return this.iClassId;
    }

    public List<String> getInstructorNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (InstructorConstraint ic : this.iInstructorConstraints) {
            ret.add(ic.getName());
        }
        return ret;
    }

    public String getInstructorName() {
        StringBuffer sb = new StringBuffer();
        for (InstructorConstraint ic : this.iInstructorConstraints) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(ic.getName());
        }
        return sb.toString();
    }

    public Set<Student> students() {
        return this.iStudents;
    }

    public double nrWeightedStudents() {
        double w = 0.0;
        for (Student s : this.iStudents) {
            w += s.getOfferingWeight(this.getConfiguration());
        }
        return w;
    }

    public void addStudent(Assignment<Lecture, Placement> assignment, Student student) {
        Placement value;
        if (!this.iStudents.add(student)) {
            return;
        }
        Placement placement = value = assignment == null ? null : assignment.getValue(this);
        if (value != null && this.getModel() != null) {
            this.getModel().getCriterion(StudentCommittedConflict.class).inc(assignment, student.countConflictPlacements(value));
        }
        this.iLock.writeLock().lock();
        this.iCommitedConflicts.clear();
        this.iLock.writeLock().unlock();
    }

    public void removeStudent(Assignment<Lecture, Placement> assignment, Student student) {
        Placement value;
        if (!this.iStudents.remove(student)) {
            return;
        }
        Placement placement = value = assignment == null ? null : assignment.getValue(this);
        if (value != null && this.getModel() != null) {
            this.getModel().getCriterion(StudentCommittedConflict.class).inc(assignment, -student.countConflictPlacements(value));
        }
        this.iLock.writeLock().lock();
        this.iCommitedConflicts.clear();
        this.iLock.writeLock().unlock();
    }

    public boolean hasStudent(Student student) {
        return this.iStudents.contains(student);
    }

    public void setSameSubpartLectures(List<Lecture> sameSubpartLectures) {
        this.iSameSubpartLectures = sameSubpartLectures;
    }

    public List<Lecture> sameSubpartLectures() {
        return this.iSameSubpartLectures;
    }

    public Set<Student> sameStudents(Lecture lecture) {
        JenrlConstraint jenrl = this.jenrlConstraint(lecture);
        return jenrl == null ? new HashSet() : jenrl.getStudents();
    }

    public Set<Student> conflictStudents(Assignment<Lecture, Placement> assignment, Placement value) {
        if (value == null) {
            return new HashSet<Student>();
        }
        if (value.equals(assignment.getValue(this))) {
            return this.conflictStudents(assignment);
        }
        HashSet<Student> ret = new HashSet<Student>();
        for (JenrlConstraint jenrl : this.jenrlConstraints()) {
            if (jenrl.jenrl(assignment, this, value) <= 0L) continue;
            ret.addAll(this.sameStudents(jenrl.another(this)));
        }
        return ret;
    }

    public Set<Student> conflictStudents(Assignment<Lecture, Placement> assignment) {
        HashSet<Student> ret = new HashSet<Student>();
        Placement placement = assignment.getValue(this);
        if (placement == null) {
            return ret;
        }
        for (JenrlConstraint jenrl : this.activeJenrls(assignment)) {
            ret.addAll(this.sameStudents(jenrl.another(this)));
        }
        for (Student student : this.students()) {
            if (student.countConflictPlacements(placement) <= 0) continue;
            ret.add(student);
        }
        return ret;
    }

    public List<Lecture> conflictLectures(Assignment<Lecture, Placement> assignment, Student student) {
        ArrayList<Lecture> ret = new ArrayList<Lecture>();
        if (assignment.getValue(this) == null) {
            return ret;
        }
        for (JenrlConstraint jenrl : this.activeJenrls(assignment)) {
            Lecture lect = jenrl.another(this);
            if (!lect.students().contains(student)) continue;
            ret.add(lect);
        }
        return ret;
    }

    public int isInConflict(Assignment<Lecture, Placement> assignment, Student student) {
        if (assignment.getValue(this) == null) {
            return 0;
        }
        int ret = 0;
        for (JenrlConstraint jenrl : this.activeJenrls(assignment)) {
            Lecture lect = jenrl.another(this);
            if (!lect.students().contains(student)) continue;
            ++ret;
        }
        return ret;
    }

    private boolean isCacheDomain() {
        return this.isCommitted() || !sSaveMemory && (this.iNrRooms <= 1 || this.getMaxRoomCombinations() <= 0 || ToolBox.binomial(this.iRoomLocations.size(), this.iNrRooms) <= (long)this.getMaxRoomCombinations());
    }

    public List<Placement> computeValues(Assignment<Lecture, Placement> assignment, boolean allowBreakHard) {
        ArrayList<Placement> values = new ArrayList<Placement>(this.iRoomLocations.size() * this.iTimeLocations.size());
        for (TimeLocation timeLocation : this.iTimeLocations) {
            Placement p;
            Placement p2;
            if (!allowBreakHard && "P".equals(Constants.preferenceLevel2preference(timeLocation.getPreference())) || timeLocation.getPreference() > 500) continue;
            boolean notAvailable = false;
            for (InstructorConstraint ic : this.getInstructorConstraints()) {
                if (ic.isAvailable(this, timeLocation)) continue;
                notAvailable = true;
                break;
            }
            if (notAvailable) continue;
            if (this.iNrRooms == 0) {
                p2 = new Placement(this, timeLocation, (RoomLocation)null);
                for (InstructorConstraint ic : this.getInstructorConstraints()) {
                    if (ic.isAvailable(this, p2)) continue;
                    notAvailable = true;
                    break;
                }
                if (notAvailable) continue;
                p2.setVariable(this);
                if (sSaveMemory && !this.isValid(p2)) continue;
                if (this.getInitialAssignment() != null && p2.equals(this.getInitialAssignment())) {
                    this.setInitialAssignment(p2);
                }
                if (this.getBestAssignment() != null && ((Placement)this.getBestAssignment()).equals(p2)) {
                    this.setBestAssignment(p2, this.getBestAssignmentIteration());
                }
                values.add(p2);
                continue;
            }
            if (this.iNrRooms == 1) {
                for (RoomLocation roomLocation : this.iRoomLocations) {
                    if (!allowBreakHard && "P".equals(Constants.preferenceLevel2preference(roomLocation.getPreference())) || roomLocation.getPreference() > 500 || roomLocation.getRoomConstraint() != null && !roomLocation.getRoomConstraint().isAvailable(this, timeLocation, this.getScheduler())) continue;
                    p = new Placement(this, timeLocation, roomLocation);
                    p.setVariable(this);
                    if (sSaveMemory && !this.isValid(p)) continue;
                    if (this.getInitialAssignment() != null && p.equals(this.getInitialAssignment())) {
                        this.setInitialAssignment(p);
                    }
                    if (this.getBestAssignment() != null && ((Placement)this.getBestAssignment()).equals(p)) {
                        this.setBestAssignment(p, this.getBestAssignmentIteration());
                    }
                    values.add(p);
                }
                continue;
            }
            if (this.getMaxRoomCombinations() > 0 && ToolBox.binomial(this.iRoomLocations.size(), this.iNrRooms) > (long)this.getMaxRoomCombinations()) {
                if (this.getInitialAssignment() != null && ((Placement)this.getInitialAssignment()).getNrRooms() == this.getNrRooms()) {
                    p2 = new Placement(this, timeLocation, new ArrayList<RoomLocation>(((Placement)this.getInitialAssignment()).getRoomLocations()));
                    p2.setVariable(this);
                    if (p2.equals(this.getInitialAssignment())) {
                        this.setInitialAssignment(p2);
                    }
                    values.add(p2);
                }
                ArrayList<RoomLocation> available = new ArrayList<RoomLocation>(this.iRoomLocations.size());
                ArrayList<RoomLocation> other = new ArrayList<RoomLocation>(this.iRoomLocations.size());
                for (RoomLocation room : this.iRoomLocations) {
                    if (room.getRoomConstraint() != null && !room.getRoomConstraint().isAvailable(this, timeLocation, this.getScheduler()) || "P".equals(Constants.preferenceLevel2preference(room.getPreference()))) continue;
                    if (assignment != null && room.getRoomConstraint() != null && !((RoomConstraint.RoomConstraintContext)room.getRoomConstraint().getContext((Assignment)assignment)).inConflict(this, timeLocation)) {
                        available.add(room);
                        continue;
                    }
                    other.add(room);
                }
                if (available.size() + other.size() < this.iNrRooms) continue;
                Enumeration e = ToolBox.sample(available, other, this.iNrRooms, this.getMaxRoomCombinations());
                while (e.hasMoreElements()) {
                    Placement p3 = new Placement(this, timeLocation, new ArrayList<RoomLocation>(e.nextElement()));
                    if (this.getInitialAssignment() != null && p3.sameRooms((Placement)this.getInitialAssignment())) continue;
                    p3.setVariable(this);
                    values.add(p3);
                }
                continue;
            }
            ArrayList<RoomLocation> rooms = new ArrayList<RoomLocation>(this.iRoomLocations.size());
            for (RoomLocation room : this.iRoomLocations) {
                if (!allowBreakHard && "P".equals(Constants.preferenceLevel2preference(room.getPreference())) || room.getRoomConstraint() != null && !room.getRoomConstraint().isAvailable(this, timeLocation, this.getScheduler())) continue;
                rooms.add(room);
            }
            if (rooms.size() < this.iNrRooms) continue;
            Enumeration e = ToolBox.permutations(rooms, this.iNrRooms);
            while (e.hasMoreElements()) {
                p = new Placement(this, timeLocation, new ArrayList<RoomLocation>(e.nextElement()));
                p.setVariable(this);
                if (sSaveMemory && !this.isValid(p)) continue;
                if (this.getInitialAssignment() != null && p.equals(this.getInitialAssignment())) {
                    this.setInitialAssignment(p);
                }
                if (this.getBestAssignment() != null && ((Placement)this.getBestAssignment()).equals(p)) {
                    this.setBestAssignment(p, this.getBestAssignmentIteration());
                }
                values.add(p);
            }
        }
        return values;
    }

    public void clearValueCache() {
        super.setValues(null);
    }

    @Override
    public List<Placement> values(Assignment<Lecture, Placement> assignment) {
        if (super.values(assignment) == null) {
            if (this.getInitialAssignment() != null && this.iTimeLocations.size() == 1 && this.iRoomLocations.size() == this.getNrRooms()) {
                ArrayList<Placement> values = new ArrayList<Placement>(1);
                values.add((Placement)this.getInitialAssignment());
                this.setValues(values);
                return values;
            }
            if (this.isCacheDomain()) {
                List<Placement> values = this.computeValues(null, sAllowBreakHard);
                this.setValues(values);
                return values;
            }
            return this.computeValues(assignment, sAllowBreakHard);
        }
        return super.values(assignment);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Lecture)) {
            return false;
        }
        return this.getClassId().equals(((Lecture)o).getClassId());
    }

    public double getBestTimePreference() {
        if (this.iBestTimePreferenceCache == null) {
            double ret = Double.MAX_VALUE;
            for (TimeLocation time : this.iTimeLocations) {
                ret = Math.min(ret, time.getNormalizedPreference());
            }
            this.iBestTimePreferenceCache = new Double(ret);
        }
        return this.iBestTimePreferenceCache;
    }

    public int getBestRoomPreference() {
        int ret = Integer.MAX_VALUE;
        for (RoomLocation room : this.iRoomLocations) {
            ret = Math.min(ret, room.getPreference());
        }
        return ret;
    }

    public int countStudentConflicts(Assignment<Lecture, Placement> assignment, Placement value) {
        int studentConflictsSum = 0;
        for (JenrlConstraint jenrl : this.jenrlConstraints()) {
            studentConflictsSum = (int)((long)studentConflictsSum + jenrl.jenrl(assignment, this, value));
        }
        return studentConflictsSum;
    }

    public int countStudentConflictsOfTheSameProblem(Assignment<Lecture, Placement> assignment, Placement value) {
        int studentConflictsSum = 0;
        for (JenrlConstraint jenrl : this.jenrlConstraints()) {
            if (!jenrl.isOfTheSameProblem()) continue;
            studentConflictsSum = (int)((long)studentConflictsSum + jenrl.jenrl(assignment, this, value));
        }
        return studentConflictsSum;
    }

    public int countHardStudentConflicts(Assignment<Lecture, Placement> assignment, Placement value) {
        int studentConflictsSum = 0;
        if (!this.isSingleSection()) {
            return 0;
        }
        for (JenrlConstraint jenrl : this.jenrlConstraints()) {
            if (!jenrl.areStudentConflictsHard()) continue;
            studentConflictsSum = (int)((long)studentConflictsSum + jenrl.jenrl(assignment, this, value));
        }
        return studentConflictsSum;
    }

    public int countCommittedStudentConflictsOfTheSameProblem(Assignment<Lecture, Placement> assignment, Placement value) {
        int studentConflictsSum = 0;
        for (JenrlConstraint jenrl : this.jenrlConstraints()) {
            if (!jenrl.isOfTheSameProblem() || !jenrl.areStudentConflictsCommitted()) continue;
            studentConflictsSum = (int)((long)studentConflictsSum + jenrl.jenrl(assignment, this, value));
        }
        return studentConflictsSum;
    }

    public int countCommittedStudentConflicts(Assignment<Lecture, Placement> assignment, Placement value) {
        int studentConflictsSum = 0;
        for (JenrlConstraint jenrl : this.jenrlConstraints()) {
            if (!jenrl.areStudentConflictsCommitted()) continue;
            studentConflictsSum = (int)((long)studentConflictsSum + jenrl.jenrl(assignment, this, value));
        }
        return studentConflictsSum;
    }

    public int countHardStudentConflictsOfTheSameProblem(Assignment<Lecture, Placement> assignment, Placement value) {
        int studentConflictsSum = 0;
        for (JenrlConstraint jenrl : this.jenrlConstraints()) {
            if (!jenrl.isOfTheSameProblem() || !jenrl.areStudentConflictsHard()) continue;
            studentConflictsSum = (int)((long)studentConflictsSum + jenrl.jenrl(assignment, this, value));
        }
        return studentConflictsSum;
    }

    public int countDistanceStudentConflicts(Assignment<Lecture, Placement> assignment, Placement value) {
        int studentConflictsSum = 0;
        for (JenrlConstraint jenrl : this.jenrlConstraints()) {
            if (!jenrl.areStudentConflictsDistance(assignment, value)) continue;
            studentConflictsSum = (int)((long)studentConflictsSum + jenrl.jenrl(assignment, this, value));
        }
        return studentConflictsSum;
    }

    public int countDistanceStudentConflictsOfTheSameProblem(Assignment<Lecture, Placement> assignment, Placement value) {
        int studentConflictsSum = 0;
        for (JenrlConstraint jenrl : this.jenrlConstraints()) {
            if (!jenrl.isOfTheSameProblem() || !jenrl.areStudentConflictsDistance(assignment, value)) continue;
            studentConflictsSum = (int)((long)studentConflictsSum + jenrl.jenrl(assignment, this, value));
        }
        return studentConflictsSum;
    }

    private DistanceMetric getDistanceMetric() {
        return ((TimetableModel)this.getModel()).getDistanceMetric();
    }

    public int countInitialStudentConflicts() {
        Placement value = (Placement)this.getInitialAssignment();
        if (value == null) {
            return 0;
        }
        int studentConflictsSum = 0;
        for (JenrlConstraint jenrl : this.jenrlConstraints()) {
            Lecture another = jenrl.another(this);
            if (another.getInitialAssignment() == null || !JenrlConstraint.isInConflict(value, (Placement)another.getInitialAssignment(), this.getDistanceMetric())) continue;
            studentConflictsSum = (int)((long)studentConflictsSum + jenrl.getJenrl());
        }
        return studentConflictsSum;
    }

    public Map<Lecture, Long> getInitialStudentConflicts() {
        Placement value = (Placement)this.getInitialAssignment();
        if (value == null) {
            return null;
        }
        HashMap<Lecture, Long> ret = new HashMap<Lecture, Long>();
        for (JenrlConstraint jenrl : this.jenrlConstraints()) {
            Lecture another = jenrl.another(this);
            if (another.getInitialAssignment() == null || !JenrlConstraint.isInConflict(value, (Placement)another.getInitialAssignment(), this.getDistanceMetric())) continue;
            ret.put(another, jenrl.getJenrl());
        }
        return ret;
    }

    public Set<Student> initialStudentConflicts() {
        Placement value = (Placement)this.getInitialAssignment();
        if (value == null) {
            return null;
        }
        HashSet<Student> ret = new HashSet<Student>();
        for (JenrlConstraint jenrl : this.jenrlConstraints()) {
            Lecture another = jenrl.another(this);
            if (another.getInitialAssignment() == null || !JenrlConstraint.isInConflict(value, (Placement)another.getInitialAssignment(), this.getDistanceMetric())) continue;
            ret.addAll(this.sameStudents(another));
        }
        return ret;
    }

    @Override
    public void addContstraint(Constraint<Lecture, Placement> constraint) {
        super.addContstraint(constraint);
        if (constraint instanceof WeakeningConstraint) {
            this.iWeakeningConstraints.add(constraint);
        }
        if (constraint instanceof FlexibleConstraint) {
            this.iFlexibleGroupConstraints.add((FlexibleConstraint)constraint);
        }
        if (constraint instanceof JenrlConstraint) {
            JenrlConstraint jenrl = (JenrlConstraint)constraint;
            Lecture another = jenrl.another(this);
            if (another != null) {
                this.iJenrlConstraints.add(jenrl);
                another.iJenrlConstraints.add(jenrl);
                this.iJenrlConstraintsHash.put(another, (JenrlConstraint)constraint);
                another.iJenrlConstraintsHash.put(this, (JenrlConstraint)constraint);
            }
        } else if (constraint instanceof DepartmentSpreadConstraint) {
            this.iDeptSpreadConstraint = (DepartmentSpreadConstraint)constraint;
        } else if (constraint instanceof SpreadConstraint) {
            this.iSpreadConstraints.add((SpreadConstraint)constraint);
        } else if (constraint instanceof InstructorConstraint) {
            InstructorConstraint ic = (InstructorConstraint)constraint;
            if (ic.getResourceId() != null && ic.getResourceId() > 0L) {
                this.iInstructorConstraints.add(ic);
            }
        } else if (constraint instanceof ClassLimitConstraint) {
            this.iClassLimitConstraint = (ClassLimitConstraint)constraint;
        } else if (constraint instanceof GroupConstraint) {
            GroupConstraint gc = (GroupConstraint)constraint;
            if (gc.canShareRoom()) {
                this.iCanShareRoomGroupConstraints.add((GroupConstraint)constraint);
            } else {
                this.iGroupConstraints.add((GroupConstraint)constraint);
                if ("P".equals(Constants.preferenceLevel2preference(gc.getPreference())) || "R".equals(Constants.preferenceLevel2preference(gc.getPreference()))) {
                    this.iHardGroupSoftConstraints.add((GroupConstraint)constraint);
                }
            }
        }
    }

    @Override
    public void removeContstraint(Constraint<Lecture, Placement> constraint) {
        super.removeContstraint(constraint);
        if (constraint instanceof WeakeningConstraint) {
            this.iWeakeningConstraints.remove(constraint);
        }
        if (constraint instanceof FlexibleConstraint) {
            this.iFlexibleGroupConstraints.remove(constraint);
        }
        if (constraint instanceof JenrlConstraint) {
            JenrlConstraint jenrl = (JenrlConstraint)constraint;
            Lecture another = jenrl.another(this);
            if (another != null) {
                this.iJenrlConstraints.remove(jenrl);
                another.iJenrlConstraints.remove(jenrl);
                this.iJenrlConstraintsHash.remove(another);
                another.iJenrlConstraintsHash.remove(this);
            }
        } else if (constraint instanceof GroupConstraint) {
            this.iCanShareRoomGroupConstraints.remove(constraint);
            this.iHardGroupSoftConstraints.remove(constraint);
            this.iGroupConstraints.remove(constraint);
        } else if (constraint instanceof DepartmentSpreadConstraint) {
            this.iDeptSpreadConstraint = null;
        } else if (constraint instanceof SpreadConstraint) {
            this.iSpreadConstraints.remove(constraint);
        } else if (constraint instanceof InstructorConstraint) {
            this.iInstructorConstraints.remove(constraint);
        } else if (constraint instanceof ClassLimitConstraint) {
            this.iClassLimitConstraint = null;
        }
    }

    public JenrlConstraint jenrlConstraint(Lecture another) {
        return this.iJenrlConstraintsHash.get(another);
    }

    public List<JenrlConstraint> jenrlConstraints() {
        return this.iJenrlConstraints;
    }

    public int minClassLimit() {
        return this.iMinClassLimit;
    }

    public int maxClassLimit() {
        return this.iMaxClassLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int maxAchievableClassLimit() {
        this.iLock.readLock().lock();
        try {
            if (this.iCacheMaxAchievableClassLimit != null) {
                int n = this.iCacheMaxAchievableClassLimit;
                return n;
            }
        }
        finally {
            this.iLock.readLock().unlock();
        }
        this.iLock.writeLock().lock();
        try {
            if (this.iCacheMaxAchievableClassLimit != null) {
                int n = this.iCacheMaxAchievableClassLimit;
                return n;
            }
            int maxAchievableClassLimit = Math.min(this.maxClassLimit(), (int)Math.floor((double)this.maxRoomSize() / this.roomToLimitRatio()));
            if (this.hasAnyChildren()) {
                for (Long subpartId : this.getChildrenSubpartIds()) {
                    int maxAchievableChildrenLimit = 0;
                    for (Lecture child : this.getChildren(subpartId)) {
                        maxAchievableChildrenLimit += child.maxAchievableClassLimit();
                    }
                    maxAchievableClassLimit = Math.min(maxAchievableClassLimit, maxAchievableChildrenLimit);
                }
            }
            maxAchievableClassLimit = Math.max(this.minClassLimit(), maxAchievableClassLimit);
            this.iCacheMaxAchievableClassLimit = new Integer(maxAchievableClassLimit);
            int n = maxAchievableClassLimit;
            return n;
        }
        finally {
            this.iLock.writeLock().unlock();
        }
    }

    public int classLimit(Assignment<Lecture, Placement> assignment) {
        if (this.minClassLimit() == this.maxClassLimit()) {
            return this.minClassLimit();
        }
        return this.classLimit(assignment, null, null);
    }

    public int classLimit(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        int classLimit;
        Placement a;
        Placement placement = a = assignment == null ? null : assignment.getValue(this);
        if (value != null && ((Lecture)value.variable()).equals(this)) {
            a = value;
        }
        if (conflicts != null && a != null && conflicts.contains(a)) {
            a = null;
        }
        int n = classLimit = a == null ? this.maxAchievableClassLimit() : Math.min(this.maxClassLimit(), (int)Math.floor((double)a.getRoomSize() / this.roomToLimitRatio()));
        if (!this.hasAnyChildren()) {
            return classLimit;
        }
        for (Long subpartId : this.getChildrenSubpartIds()) {
            int childrenClassLimit = 0;
            for (Lecture child : this.getChildren(subpartId)) {
                childrenClassLimit += child.classLimit(assignment, value, conflicts);
            }
            classLimit = Math.min(classLimit, childrenClassLimit);
        }
        return Math.max(this.minClassLimit(), classLimit);
    }

    public double roomToLimitRatio() {
        return this.iRoomToLimitRatio;
    }

    public int minRoomUse() {
        return Math.round((float)this.iMinClassLimit * this.iRoomToLimitRatio);
    }

    public int maxRoomUse() {
        return Math.round((float)this.iMaxClassLimit * this.iRoomToLimitRatio);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public Long getDepartment() {
        return this.iDept;
    }

    public void setDepartment(Long dept) {
        this.iDept = dept;
    }

    public Long getScheduler() {
        return this.iScheduler;
    }

    public void setScheduler(Long scheduler) {
        this.iScheduler = scheduler;
    }

    public DepartmentSpreadConstraint getDeptSpreadConstraint() {
        return this.iDeptSpreadConstraint;
    }

    public List<InstructorConstraint> getInstructorConstraints() {
        return this.iInstructorConstraints;
    }

    public ClassLimitConstraint getClassLimitConstraint() {
        return this.iClassLimitConstraint;
    }

    public Set<SpreadConstraint> getSpreadConstraints() {
        return this.iSpreadConstraints;
    }

    public Set<FlexibleConstraint> getFlexibleGroupConstraints() {
        return this.iFlexibleGroupConstraints;
    }

    public Set<Constraint<Lecture, Placement>> getWeakeningConstraints() {
        return this.iWeakeningConstraints;
    }

    public List<RoomLocation> roomLocations() {
        return this.iRoomLocations;
    }

    public List<TimeLocation> timeLocations() {
        return this.iTimeLocations;
    }

    public int nrTimeLocations() {
        int ret = 0;
        for (TimeLocation time : this.iTimeLocations) {
            if ("P".equals(Constants.preferenceLevel2preference(time.getPreference()))) continue;
            ++ret;
        }
        return ret;
    }

    public int nrRoomLocations() {
        int ret = 0;
        for (RoomLocation room : this.iRoomLocations) {
            if ("P".equals(Constants.preferenceLevel2preference(room.getPreference()))) continue;
            ++ret;
        }
        return ret;
    }

    public long nrValues() {
        int nrTimes = 0;
        for (TimeLocation time : this.timeLocations()) {
            if ("P".equals(Constants.preferenceLevel2preference(time.getPreference()))) continue;
            ++nrTimes;
        }
        int nrRooms = 0;
        for (RoomLocation room : this.iRoomLocations) {
            if ("P".equals(Constants.preferenceLevel2preference(room.getPreference()))) continue;
            ++nrRooms;
        }
        long estNrValues = nrTimes;
        estNrValues = this.getNrRooms() > 1 && this.getMaxRoomCombinations() > 0 ? (estNrValues *= Math.min((long)this.getMaxRoomCombinations(), ToolBox.binomial(nrRooms, this.getNrRooms()))) : (estNrValues *= ToolBox.binomial(nrRooms, this.getNrRooms()));
        return estNrValues;
    }

    public int nrValues(TimeLocation time) {
        int ret = 0;
        for (RoomLocation room : this.iRoomLocations) {
            if ("P".equals(Constants.preferenceLevel2preference(room.getPreference())) || room.getRoomConstraint() != null && !room.getRoomConstraint().isAvailable(this, time, this.getScheduler())) continue;
            ++ret;
        }
        return ret;
    }

    public int nrValues(RoomLocation room) {
        int ret = 0;
        for (TimeLocation time : this.iTimeLocations) {
            if ("P".equals(Constants.preferenceLevel2preference(time.getPreference())) || room.getRoomConstraint() != null && !room.getRoomConstraint().isAvailable(this, time, this.getScheduler())) continue;
            ++ret;
        }
        return ret;
    }

    public int nrValues(List<RoomLocation> rooms) {
        int ret = 0;
        for (TimeLocation time : this.iTimeLocations) {
            boolean available = true;
            for (RoomLocation room : rooms) {
                if (!"P".equals(Constants.preferenceLevel2preference(time.getPreference())) && (room.getRoomConstraint() == null || room.getRoomConstraint().isAvailable(this, time, this.getScheduler()))) continue;
                available = false;
            }
            if (!available) continue;
            ++ret;
        }
        return ret;
    }

    public boolean allowBreakHard() {
        return sAllowBreakHard;
    }

    public int getNrRooms() {
        return this.iNrRooms;
    }

    public Lecture getParent() {
        return this.iParent;
    }

    public void setParent(Lecture parent) {
        this.iParent = parent;
        this.iParent.addChild(this);
    }

    public boolean hasParent() {
        return this.iParent != null;
    }

    public boolean hasChildren(Long subpartId) {
        return this.iChildren != null && this.iChildren.get(subpartId) != null && !this.iChildren.get(subpartId).isEmpty();
    }

    public boolean hasAnyChildren() {
        return this.iChildren != null && !this.iChildren.isEmpty();
    }

    public List<Lecture> getChildren(Long subpartId) {
        return this.iChildren.get(subpartId);
    }

    public Set<Long> getChildrenSubpartIds() {
        return this.iChildren == null ? null : this.iChildren.keySet();
    }

    private void addChild(Lecture child) {
        List<Lecture> childrenThisSubpart;
        if (this.iChildren == null) {
            this.iChildren = new HashMap();
        }
        if ((childrenThisSubpart = this.iChildren.get(child.getSchedulingSubpartId())) == null) {
            childrenThisSubpart = new ArrayList<Lecture>();
            this.iChildren.put(child.getSchedulingSubpartId(), childrenThisSubpart);
        }
        childrenThisSubpart.add(child);
    }

    public boolean isSingleSection() {
        return this.iSameSubpartLectures == null || this.iSameSubpartLectures.size() <= 1;
    }

    public List<Lecture> sameStudentsLectures() {
        return this.hasParent() ? this.getParent().getChildren(this.getSchedulingSubpartId()) : this.sameSubpartLectures();
    }

    public Lecture getChild(Student student, Long subpartId) {
        if (!this.hasAnyChildren()) {
            return null;
        }
        List<Lecture> children = this.getChildren(subpartId);
        if (children == null) {
            return null;
        }
        for (Lecture child : children) {
            if (!child.students().contains(student)) continue;
            return child;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCommitedConflicts(Placement placement) {
        this.iLock.readLock().lock();
        try {
            Integer ret = this.iCommitedConflicts.get(placement);
            if (ret != null) {
                int n = ret;
                return n;
            }
        }
        finally {
            this.iLock.readLock().unlock();
        }
        this.iLock.writeLock().lock();
        try {
            int ret = placement.getCommitedConflicts();
            this.iCommitedConflicts.put(placement, ret);
            int n = ret;
            return n;
        }
        finally {
            this.iLock.writeLock().unlock();
        }
    }

    public Set<GroupConstraint> hardGroupSoftConstraints() {
        return this.iHardGroupSoftConstraints;
    }

    public Set<GroupConstraint> groupConstraints() {
        return this.iGroupConstraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int minRoomSize() {
        this.iLock.readLock().lock();
        try {
            if (this.iCacheMinRoomSize != null) {
                int n = this.iCacheMinRoomSize;
                return n;
            }
        }
        finally {
            this.iLock.readLock().unlock();
        }
        this.iLock.writeLock().lock();
        try {
            if (this.iCacheMinRoomSize != null) {
                int n = this.iCacheMinRoomSize;
                return n;
            }
            if (this.getNrRooms() <= 1) {
                int min = Integer.MAX_VALUE;
                for (RoomLocation r : this.roomLocations()) {
                    if (r.getPreference() > 50) continue;
                    min = Math.min(min, r.getRoomSize());
                }
                this.iCacheMinRoomSize = new Integer(min);
                int i$ = min;
                return i$;
            }
            ArrayList<RoomLocation> rooms = new ArrayList<RoomLocation>();
            for (RoomLocation r : this.roomLocations()) {
                if (r.getPreference() > 50) continue;
                rooms.add(r);
            }
            Collections.sort(rooms, new Comparator<RoomLocation>(){

                @Override
                public int compare(RoomLocation r1, RoomLocation r2) {
                    if (r1.getRoomSize() < r2.getRoomSize()) {
                        return -1;
                    }
                    if (r1.getRoomSize() > r2.getRoomSize()) {
                        return 1;
                    }
                    return r1.compareTo(r2);
                }
            });
            int min = rooms.isEmpty() ? 0 : ((RoomLocation)rooms.get(Math.min(this.getNrRooms(), rooms.size()) - 1)).getRoomSize();
            this.iCacheMinRoomSize = new Integer(min);
            int n = min;
            return n;
        }
        finally {
            this.iLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int maxRoomSize() {
        this.iLock.readLock().lock();
        try {
            if (this.iCacheMaxRoomSize != null) {
                int n = this.iCacheMaxRoomSize;
                return n;
            }
        }
        finally {
            this.iLock.readLock().unlock();
        }
        this.iLock.writeLock().lock();
        try {
            if (this.iCacheMaxRoomSize != null) {
                int n = this.iCacheMaxRoomSize;
                return n;
            }
            if (this.getNrRooms() <= 1) {
                int max = Integer.MIN_VALUE;
                for (RoomLocation r : this.roomLocations()) {
                    if (r.getPreference() > 50) continue;
                    max = Math.max(max, r.getRoomSize());
                }
                this.iCacheMaxRoomSize = new Integer(max);
                int i$ = max;
                return i$;
            }
            ArrayList<RoomLocation> rooms = new ArrayList<RoomLocation>();
            for (RoomLocation r : this.roomLocations()) {
                if (r.getPreference() > 50) continue;
                rooms.add(r);
            }
            Collections.sort(rooms, new Comparator<RoomLocation>(){

                @Override
                public int compare(RoomLocation r1, RoomLocation r2) {
                    if (r1.getRoomSize() > r2.getRoomSize()) {
                        return -1;
                    }
                    if (r1.getRoomSize() < r2.getRoomSize()) {
                        return 1;
                    }
                    return r1.compareTo(r2);
                }
            });
            int max = rooms.isEmpty() ? 0 : ((RoomLocation)rooms.get(Math.min(this.getNrRooms(), rooms.size()) - 1)).getRoomSize();
            this.iCacheMaxRoomSize = new Integer(max);
            int n = max;
            return n;
        }
        finally {
            this.iLock.writeLock().unlock();
        }
    }

    public boolean canShareRoom() {
        return !this.iCanShareRoomGroupConstraints.isEmpty();
    }

    public boolean canShareRoom(Lecture other) {
        if (other.equals(this)) {
            return true;
        }
        for (GroupConstraint gc : this.iCanShareRoomGroupConstraints) {
            if (!gc.variables().contains(other)) continue;
            return true;
        }
        return false;
    }

    public Set<GroupConstraint> canShareRoomConstraints() {
        return this.iCanShareRoomGroupConstraints;
    }

    public boolean isSingleton() {
        return this.getNrRooms() == this.roomLocations().size() && this.timeLocations().size() == 1;
    }

    public boolean isValid(Placement placement) {
        TimetableModel model = (TimetableModel)this.getModel();
        if (model == null) {
            return true;
        }
        if (model.hasConstantVariables()) {
            for (Placement confPlacement : model.conflictValuesSkipWeakeningConstraints(model.getEmptyAssignment(), placement)) {
                Lecture lecture = (Lecture)confPlacement.variable();
                if (lecture.isCommitted()) {
                    return false;
                }
                if (!confPlacement.equals(placement)) continue;
                return false;
            }
        } else {
            HashSet conflicts = new HashSet();
            for (Constraint constraint : this.hardConstraints()) {
                if (constraint instanceof WeakeningConstraint) continue;
                constraint.computeConflicts(model.getEmptyAssignment(), placement, conflicts);
            }
            for (GlobalConstraint globalConstraint : model.globalConstraints()) {
                if (globalConstraint instanceof WeakeningConstraint) continue;
                globalConstraint.computeConflicts(model.getEmptyAssignment(), placement, conflicts);
            }
            if (conflicts.contains(placement)) {
                return false;
            }
        }
        return true;
    }

    public String getNotValidReason(Assignment<Lecture, Placement> assignment, Placement placement, boolean useAmPm) {
        TimetableModel model = (TimetableModel)this.getModel();
        if (model == null) {
            return "no model for class " + this.getName();
        }
        Map<Constraint<Lecture, Placement>, Set<Placement>> conflictConstraints = model.conflictConstraints(assignment, placement);
        for (Map.Entry<Constraint<Lecture, Placement>, Set<Placement>> entry : conflictConstraints.entrySet()) {
            Constraint<Lecture, Placement> constraint = entry.getKey();
            Set<Placement> conflicts = entry.getValue();
            String cname = constraint.getName();
            if (constraint instanceof RoomConstraint) {
                cname = "Room " + constraint.getName();
            } else if (constraint instanceof InstructorConstraint) {
                cname = "Instructor " + constraint.getName();
            } else if (constraint instanceof GroupConstraint) {
                cname = "Distribution " + constraint.getName();
            } else if (constraint instanceof DepartmentSpreadConstraint) {
                cname = "Balancing of department " + constraint.getName();
            } else if (constraint instanceof SpreadConstraint) {
                cname = "Same subpart spread " + constraint.getName();
            } else if (constraint instanceof ClassLimitConstraint) {
                cname = "Class limit " + constraint.getName();
            }
            for (Placement confPlacement : conflicts) {
                Lecture lecture = (Lecture)confPlacement.variable();
                if (lecture.isCommitted()) {
                    return placement.getLongName(useAmPm) + " conflicts with " + lecture.getName() + " " + confPlacement.getLongName(useAmPm) + " due to constraint " + cname;
                }
                if (!confPlacement.equals(placement)) continue;
                return placement.getLongName(useAmPm) + " is not valid due to constraint " + cname;
            }
        }
        return null;
    }

    @Deprecated
    public String getNotValidReason(Assignment<Lecture, Placement> assignment, Placement placement) {
        return this.getNotValidReason(assignment, placement, true);
    }

    public void purgeInvalidValues(boolean interactiveMode) {
        if (this.isCommitted() || sSaveMemory) {
            return;
        }
        TimetableModel model = (TimetableModel)this.getModel();
        if (model == null) {
            return;
        }
        ArrayList<Placement> newValues = new ArrayList<Placement>(this.values((Assignment<Lecture, Placement>)null).size());
        for (Placement placement : this.values((Assignment<Lecture, Placement>)null)) {
            if (!placement.isValid()) continue;
            newValues.add(placement);
        }
        if (!interactiveMode && newValues.size() != this.values((Assignment<Lecture, Placement>)null).size()) {
            boolean hasPlacement;
            Iterator<Object> i = this.timeLocations().iterator();
            while (i.hasNext()) {
                TimeLocation timeLocation = i.next();
                hasPlacement = false;
                for (Placement placement : newValues) {
                    if (!timeLocation.equals(placement.getTimeLocation())) continue;
                    hasPlacement = true;
                    break;
                }
                if (hasPlacement) continue;
                i.remove();
            }
            i = this.roomLocations().iterator();
            while (i.hasNext()) {
                RoomLocation roomLocation = (RoomLocation)i.next();
                hasPlacement = false;
                for (Placement placement : newValues) {
                    if (placement.isMultiRoom()) {
                        if (!placement.getRoomLocations().contains(roomLocation)) continue;
                        hasPlacement = true;
                        break;
                    }
                    if (!roomLocation.equals(placement.getRoomLocation())) continue;
                    hasPlacement = true;
                    break;
                }
                if (hasPlacement) continue;
                i.remove();
            }
        }
        this.setValues(newValues);
    }

    public void setCommitted(boolean committed) {
        this.iCommitted = committed;
    }

    public boolean isCommitted() {
        return this.iCommitted;
    }

    @Override
    public boolean isConstant() {
        return this.iCommitted;
    }

    @Override
    public Placement getConstantValue() {
        return this.isCommitted() ? (Placement)this.getInitialAssignment() : null;
    }

    public void setConstantValue(Placement value) {
        this.setInitialAssignment(value);
    }

    public int getSpreadPenalty(Assignment<Lecture, Placement> assignment) {
        int spread = 0;
        for (SpreadConstraint sc : this.getSpreadConstraints()) {
            spread += sc.getPenalty(assignment);
        }
        return spread;
    }

    @Override
    public int hashCode() {
        return this.getClassId().hashCode();
    }

    public Configuration getConfiguration() {
        Lecture lecture = this;
        while (lecture.getParent() != null) {
            lecture = lecture.getParent();
        }
        return lecture.iParentConfiguration;
    }

    public void setConfiguration(Configuration configuration) {
        Lecture lecture = this;
        while (lecture.getParent() != null) {
            lecture = lecture.getParent();
        }
        lecture.iParentConfiguration = configuration;
        configuration.addTopLecture(lecture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getMinMaxRoomPreference() {
        this.iLock.readLock().lock();
        try {
            if (this.iMinMaxRoomPreference != null) {
                int[] nArray = this.iMinMaxRoomPreference;
                return nArray;
            }
        }
        finally {
            this.iLock.readLock().unlock();
        }
        this.iLock.writeLock().lock();
        try {
            if (this.iMinMaxRoomPreference != null) {
                int[] nArray = this.iMinMaxRoomPreference;
                return nArray;
            }
            if (this.getNrRooms() <= 0 || this.roomLocations().isEmpty()) {
                this.iMinMaxRoomPreference = new int[]{0, 0};
            } else {
                Integer minRoomPref = null;
                Integer maxRoomPref = null;
                for (RoomLocation r : this.roomLocations()) {
                    int pref = r.getPreference();
                    if (pref < -50 || pref > 50) continue;
                    minRoomPref = minRoomPref == null ? pref : Math.min(minRoomPref, pref);
                    maxRoomPref = maxRoomPref == null ? pref : Math.max(maxRoomPref, pref);
                }
                this.iMinMaxRoomPreference = new int[]{minRoomPref == null ? 0 : minRoomPref, maxRoomPref == null ? 0 : maxRoomPref};
            }
            int[] nArray = this.iMinMaxRoomPreference;
            return nArray;
        }
        finally {
            this.iLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getMinMaxTimePreference() {
        this.iLock.readLock().lock();
        try {
            if (this.iMinMaxTimePreference != null) {
                double[] dArray = this.iMinMaxTimePreference;
                return dArray;
            }
        }
        finally {
            this.iLock.readLock().unlock();
        }
        this.iLock.writeLock().lock();
        try {
            if (this.iMinMaxTimePreference != null) {
                double[] dArray = this.iMinMaxTimePreference;
                return dArray;
            }
            Double minTimePref = null;
            Double maxTimePref = null;
            for (TimeLocation t : this.timeLocations()) {
                double npref = t.getNormalizedPreference();
                int pref = t.getPreference();
                if (pref < -50 || pref > 50) continue;
                minTimePref = minTimePref == null ? npref : Math.min(minTimePref, npref);
                maxTimePref = maxTimePref == null ? npref : Math.max(maxTimePref, npref);
            }
            double[] dArray = this.iMinMaxTimePreference = new double[]{minTimePref == null ? 0.0 : minTimePref, maxTimePref == null ? 0.0 : maxTimePref};
            return dArray;
        }
        finally {
            this.iLock.writeLock().unlock();
        }
    }

    public void setOrd(int ord) {
        this.iOrd = ord;
    }

    public int getOrd() {
        return this.iOrd;
    }

    @Override
    public int compareTo(Lecture o) {
        int cmp = Double.compare(this.getOrd(), o.getOrd());
        if (cmp != 0) {
            return cmp;
        }
        return super.compareTo(o);
    }

    public String getNote() {
        return this.iNote;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    public boolean areStudentConflictsHard(Lecture other) {
        return StudentConflict.hard(this, other);
    }

    public void clearIgnoreStudentConflictsWithCache() {
        this.iIgnoreStudentConflictsWith.set(null);
    }

    public boolean isToIgnoreStudentConflictsWith(Lecture other) {
        Set<Long> cache = this.iIgnoreStudentConflictsWith.get();
        if (cache != null) {
            return cache.contains(other.getClassId());
        }
        cache = new HashSet<Long>();
        for (Constraint constraint : this.constraints()) {
            if (!(constraint instanceof IgnoreStudentConflictsConstraint)) continue;
            for (Lecture x : constraint.variables()) {
                if (x.equals(this)) continue;
                cache.add(x.getClassId());
            }
        }
        this.iIgnoreStudentConflictsWith.set(cache);
        return cache.contains(other);
    }

    public double getWeight() {
        return this.iWeight;
    }

    public void setWeight(double weight) {
        this.iWeight = weight;
    }

    @Override
    public LectureContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new LectureContext();
    }

    public int getMaxRoomCombinations() {
        return this.iMaxRoomCombinations;
    }

    public void setMaxRoomCombinations(int maxRoomCombinations) {
        this.iMaxRoomCombinations = maxRoomCombinations;
    }

    public class LectureContext
    implements AssignmentContext {
        private Set<JenrlConstraint> iActiveJenrls = new HashSet<JenrlConstraint>();

        public void addActiveJenrl(JenrlConstraint constr) {
            this.iActiveJenrls.add(constr);
        }

        public Set<JenrlConstraint> activeJenrls() {
            return this.iActiveJenrls;
        }

        public void removeActiveJenrl(JenrlConstraint constr) {
            this.iActiveJenrls.remove(constr);
        }
    }
}

