/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.Set;
import org.cpsolver.coursett.criteria.TimetablingCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class RoomPreferences
extends TimetablingCriterion {
    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.RoomPreferenceWeight", 1.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.RoomPreferenceWeight";
    }

    private int preference(Placement value) {
        int pref = value.getRoomPreference();
        if (pref < -50) {
            return ((Lecture)value.variable()).getMinMaxRoomPreference()[0];
        }
        if (pref > 50) {
            return ((Lecture)value.variable()).getMinMaxRoomPreference()[1];
        }
        return pref;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        if (((Lecture)value.variable()).isCommitted()) {
            return 0.0;
        }
        double ret = ((Lecture)value.variable()).getWeight() * (double)this.preference(value);
        if (conflicts != null) {
            for (Placement conflict : conflicts) {
                ret -= ((Lecture)conflict.variable()).getWeight() * (double)this.preference(conflict);
            }
        }
        return ret;
    }

    @Override
    public double[] getBounds(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        for (Lecture lect : variables) {
            if (lect.isCommitted()) continue;
            int[] p = lect.getMinMaxRoomPreference();
            bounds[0] = bounds[0] + lect.getWeight() * (double)p[0];
            bounds[1] = bounds[1] + lect.getWeight() * (double)p[1];
        }
        return bounds;
    }
}

