/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.RoomConstraint;
import org.cpsolver.coursett.criteria.TimetablingCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.util.DataProperties;

public class BrokenTimePatterns
extends TimetablingCriterion {
    private static int sDaysMWF = Constants.DAY_CODES[0] + Constants.DAY_CODES[2] + Constants.DAY_CODES[4];
    private static int sDaysTTh = Constants.DAY_CODES[1] + Constants.DAY_CODES[3];

    public BrokenTimePatterns() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.NoUpdate);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1.0 * config.getPropertyDouble("Comparator.UselessSlotWeight", 0.1);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.UselessSlotsWeight";
    }

    protected double penalty(Assignment<Lecture, Placement> assignment, Placement value) {
        if (value.isMultiRoom()) {
            int ret = 0;
            for (RoomLocation r : value.getRoomLocations()) {
                if (r.getRoomConstraint() == null) continue;
                ret = (int)((double)ret + this.penalty((RoomConstraint.RoomConstraintContext)r.getRoomConstraint().getContext((Assignment)assignment), value));
            }
            return ret;
        }
        return value.getRoomLocation().getRoomConstraint() == null ? 0.0 : this.penalty((RoomConstraint.RoomConstraintContext)value.getRoomLocation().getRoomConstraint().getContext((Assignment)assignment), value);
    }

    protected double penalty(RoomConstraint.RoomConstraintContext rc) {
        return (double)BrokenTimePatterns.countUselessSlotsBrokenTimePatterns(rc) / 6.0;
    }

    protected double penalty(RoomConstraint.RoomConstraintContext rc, Placement value) {
        return (double)BrokenTimePatterns.countUselessSlotsBrokenTimePatterns(rc, value) / 6.0;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        double ret = this.penalty(assignment, value);
        if (conflicts != null) {
            for (Placement conflict : conflicts) {
                ret -= this.penalty(assignment, conflict);
            }
        }
        return ret;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double ret = 0.0;
        HashSet<RoomConstraint> constraints = new HashSet<RoomConstraint>();
        for (Lecture lect : variables) {
            Placement placement = assignment.getValue(lect);
            if (placement == null) continue;
            if (placement.isMultiRoom()) {
                for (RoomLocation r : placement.getRoomLocations()) {
                    if (r.getRoomConstraint() == null || !constraints.add(r.getRoomConstraint())) continue;
                    ret += this.penalty((RoomConstraint.RoomConstraintContext)r.getRoomConstraint().getContext((Assignment)assignment));
                }
                continue;
            }
            if (placement.getRoomLocation().getRoomConstraint() == null || !constraints.add(placement.getRoomLocation().getRoomConstraint())) continue;
            ret += this.penalty((RoomConstraint.RoomConstraintContext)placement.getRoomLocation().getRoomConstraint().getContext((Assignment)assignment));
        }
        return ret;
    }

    @Override
    protected double[] computeBounds(Assignment<Lecture, Placement> assignment) {
        return new double[]{((TimetableModel)this.getModel()).getRoomConstraints().size() * Constants.SLOTS_PER_DAY_NO_EVENINGS * Constants.NR_DAYS_WEEK, 0.0};
    }

    @Override
    public double[] getBounds(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        HashSet<RoomConstraint> constraints = new HashSet<RoomConstraint>();
        for (Lecture lect : variables) {
            Placement placement = assignment.getValue(lect);
            if (placement == null) continue;
            if (placement.isMultiRoom()) {
                for (RoomLocation r : placement.getRoomLocations()) {
                    if (r.getRoomConstraint() == null) continue;
                    constraints.add(r.getRoomConstraint());
                }
                continue;
            }
            if (placement.getRoomLocation().getRoomConstraint() == null) continue;
            constraints.add(placement.getRoomLocation().getRoomConstraint());
        }
        return new double[]{constraints.size() * Constants.SLOTS_PER_DAY_NO_EVENINGS * Constants.NR_DAYS_WEEK, 0.0};
    }

    private static boolean isEmpty(RoomConstraint.RoomConstraintContext rc, int s, int d, Placement placement) {
        List<Placement> assigned = rc.getPlacements(d * 288 + s);
        return assigned.isEmpty() || placement != null && assigned.size() == 1 && ((Lecture)assigned.get(0).variable()).equals(placement.variable());
    }

    protected static int countUselessSlotsBrokenTimePatterns(RoomConstraint.RoomConstraintContext rc, Placement placement) {
        int d;
        int s;
        int ret = 0;
        TimeLocation time = placement.getTimeLocation();
        int slot = time.getStartSlot() % 288;
        int days = time.getDayCode();
        if ((days & sDaysMWF) != 0 && (days & sDaysMWF) != sDaysMWF) {
            for (s = slot; s < slot + time.getLength(); ++s) {
                d = days & sDaysMWF;
                if (d == Constants.DAY_CODES[0] && BrokenTimePatterns.isEmpty(rc, s, 0, placement)) {
                    if (BrokenTimePatterns.isEmpty(rc, s, 2, placement) != BrokenTimePatterns.isEmpty(rc, s, 4, placement)) {
                        ++ret;
                    }
                    if (BrokenTimePatterns.isEmpty(rc, s, 2, placement) || BrokenTimePatterns.isEmpty(rc, s, 4, placement)) continue;
                    --ret;
                    continue;
                }
                if (d == Constants.DAY_CODES[2] && BrokenTimePatterns.isEmpty(rc, s, 2, placement)) {
                    if (BrokenTimePatterns.isEmpty(rc, s, 0, placement) != BrokenTimePatterns.isEmpty(rc, s, 4, placement)) {
                        ++ret;
                    }
                    if (BrokenTimePatterns.isEmpty(rc, s, 0, placement) || BrokenTimePatterns.isEmpty(rc, s, 4, placement)) continue;
                    --ret;
                    continue;
                }
                if (d == Constants.DAY_CODES[4] && BrokenTimePatterns.isEmpty(rc, s, 4, placement)) {
                    if (BrokenTimePatterns.isEmpty(rc, s, 0, placement) != BrokenTimePatterns.isEmpty(rc, s, 2, placement)) {
                        ++ret;
                    }
                    if (BrokenTimePatterns.isEmpty(rc, s, 0, placement) || BrokenTimePatterns.isEmpty(rc, s, 2, placement)) continue;
                    --ret;
                    continue;
                }
                if (d == (Constants.DAY_CODES[0] | Constants.DAY_CODES[2]) && BrokenTimePatterns.isEmpty(rc, s, 0, placement) && BrokenTimePatterns.isEmpty(rc, s, 2, placement)) {
                    if (!BrokenTimePatterns.isEmpty(rc, s, 4, placement)) continue;
                    ++ret;
                    continue;
                }
                if (d == (Constants.DAY_CODES[2] | Constants.DAY_CODES[4]) && BrokenTimePatterns.isEmpty(rc, s, 2, placement) && BrokenTimePatterns.isEmpty(rc, s, 4, placement)) {
                    if (!BrokenTimePatterns.isEmpty(rc, s, 0, placement)) continue;
                    ++ret;
                    continue;
                }
                if (d != (Constants.DAY_CODES[0] | Constants.DAY_CODES[4]) || !BrokenTimePatterns.isEmpty(rc, s, 0, placement) || !BrokenTimePatterns.isEmpty(rc, s, 4, placement) || !BrokenTimePatterns.isEmpty(rc, s, 2, placement)) continue;
                ++ret;
            }
        }
        if ((days & sDaysTTh) != 0 && (days & sDaysTTh) != sDaysTTh) {
            for (s = slot; s < slot + time.getLength(); ++s) {
                if (BrokenTimePatterns.isEmpty(rc, s, 1, placement) && BrokenTimePatterns.isEmpty(rc, s, 3, placement)) {
                    ++ret;
                }
                if ((d = days & sDaysTTh) == Constants.DAY_CODES[1] && BrokenTimePatterns.isEmpty(rc, s, 1, placement) && !BrokenTimePatterns.isEmpty(rc, s, 3, placement)) {
                    --ret;
                }
                if (d != Constants.DAY_CODES[3] || !BrokenTimePatterns.isEmpty(rc, s, 3, placement) || BrokenTimePatterns.isEmpty(rc, s, 1, placement)) continue;
                --ret;
            }
        }
        return ret;
    }

    public static int countUselessSlotsBrokenTimePatterns(RoomConstraint.RoomConstraintContext rc) {
        int ret = 0;
        for (int d = 0; d < Constants.NR_DAYS; ++d) {
            block8: for (int s = 0; s < 288; ++s) {
                int slot = d * 288 + s;
                if (!rc.getPlacements(slot).isEmpty()) continue;
                switch (d) {
                    case 0: {
                        if (rc.getPlacements(576 + s).isEmpty() || rc.getPlacements(1152 + s).isEmpty()) continue block8;
                        ++ret;
                        continue block8;
                    }
                    case 1: {
                        if (rc.getPlacements(864 + s).isEmpty()) continue block8;
                        ++ret;
                        continue block8;
                    }
                    case 2: {
                        if (rc.getPlacements(0 + s).isEmpty() || rc.getPlacements(1152 + s).isEmpty()) continue block8;
                        ++ret;
                        continue block8;
                    }
                    case 3: {
                        if (rc.getPlacements(288 + s).isEmpty()) continue block8;
                        ++ret;
                        continue block8;
                    }
                    case 4: {
                        if (rc.getPlacements(0 + s).isEmpty() || rc.getPlacements(576 + s).isEmpty()) continue block8;
                        ++ret;
                    }
                }
            }
        }
        return ret;
    }
}

