/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett;

import org.apache.log4j.Logger;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.Callback;

public abstract class TimetableLoader
implements Runnable {
    private TimetableModel iModel = null;
    private Assignment<Lecture, Placement> iAssignment = null;
    private Callback iCallback = null;

    public TimetableLoader(TimetableModel model, Assignment<Lecture, Placement> assignment) {
        this.iModel = model;
        this.iAssignment = assignment;
    }

    protected TimetableModel getModel() {
        return this.iModel;
    }

    protected Assignment<Lecture, Placement> getAssignment() {
        return this.iAssignment;
    }

    public abstract void load() throws Exception;

    public void setCallback(Callback callback) {
        this.iCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.load();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.iCallback != null) {
                this.iCallback.execute();
            }
        }
    }
}

