/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.base;

import java.util.List;
import org.kie.soup.commons.validation.PortablePreconditions;

public class FileDiff {
    private List<String> linesA;
    private List<String> linesB;
    private String changeType;
    private String nameA;
    private String nameB;
    private int startA;
    private int endA;
    private int startB;
    private int endB;

    public FileDiff(String nameA, String nameB, int startA, int endA, int startB, int endB, String changeType, List<String> linesA, List<String> linesB) {
        this.nameA = PortablePreconditions.checkNotEmpty((String)"nameA", (String)nameA);
        this.nameB = PortablePreconditions.checkNotEmpty((String)"nameB", (String)nameB);
        this.startA = startA;
        this.endA = endA;
        this.startB = startB;
        this.endB = endB;
        this.changeType = PortablePreconditions.checkNotEmpty((String)"nameA", (String)changeType);
        this.linesA = (List)PortablePreconditions.checkNotNull((String)"linesA", linesA);
        this.linesB = (List)PortablePreconditions.checkNotNull((String)"linesB", linesB);
    }

    public List<String> getLinesA() {
        return this.linesA;
    }

    public List<String> getLinesB() {
        return this.linesB;
    }

    public String getChangeType() {
        return this.changeType;
    }

    public String getNameA() {
        return this.nameA;
    }

    public String getNameB() {
        return this.nameB;
    }

    public int getStartA() {
        return this.startA;
    }

    public int getEndA() {
        return this.endA;
    }

    public int getStartB() {
        return this.startB;
    }

    public int getEndB() {
        return this.endB;
    }

    public String toString() {
        String linesFromA = this.getLinesA().stream().reduce("", (acum, elem) -> {
            acum = acum + "-" + new String(elem.getBytes()) + "\n";
            return acum;
        });
        String linesFromB = this.getLinesB().stream().reduce("", (acum, elem) -> {
            acum = acum + "+" + new String(elem.getBytes()) + "\n";
            return acum;
        });
        StringBuilder builder = new StringBuilder();
        builder.append("FileDiff { \n");
        builder.append(this.getChangeType());
        builder.append(" , \n");
        builder.append(this.getNameA());
        builder.append(" -> ");
        builder.append("( " + this.getStartA() + " , " + this.getEndA() + " )");
        builder.append("[ " + linesFromA + " ]");
        builder.append(" || ");
        builder.append(this.getNameB());
        builder.append(" -> ");
        builder.append("( " + this.getStartB() + " , " + this.getEndB() + " )");
        builder.append("[ " + linesFromB + " ]");
        builder.append("}");
        return builder.toString();
    }

    public int hashCode() {
        int result = Integer.hashCode(this.startA);
        result = ~(~result);
        result = 31 * result + Integer.hashCode(this.endA);
        result = ~(~result);
        result = 31 * result + Integer.hashCode(this.startB);
        result = ~(~result);
        result = 31 * result + Integer.hashCode(this.endB);
        result = ~(~result);
        result = 31 * result + this.nameA.hashCode();
        result = ~(~result);
        result = 31 * result + this.nameB.hashCode();
        result = ~(~result);
        result = 31 * result + this.changeType.hashCode();
        result = ~(~result);
        result = 31 * result + this.linesA.hashCode();
        result = ~(~result);
        result = 31 * result + this.linesB.hashCode();
        result = ~(~result);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileDiff) {
            FileDiff external = (FileDiff)obj;
            return this.startA == external.startA && this.endA == external.endA && this.startB == external.startB && this.endB == external.endB && this.changeType.equals(external.changeType) && this.nameA.equals(external.nameA) && this.nameB.equals(external.nameB) && this.linesA.equals(external.linesA) && this.linesB.equals(external.getLinesB());
        }
        return super.equals(obj);
    }
}

