/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.plugin;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.uberfire.client.plugin.RuntimePluginsServiceProxy;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
@Alternative
public class RuntimePluginsServiceProxyClientImpl
implements RuntimePluginsServiceProxy {
    @Inject
    private Logger logger;

    @Override
    public void getTemplateContent(final String contentUrl, final ParameterizedCommand<String> command) {
        RequestBuilder contentRb = new RequestBuilder(RequestBuilder.GET, "plugins/" + contentUrl);
        try {
            contentRb.sendRequest(null, new RequestCallback(){

                public void onResponseReceived(Request request, Response response) {
                    command.execute((Object)response.getText());
                }

                public void onError(Request request, Throwable ex) {
                    RuntimePluginsServiceProxyClientImpl.this.logger.warn("Error in template content request for " + contentUrl, ex);
                    command.execute(null);
                }
            });
        }
        catch (RequestException ex) {
            this.logger.warn("Couldn't load template content at " + contentUrl, (Throwable)ex);
            command.execute(null);
        }
    }

    @Override
    public void listFrameworksContent(ParameterizedCommand<Collection<String>> command) {
        this.findAndFetchContent("frameworks/", ".js", "framework", command);
    }

    @Override
    public void listPluginsContent(ParameterizedCommand<Collection<String>> command) {
        this.findAndFetchContent("plugins/", ".js", "plugin", command);
    }

    private void findAndFetchContent(String relativeUri, final String filenameExtension, final String fileType, final ParameterizedCommand<Collection<String>> doWhenFinished) {
        RequestBuilder rb = new RequestBuilder(RequestBuilder.GET, relativeUri);
        try {
            rb.sendRequest(null, new RequestCallback(){

                public void onResponseReceived(Request request, Response response) {
                    final ArrayList<String> pluginUrls = new ArrayList<String>();
                    final ArrayList pluginContents = new ArrayList();
                    final int[] contentErrors = new int[1];
                    Element detachedDiv = DOM.createDiv();
                    detachedDiv.setInnerHTML(response.getText());
                    NodeList links = detachedDiv.getElementsByTagName("a");
                    for (int i = 0; i < links.getLength(); ++i) {
                        AnchorElement aElem = (AnchorElement)links.getItem(i);
                        String href = aElem.getHref();
                        if (!href.endsWith(filenameExtension)) continue;
                        pluginUrls.add(href);
                    }
                    if (pluginUrls.size() == 0) {
                        doWhenFinished.execute(Collections.emptyList());
                        return;
                    }
                    for (final String href : pluginUrls) {
                        RequestBuilder contentRb = new RequestBuilder(RequestBuilder.GET, href);
                        try {
                            contentRb.sendRequest(null, new RequestCallback(){

                                public void onResponseReceived(Request request, Response response) {
                                    if (response.getStatusCode() == 200) {
                                        pluginContents.add(response.getText());
                                    } else {
                                        contentErrors[0] = contentErrors[0] + 1;
                                    }
                                    if (pluginContents.size() >= pluginUrls.size() + contentErrors[0]) {
                                        doWhenFinished.execute((Object)pluginContents);
                                    }
                                }

                                public void onError(Request request, Throwable exception) {
                                    RuntimePluginsServiceProxyClientImpl.this.logger.warn("Error in " + fileType + " content request for " + href);
                                    contentErrors[0] = contentErrors[0] + 1;
                                    if (pluginContents.size() >= pluginUrls.size() + contentErrors[0]) {
                                        doWhenFinished.execute((Object)pluginContents);
                                    }
                                }
                            });
                        }
                        catch (RequestException ex) {
                            RuntimePluginsServiceProxyClientImpl.this.logger.warn("Failed to send request for " + fileType + " " + href, (Throwable)ex);
                            contentErrors[0] = contentErrors[0] + 1;
                            if (pluginContents.size() < pluginUrls.size() + contentErrors[0]) continue;
                            doWhenFinished.execute(pluginContents);
                        }
                    }
                }

                public void onError(Request request, Throwable ex) {
                    RuntimePluginsServiceProxyClientImpl.this.logger.warn("Error in " + fileType + " list request. Not loading JS " + fileType + "s.", ex);
                    doWhenFinished.execute(Collections.emptyList());
                }
            });
        }
        catch (RequestException ex) {
            this.logger.warn("Couldn't load JS " + fileType + ". Continuing without runtime " + fileType + "s.", (Throwable)ex);
            doWhenFinished.execute(Collections.emptyList());
        }
    }
}

