/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.servlet.spi;

import java.util.Collection;
import java.util.Collections;
import javax.servlet.ServletContext;
import org.togglz.core.spi.BeanFinder;

public class ServletContextBeanFinder
implements BeanFinder {
    public <E> Collection<E> find(Class<E> clazz, Object context) {
        ServletContext servletContext;
        String implClassName;
        if (context instanceof ServletContext && (implClassName = (servletContext = (ServletContext)context).getInitParameter(clazz.getName())) != null && implClassName.trim().length() > 0) {
            return Collections.singletonList(ServletContextBeanFinder.createInstance(implClassName, clazz));
        }
        return Collections.emptyList();
    }

    static <T> T createInstance(String classname, Class<T> interfaceClazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = interfaceClazz.getClassLoader();
        }
        try {
            Class<?> clazz = Class.forName(classname, true, classLoader);
            return (T)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unknown class: " + classname);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Could not create an instance of class: " + classname, e);
        }
    }
}

