/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.servlet.activation;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.togglz.core.activation.Parameter;
import org.togglz.core.logging.Log;
import org.togglz.core.logging.LogFactory;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.user.FeatureUser;
import org.togglz.core.util.Strings;
import org.togglz.servlet.activation.CIDRUtils;
import org.togglz.servlet.util.HttpServletRequestHolder;

public class ClientIpActivationStrategy
implements ActivationStrategy {
    private final Log log = LogFactory.getLog(ClientIpActivationStrategy.class);
    public static final String ID = "client-ip";
    public static final String PARAM_IPS = "ips";

    public String getId() {
        return ID;
    }

    public String getName() {
        return "IP address (client)";
    }

    public boolean isActive(FeatureState featureState, FeatureUser user) {
        HttpServletRequest request = HttpServletRequestHolder.get();
        if (request != null) {
            List parts = Strings.splitAndTrim((String)featureState.getParameter(PARAM_IPS), (String)"[\\s,]+");
            try {
                String remoteAddr = request.getHeader("X-Forwarded-For");
                if (Strings.isBlank((String)remoteAddr)) {
                    remoteAddr = request.getRemoteAddr();
                }
                InetAddress remoteInetAddress = InetAddress.getByName(remoteAddr);
                for (String part : parts) {
                    CIDRUtils cidrUtil;
                    if (part.equals(remoteAddr)) {
                        return true;
                    }
                    if (!(part.contains("/") ? (cidrUtil = new CIDRUtils(part)).isInRange(remoteInetAddress) : remoteInetAddress.equals(InetAddress.getByName(part)))) continue;
                    return true;
                }
            }
            catch (IllegalArgumentException | UnknownHostException e) {
                this.log.warn("Ignoring illegal IP address or CIDR range ");
            }
        }
        return false;
    }

    public Parameter[] getParameters() {
        return new Parameter[]{new AddressParameter()};
    }

    protected static class AddressParameter
    implements Parameter {
        protected AddressParameter() {
        }

        public String getName() {
            return ClientIpActivationStrategy.PARAM_IPS;
        }

        public String getLabel() {
            return "Client IPs";
        }

        public String getDescription() {
            return "A comma-separated list of client IPs or address ranges in CIDR notation (e.g. 10.1.2.0/24) for which the feature should be active.";
        }

        public boolean isOptional() {
            return false;
        }

        public boolean isLargeText() {
            return false;
        }

        public boolean isValid(String addresses) {
            if (Strings.isBlank((String)addresses)) {
                return false;
            }
            List addressList = Strings.splitAndTrim((String)addresses, (String)",");
            for (String address : addressList) {
                if (address.contains("/")) {
                    try {
                        new CIDRUtils(address);
                        continue;
                    }
                    catch (IllegalArgumentException | UnknownHostException e) {
                        return false;
                    }
                }
                try {
                    InetAddress.getByName(address);
                }
                catch (UnknownHostException e) {
                    return false;
                }
            }
            return true;
        }
    }
}

