/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.freemarker.core;

import org.testcontainers.shaded.freemarker.template.TemplateCollectionModel;
import org.testcontainers.shaded.freemarker.template.TemplateModel;
import org.testcontainers.shaded.freemarker.template.TemplateModelException;
import org.testcontainers.shaded.freemarker.template.TemplateModelIterator;

class LazyCollectionTemplateModelIterator
implements TemplateModelIterator {
    private final TemplateCollectionModel templateCollectionModel;
    private TemplateModelIterator iterator;

    public LazyCollectionTemplateModelIterator(TemplateCollectionModel templateCollectionModel) {
        this.templateCollectionModel = templateCollectionModel;
    }

    @Override
    public TemplateModel next() throws TemplateModelException {
        this.ensureIteratorInitialized();
        return this.iterator.next();
    }

    @Override
    public boolean hasNext() throws TemplateModelException {
        this.ensureIteratorInitialized();
        return this.iterator.hasNext();
    }

    private void ensureIteratorInitialized() throws TemplateModelException {
        if (this.iterator == null) {
            this.iterator = this.templateCollectionModel.iterator();
        }
    }
}

