/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.security.KeyStore;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.KeyStoreBuilder;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class CosmosDBEmulatorContainer
extends GenericContainer<CosmosDBEmulatorContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"mcr.microsoft.com/cosmosdb/linux/azure-cosmos-emulator");
    private static final int PORT = 8081;

    public CosmosDBEmulatorContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{8081});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)"(?s).*Started\\r\\n$", (int)1));
    }

    public KeyStore buildNewKeyStore() {
        return KeyStoreBuilder.buildByDownloadingCertificate(this.getEmulatorEndpoint(), this.getEmulatorKey());
    }

    public String getEmulatorKey() {
        return "C2y6yDjf5/R+ob0N8A7Cgv30VRDJIWEHLM+4QDU5DE2nQ9nDuVTqobD4b8mGGyPMbIZnqyMsEcaGQy67XIw/Jw==";
    }

    public String getEmulatorEndpoint() {
        return "https://" + this.getHost() + ":" + this.getMappedPort(8081);
    }
}

