/*
 * Decompiled with CFR 0.152.
 */
package tachyon.util;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.Pair;
import tachyon.PrefixList;
import tachyon.UnderFileSystem;
import tachyon.Version;
import tachyon.client.TachyonFS;
import tachyon.util.CommonUtils;
import tachyon.util.NetworkUtils;

public class UnderfsUtils {
    private static Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);

    private static String buildTFSPath(String tfsRootPath, String ufsRootPath, String path) {
        String filePath = path.substring(ufsRootPath.length());
        if (filePath.isEmpty()) {
            filePath = path.substring(ufsRootPath.lastIndexOf("/") + 1);
        }
        return CommonUtils.concat(tfsRootPath, filePath);
    }

    public static void loadUnderFs(String tfsAddrRootPath, String ufsAddrRootPath, String excludePaths) throws IOException {
        Pair<String, String> tfsPair = UnderFileSystem.parse(tfsAddrRootPath);
        String tfsAddress = tfsPair.getFirst();
        String tfsRootPath = tfsPair.getSecond();
        TachyonFS tfs = TachyonFS.get(tfsAddress);
        PrefixList excludePathPrefix = new PrefixList(excludePaths, ";");
        UnderfsUtils.loadUnderFs(tfs, tfsRootPath, ufsAddrRootPath, excludePathPrefix);
    }

    public static void loadUnderFs(TachyonFS tfs, String tfsRootPath, String ufsAddrRootPath, PrefixList excludePathPrefix) throws IOException {
        LOG.info((Object)(tfs + tfsRootPath + " " + ufsAddrRootPath + " " + excludePathPrefix));
        try {
            String oldpath = ufsAddrRootPath;
            ufsAddrRootPath = NetworkUtils.replaceHostName(ufsAddrRootPath);
            if (!ufsAddrRootPath.equalsIgnoreCase(oldpath)) {
                System.out.println("UnderFS hostname resolved: " + ufsAddrRootPath);
            }
        }
        catch (UnknownHostException e) {
            LOG.info((Object)("hostname cannot be resolved in given UFS path: " + ufsAddrRootPath));
            throw new IOException(e);
        }
        Pair<String, String> ufsPair = UnderFileSystem.parse(ufsAddrRootPath);
        String ufsAddress = ufsPair.getFirst();
        String ufsRootPath = ufsPair.getSecond();
        if (!tfs.exist(tfsRootPath)) {
            tfs.mkdir(tfsRootPath);
        }
        UnderFileSystem ufs = UnderFileSystem.get(ufsAddress);
        LinkedList<String> ufsPathQueue = new LinkedList<String>();
        if (excludePathPrefix.outList(ufsRootPath)) {
            ufsPathQueue.add(ufsAddrRootPath);
        }
        while (!ufsPathQueue.isEmpty()) {
            String tfsPath;
            String ufsPath = (String)ufsPathQueue.poll();
            LOG.info((Object)("loading: " + ufsPath));
            if (ufs.isFile(ufsPath)) {
                String tfsPath2 = UnderfsUtils.buildTFSPath(tfsRootPath, ufsAddrRootPath, ufsPath);
                if (tfs.exist(tfsPath2)) {
                    LOG.info((Object)("File " + tfsPath2 + " already exists in Tachyon."));
                    continue;
                }
                int fileId = tfs.createFile(tfsPath2, ufsPath);
                if (fileId == -1) {
                    LOG.info((Object)("Failed to create tachyon file: " + tfsPath2));
                    continue;
                }
                LOG.info((Object)("Create tachyon file " + tfsPath2 + " with file id " + fileId + " and " + "checkpoint location " + ufsPath));
                continue;
            }
            String[] files = ufs.list(ufsPath);
            if (files != null) {
                for (String filePath : files) {
                    LOG.info((Object)("Get: " + filePath));
                    String aPath = CommonUtils.concat(ufsPath, filePath);
                    String checkPath = aPath.substring(ufsAddrRootPath.length());
                    if (checkPath.startsWith("/")) {
                        checkPath = checkPath.substring("/".length());
                    }
                    if (excludePathPrefix.inList(checkPath)) {
                        LOG.info((Object)("excluded: " + checkPath));
                        continue;
                    }
                    ufsPathQueue.add(aPath);
                }
            }
            if (tfs.exist(tfsPath = CommonUtils.concat(tfsRootPath, ufsPath.substring(ufsAddrRootPath.length())))) continue;
            tfs.mkdir(tfsPath);
        }
    }

    public static void main(String[] args) {
        if (args.length != 2 && args.length != 3) {
            UnderfsUtils.printUsage();
            System.exit(-1);
        }
        String exList = args.length == 3 ? args[2] : "";
        try {
            UnderfsUtils.loadUnderFs(args[0], args[1], exList);
        }
        catch (Exception e) {
            e.printStackTrace();
            UnderfsUtils.printUsage();
            System.exit(-1);
        }
        System.exit(0);
    }

    public static void printUsage() {
        String cmd = "java -cp target/tachyon-" + Version.VERSION + "-jar-with-dependencies.jar " + "tachyon.util.UnderfsUtils ";
        System.out.println("Usage: " + cmd + "<TachyonPath> <UnderfsPath> " + "[<Optional ExcludePathPrefix, separated by ;>]");
        System.out.println("Example: " + cmd + "tachyon://127.0.0.1:19998/a hdfs://localhost:9000/b c");
        System.out.println("Example: " + cmd + "tachyon://127.0.0.1:19998/a file:///b c");
        System.out.println("Example: " + cmd + "tachyon://127.0.0.1:19998/a /b c");
        System.out.print("In the TFS, all files under local FS /b will be registered under /a, ");
        System.out.println("except for those with prefix c");
    }
}

