/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

abstract class JsonObject {
    public Map<String, Object> parameters = Maps.newHashMap();

    JsonObject() {
    }

    public static ObjectMapper createObjectMapper() {
        return new ObjectMapper().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false).configure(SerializationFeature.CLOSE_CLOSEABLE, false);
    }

    public <T> T get(String name) {
        return (T)this.parameters.get(name);
    }

    public Boolean getBoolean(String name) {
        return (Boolean)this.get(name);
    }

    public ByteBuffer getByteBuffer(String name) {
        String byteString = (String)this.get(name);
        if (byteString == null) {
            return null;
        }
        return ByteBuffer.wrap(Base64.decodeBase64((String)byteString));
    }

    public List<ByteBuffer> getByteBufferList(String name) {
        List byteStrings = (List)this.get(name);
        if (byteStrings == null) {
            return null;
        }
        ArrayList buffers = Lists.newArrayListWithCapacity((int)byteStrings.size());
        for (String byteString : byteStrings) {
            buffers.add(ByteBuffer.wrap(Base64.decodeBase64((String)byteString)));
        }
        return buffers;
    }

    public Integer getInt(String name) {
        return ((Number)this.get(name)).intValue();
    }

    public Long getLong(String name) {
        return ((Number)this.get(name)).longValue();
    }

    public String getString(String name) {
        return (String)this.get(name);
    }

    public JsonObject withParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }
}

