/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.Pair;
import tachyon.UnderFileSystem;
import tachyon.io.Utils;
import tachyon.master.DependencyType;
import tachyon.master.EditLogOperation;
import tachyon.master.EditLogOperationType;
import tachyon.master.JsonObject;
import tachyon.master.MasterInfo;
import tachyon.thrift.BlockInfoException;
import tachyon.thrift.FileAlreadyExistException;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.InvalidPathException;
import tachyon.thrift.SuspectedFileSizeException;
import tachyon.thrift.TableDoesNotExistException;
import tachyon.thrift.TachyonException;
import tachyon.util.CommonUtils;

public class EditLog {
    private static final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private static int mBackUpLogStartNum = -1;
    private static long mCurrentTId = 0L;
    private final boolean INACTIVE;
    private final String PATH;
    private final ObjectWriter WRITER;
    private UnderFileSystem mUfs;
    private OutputStream mOs;
    private DataOutputStream mDos;
    private long mFlushedTransactionId = 0L;
    private long mTransactionId = 0L;
    private int mCurrentLogFileNum = 0;
    private int mMaxLogSize = 0x500000;

    public static long load(MasterInfo info, String path, int currentLogFileNum) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(path);
        if (!ufs.exists(path)) {
            LOG.info((Object)("Edit Log " + path + " does not exist."));
            return 0L;
        }
        LOG.info((Object)("currentLogNum passed in was " + currentLogFileNum));
        int completedLogs = currentLogFileNum;
        mBackUpLogStartNum = currentLogFileNum;
        int numFiles = 1;
        String completedPath = path.substring(0, path.lastIndexOf("/") + 1) + "completed";
        if (!ufs.exists(completedPath)) {
            LOG.info((Object)"No completed edit logs to be parsed");
        } else {
            while (ufs.exists(CommonUtils.concat(completedPath, completedLogs++ + ".editLog"))) {
                ++numFiles;
            }
        }
        String[] editLogs = new String[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            editLogs[i] = i != numFiles - 1 ? CommonUtils.concat(completedPath, i + currentLogFileNum + ".editLog") : path;
        }
        for (String currentPath : editLogs) {
            LOG.info((Object)("Loading Edit Log " + currentPath));
            EditLog.loadSingleLog(info, currentPath);
        }
        ufs.close();
        return mCurrentTId;
    }

    public static void loadSingleLog(MasterInfo info, String path) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(path);
        DataInputStream is = new DataInputStream(ufs.open(path));
        JsonParser parser = JsonObject.createObjectMapper().getJsonFactory().createJsonParser((InputStream)is);
        while (true) {
            EditLogOperation op;
            try {
                op = (EditLogOperation)parser.readValueAs(EditLogOperation.class);
                LOG.debug((Object)("Read operation: " + op));
            }
            catch (IOException e) {
                if (e.getMessage().contains("end-of-input")) break;
                throw e;
            }
            mCurrentTId = op.transId;
            try {
                switch (op.type) {
                    case ADD_BLOCK: {
                        info.opAddBlock(op.getInt("fileId"), op.getInt("blockIndex"), op.getLong("blockLength"));
                        break;
                    }
                    case ADD_CHECKPOINT: {
                        info.addCheckpoint(-1L, op.getInt("fileId"), op.getLong("length"), op.getString("path"));
                        break;
                    }
                    case CREATE_FILE: {
                        info._createFile(op.getBoolean("recursive"), op.getString("path"), op.getBoolean("directory"), op.getLong("blockSizeByte"), op.getLong("creationTimeMs"));
                        break;
                    }
                    case COMPLETE_FILE: {
                        info.completeFile((Integer)op.get("fileId"));
                        break;
                    }
                    case SET_PINNED: {
                        info.setPinned(op.getInt("fileId"), op.getBoolean("pinned"));
                        break;
                    }
                    case RENAME: {
                        info._rename(op.getInt("fileId"), op.getString("dstPath"));
                        break;
                    }
                    case DELETE: {
                        info._delete(op.getInt("fileId"), op.getBoolean("recursive"));
                        break;
                    }
                    case CREATE_RAW_TABLE: {
                        info._createRawTable(op.getInt("tableId"), op.getInt("columns"), op.getByteBuffer("metadata"));
                        break;
                    }
                    case UPDATE_RAW_TABLE_METADATA: {
                        info.updateRawTableMetadata(op.getInt("tableId"), op.getByteBuffer("metadata"));
                        break;
                    }
                    case CREATE_DEPENDENCY: {
                        info._createDependency((List)op.get("parents"), (List)op.get("children"), op.getString("commandPrefix"), op.getByteBufferList("data"), op.getString("comment"), op.getString("framework"), op.getString("frameworkVersion"), (DependencyType)((Object)op.get("dependencyType")), op.getInt("dependencyId"), op.getLong("creationTimeMs"));
                        break;
                    }
                    default: {
                        throw new IOException("Invalid op type " + op);
                    }
                }
            }
            catch (SuspectedFileSizeException e) {
                throw new IOException(e);
            }
            catch (BlockInfoException e) {
                throw new IOException(e);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (FileAlreadyExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
            catch (TableDoesNotExistException e) {
                throw new IOException(e);
            }
        }
        is.close();
        ufs.close();
    }

    public static void markUpToDate(String path) {
        UnderFileSystem ufs = UnderFileSystem.get(path);
        String folder = path.substring(0, path.lastIndexOf("/") + 1) + "completed";
        try {
            String toDelete = CommonUtils.concat(folder, mBackUpLogStartNum + ".editLog");
            while (ufs.exists(toDelete)) {
                LOG.info((Object)("Deleting editlog " + toDelete));
                ufs.delete(toDelete, true);
                toDelete = CommonUtils.concat(folder, ++mBackUpLogStartNum + ".editLog");
            }
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
        mBackUpLogStartNum = -1;
    }

    public EditLog(String path, boolean inactive, long transactionId) throws IOException {
        this.INACTIVE = inactive;
        if (!this.INACTIVE) {
            LOG.info((Object)("Creating edit log file " + path));
            this.PATH = path;
            this.mUfs = UnderFileSystem.get(path);
            if (mBackUpLogStartNum != -1) {
                String folder = path.substring(0, path.lastIndexOf("/") + 1) + "/completed";
                LOG.info((Object)"Deleting completed editlogs that are part of the image.");
                this.deleteCompletedLogs(path, mBackUpLogStartNum);
                LOG.info((Object)("Backing up logs from " + mBackUpLogStartNum + " since image is not updated."));
                this.mUfs.mkdirs(folder, true);
                String toRename = CommonUtils.concat(folder, mBackUpLogStartNum + ".editLog");
                int currentLogFileNum = 0;
                while (this.mUfs.exists(toRename)) {
                    LOG.info((Object)("Rename " + toRename + " to " + CommonUtils.concat(folder, currentLogFileNum + ".editLog")));
                    ++currentLogFileNum;
                    toRename = CommonUtils.concat(folder, ++mBackUpLogStartNum + ".editLog");
                }
                if (this.mUfs.exists(path)) {
                    this.mUfs.rename(path, CommonUtils.concat(folder, currentLogFileNum + ".editLog"));
                    LOG.info((Object)("Rename " + path + " to " + CommonUtils.concat(folder, currentLogFileNum + ".editLog")));
                    ++currentLogFileNum;
                }
                mBackUpLogStartNum = -1;
            }
            if (this.mUfs.exists(path)) {
                this.mUfs.delete(path, true);
            }
            this.mOs = this.mUfs.create(path);
            this.mDos = new DataOutputStream(this.mOs);
            LOG.info((Object)("Created file " + path));
            this.mFlushedTransactionId = transactionId;
            this.mTransactionId = transactionId;
            this.WRITER = JsonObject.createObjectMapper().writer();
        } else {
            this.PATH = null;
            this.mUfs = null;
            this.mOs = null;
            this.mDos = null;
            this.WRITER = null;
        }
    }

    private synchronized void _closeActiveStream() {
        try {
            if (this.mDos != null) {
                this.mDos.close();
            }
            if (this.mOs != null) {
                this.mOs.close();
            }
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }

    public synchronized void addBlock(int fileId, int blockIndex, long blockLength) {
        if (this.INACTIVE) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.ADD_BLOCK, ++this.mTransactionId).withParameter("fileId", fileId).withParameter("blockIndex", blockIndex).withParameter("blockLength", blockLength);
        this.writeOperation(operation);
    }

    public synchronized void addCheckpoint(int fileId, long length, String checkpointPath) {
        if (this.INACTIVE) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.ADD_CHECKPOINT, ++this.mTransactionId).withParameter("fileId", fileId).withParameter("length", length).withParameter("path", checkpointPath);
        this.writeOperation(operation);
    }

    public synchronized void close() {
        if (this.INACTIVE) {
            return;
        }
        try {
            this._closeActiveStream();
            this.mUfs.close();
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }

    public synchronized void completeFile(int fileId) {
        if (this.INACTIVE) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.COMPLETE_FILE, ++this.mTransactionId).withParameter("fileId", fileId);
        this.writeOperation(operation);
    }

    public synchronized void createDependency(List<Integer> parents, List<Integer> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, DependencyType dependencyType, int depId, long creationTimeMs) {
        if (this.INACTIVE) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.CREATE_DEPENDENCY, ++this.mTransactionId).withParameter("parents", parents).withParameter("children", children).withParameter("commandPrefix", commandPrefix).withParameter("data", Utils.byteBufferListToBase64(data)).withParameter("comment", comment).withParameter("framework", framework).withParameter("frameworkVersion", frameworkVersion).withParameter("dependencyType", (Object)dependencyType).withParameter("dependencyId", depId).withParameter("creationTimeMs", creationTimeMs);
        this.writeOperation(operation);
    }

    public synchronized void createFile(boolean recursive, String path, boolean directory, long blockSizeByte, long creationTimeMs) {
        if (this.INACTIVE) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.CREATE_FILE, ++this.mTransactionId).withParameter("recursive", recursive).withParameter("path", path).withParameter("directory", directory).withParameter("blockSizeByte", blockSizeByte).withParameter("creationTimeMs", creationTimeMs);
        this.writeOperation(operation);
    }

    public synchronized void createRawTable(int tableId, int columns, ByteBuffer metadata) {
        if (this.INACTIVE) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.CREATE_RAW_TABLE, ++this.mTransactionId).withParameter("tableId", tableId).withParameter("columns", columns).withParameter("metadata", Utils.byteBufferToBase64(metadata));
        this.writeOperation(operation);
    }

    public synchronized void delete(int fileId, boolean recursive) {
        if (this.INACTIVE) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.DELETE, ++this.mTransactionId).withParameter("fileId", fileId).withParameter("recursive", recursive);
        this.writeOperation(operation);
    }

    public void deleteCompletedLogs(String path, int upTo) {
        UnderFileSystem ufs = UnderFileSystem.get(path);
        String folder = path.substring(0, path.lastIndexOf("/") + 1) + "completed";
        try {
            for (int i = 0; i < upTo; ++i) {
                String toDelete = CommonUtils.concat(folder, i + ".editLog");
                LOG.info((Object)("Deleting editlog " + toDelete));
                ufs.delete(toDelete, true);
            }
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }

    public synchronized void flush() {
        if (this.INACTIVE) {
            return;
        }
        try {
            this.mDos.flush();
            if (this.mOs instanceof FSDataOutputStream) {
                ((FSDataOutputStream)this.mOs).sync();
            }
            if (this.mDos.size() > this.mMaxLogSize) {
                this.rotateEditLog(this.PATH);
            }
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
        this.mFlushedTransactionId = this.mTransactionId;
    }

    public synchronized Pair<Long, Long> getTransactionIds() {
        return new Pair<Long, Long>(this.mTransactionId, this.mFlushedTransactionId);
    }

    public synchronized void rename(int fileId, String dstPath) {
        if (this.INACTIVE) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.RENAME, ++this.mTransactionId).withParameter("fileId", fileId).withParameter("dstPath", dstPath);
        this.writeOperation(operation);
    }

    public void rotateEditLog(String path) {
        if (this.INACTIVE) {
            return;
        }
        this._closeActiveStream();
        LOG.info((Object)("Edit log max size of " + this.mMaxLogSize + " bytes reached, rotating edit log"));
        String pathPrefix = path.substring(0, path.lastIndexOf("/") + 1) + "completed";
        LOG.info((Object)("path: " + path + " prefix: " + pathPrefix));
        try {
            if (!this.mUfs.exists(pathPrefix)) {
                this.mUfs.mkdirs(pathPrefix, true);
            }
            String newPath = CommonUtils.concat(pathPrefix, this.mCurrentLogFileNum++ + ".editLog");
            this.mUfs.rename(path, newPath);
            LOG.info((Object)("Renamed " + path + " to " + newPath));
            this.mOs = this.mUfs.create(path);
            this.mDos = new DataOutputStream(this.mOs);
            LOG.info((Object)("Created new log file " + path));
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }

    public void setMaxLogSize(int size) {
        this.mMaxLogSize = size;
    }

    public synchronized void setPinned(int fileId, boolean pinned) {
        if (this.INACTIVE) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.SET_PINNED, ++this.mTransactionId).withParameter("fileId", fileId).withParameter("pinned", pinned);
        this.writeOperation(operation);
    }

    public synchronized void updateRawTableMetadata(int tableId, ByteBuffer metadata) {
        if (this.INACTIVE) {
            return;
        }
        EditLogOperation operation = new EditLogOperation(EditLogOperationType.UPDATE_RAW_TABLE_METADATA, ++this.mTransactionId).withParameter("tableId", tableId).withParameter("metadata", Utils.byteBufferToBase64(metadata));
        this.writeOperation(operation);
    }

    private void writeOperation(EditLogOperation operation) {
        try {
            this.WRITER.writeValue((OutputStream)this.mDos, (Object)operation);
            this.mDos.writeByte(10);
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }
}

