/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.client.OutStream;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.util.CommonUtils;

public class BlockOutStream
extends OutStream {
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private final int BLOCK_INDEX;
    private final long BLOCK_CAPACITY_BYTE;
    private final long BLOCK_ID;
    private final long BLOCK_OFFSET;
    private final boolean PIN;
    private long mInFileBytes = 0L;
    private long mWrittenBytes = 0L;
    private String mLocalFilePath = null;
    private RandomAccessFile mLocalFile = null;
    private FileChannel mLocalFileChannel = null;
    private ByteBuffer mBuffer = ByteBuffer.allocate(0);
    private boolean mCanWrite = false;
    private boolean mClosed = false;
    private boolean mCancel = false;

    BlockOutStream(TachyonFile file, WriteType opType, int blockIndex) throws IOException {
        super(file, opType);
        if (!opType.isCache()) {
            throw new IOException("BlockOutStream only support WriteType.CACHE");
        }
        this.BLOCK_INDEX = blockIndex;
        this.BLOCK_CAPACITY_BYTE = this.FILE.getBlockSizeByte();
        this.BLOCK_ID = this.FILE.getBlockId(this.BLOCK_INDEX);
        this.BLOCK_OFFSET = this.BLOCK_CAPACITY_BYTE * (long)blockIndex;
        this.PIN = this.FILE.needPin();
        this.mCanWrite = true;
        if (!this.TFS.hasLocalWorker()) {
            this.mCanWrite = false;
            String msg = "The machine does not have any local worker.";
            throw new IOException(msg);
        }
        File localFolder = this.TFS.createAndGetUserTempFolder();
        if (localFolder == null) {
            this.mCanWrite = false;
            String msg = "Failed to create temp user folder for tachyon client.";
            throw new IOException(msg);
        }
        this.mLocalFilePath = CommonUtils.concat(localFolder.getPath(), this.BLOCK_ID);
        this.mLocalFile = new RandomAccessFile(this.mLocalFilePath, "rw");
        this.mLocalFileChannel = this.mLocalFile.getChannel();
        CommonUtils.changeLocalFileToFullPermission(this.mLocalFilePath);
        CommonUtils.setLocalFileStickyBit(this.mLocalFilePath);
        this.LOG.info((Object)(this.mLocalFilePath + " was created!"));
        this.mBuffer = ByteBuffer.allocate(this.USER_CONF.FILE_BUFFER_BYTES + 4);
    }

    private synchronized void appendCurrentBuffer(byte[] buf, int offset, int length) throws IOException {
        if (!this.TFS.requestSpace(length)) {
            this.mCanWrite = false;
            String msg = "Local tachyon worker does not have enough space (" + length + ") or no worker for " + this.FILE.FID + " " + this.BLOCK_ID;
            if (this.PIN) {
                this.TFS.outOfMemoryForPinFile(this.FILE.FID);
                throw new IOException(msg);
            }
            throw new IOException(msg);
        }
        MappedByteBuffer out = this.mLocalFileChannel.map(FileChannel.MapMode.READ_WRITE, this.mInFileBytes, length);
        out.put(buf, offset, length);
        this.mInFileBytes += (long)length;
    }

    @Override
    public void cancel() throws IOException {
        this.mCancel = true;
        this.close();
    }

    public boolean canWrite() {
        return !this.mClosed && this.mCanWrite;
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            if (!this.mCancel && this.mBuffer.position() > 0) {
                this.appendCurrentBuffer(this.mBuffer.array(), 0, this.mBuffer.position());
            }
            if (this.mLocalFileChannel != null) {
                this.mLocalFileChannel.close();
                this.mLocalFile.close();
            }
            if (this.mCancel) {
                this.TFS.releaseSpace(this.mWrittenBytes - (long)this.mBuffer.position());
                new File(this.mLocalFilePath).delete();
                this.LOG.info((Object)("Canceled output of block " + this.BLOCK_ID + ", deleted local file " + this.mLocalFilePath));
            } else {
                this.TFS.cacheBlock(this.BLOCK_ID);
            }
        }
        this.mClosed = true;
    }

    @Override
    public void flush() throws IOException {
    }

    public long getBlockId() {
        return this.BLOCK_ID;
    }

    public long getBlockOffset() {
        return this.BLOCK_OFFSET;
    }

    public long getRemainingSpaceByte() {
        return this.BLOCK_CAPACITY_BYTE - this.mWrittenBytes;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException(String.format("Buffer length (%d), offset(%d), len(%d)", b.length, off, len));
        }
        if (!this.mCanWrite) {
            throw new IOException("Can not write cache.");
        }
        if (this.mWrittenBytes + (long)len > this.BLOCK_CAPACITY_BYTE) {
            throw new IOException("Out of capacity.");
        }
        if (this.mBuffer.position() + len >= this.USER_CONF.FILE_BUFFER_BYTES) {
            if (this.mBuffer.position() > 0) {
                this.appendCurrentBuffer(this.mBuffer.array(), 0, this.mBuffer.position());
                this.mBuffer.clear();
            }
            if (len > 0) {
                this.appendCurrentBuffer(b, off, len);
            }
        } else {
            this.mBuffer.put(b, off, len);
        }
        this.mWrittenBytes += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.mCanWrite) {
            throw new IOException("Can not write cache.");
        }
        if (this.mWrittenBytes + 1L > this.BLOCK_CAPACITY_BYTE) {
            throw new IOException("Out of capacity.");
        }
        if (this.mBuffer.position() >= this.USER_CONF.FILE_BUFFER_BYTES) {
            this.appendCurrentBuffer(this.mBuffer.array(), 0, this.mBuffer.position());
            this.mBuffer.clear();
        }
        this.mBuffer.put((byte)(b & 0xFF));
        ++this.mWrittenBytes;
    }
}

