/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import tachyon.conf.WorkerConf;
import tachyon.util.CommonUtils;

public class UserInfo {
    private final long USER_ID;
    private long mOwnBytes;
    private long mLastHeartbeatMs;

    public UserInfo(long userId) {
        if (userId <= 0L) {
            CommonUtils.runtimeException("Invalid user id " + userId);
        }
        this.USER_ID = userId;
        this.mOwnBytes = 0L;
        this.mLastHeartbeatMs = System.currentTimeMillis();
    }

    public synchronized void addOwnBytes(long addOwnBytes) {
        this.mOwnBytes += addOwnBytes;
    }

    public synchronized long getOwnBytes() {
        return this.mOwnBytes;
    }

    public long getUserId() {
        return this.USER_ID;
    }

    public synchronized void heartbeat() {
        this.mLastHeartbeatMs = System.currentTimeMillis();
    }

    public synchronized boolean timeout() {
        return System.currentTimeMillis() - this.mLastHeartbeatMs > (long)WorkerConf.get().USER_TIMEOUT_MS;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("UserInfo(");
        sb.append(" USER_ID: ").append(this.USER_ID);
        sb.append(", mOwnBytes: ").append(this.mOwnBytes);
        sb.append(", mLastHeartbeatMs: ").append(this.mLastHeartbeatMs);
        sb.append(")");
        return sb.toString();
    }
}

