/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import tachyon.Pair;
import tachyon.UnderFileSystemHdfs;
import tachyon.UnderFileSystemSingleLocal;
import tachyon.util.CommonUtils;

public abstract class UnderFileSystem {
    public static UnderFileSystem get(String path) {
        return UnderFileSystem.get(path, null);
    }

    public static UnderFileSystem get(String path, Object conf) {
        if (path.startsWith("hdfs://") || path.startsWith("s3://") || path.startsWith("s3n://") || path.startsWith("glusterfs:///")) {
            return UnderFileSystemHdfs.getClient(path, conf);
        }
        if (path.startsWith("/") || path.startsWith("file://")) {
            return UnderFileSystemSingleLocal.getClient();
        }
        CommonUtils.illegalArgumentException("Unknown under file system scheme " + path);
        return null;
    }

    public static Pair<String, String> parse(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("tachyon://") || path.startsWith("tachyon-ft://") || path.startsWith("hdfs://") || path.startsWith("s3://") || path.startsWith("s3n://") || path.startsWith("glusterfs:///")) {
            String prefix = path.substring(0, path.indexOf("://") + 3);
            String body = path.substring(prefix.length());
            if (body.contains("/")) {
                int ind = body.indexOf("/");
                return new Pair<String, String>(prefix + body.substring(0, ind), body.substring(ind));
            }
            return new Pair<String, String>(path, "/");
        }
        if (path.startsWith("file://") || path.startsWith("/")) {
            String prefix = "file://";
            String suffix = path.startsWith(prefix) ? path.substring(prefix.length()) : path;
            return new Pair<String, String>("/", suffix);
        }
        return null;
    }

    public abstract void close() throws IOException;

    public abstract OutputStream create(String var1) throws IOException;

    public abstract OutputStream create(String var1, int var2) throws IOException;

    public abstract OutputStream create(String var1, short var2, int var3) throws IOException;

    public abstract boolean delete(String var1, boolean var2) throws IOException;

    public abstract boolean exists(String var1) throws IOException;

    public abstract long getBlockSizeByte(String var1) throws IOException;

    public abstract Object getConf();

    public abstract List<String> getFileLocations(String var1) throws IOException;

    public abstract List<String> getFileLocations(String var1, long var2) throws IOException;

    public abstract long getFileSize(String var1) throws IOException;

    public abstract long getModificationTimeMs(String var1) throws IOException;

    public abstract long getSpace(String var1, SpaceType var2) throws IOException;

    public abstract boolean isFile(String var1) throws IOException;

    public abstract String[] list(String var1) throws IOException;

    public abstract boolean mkdirs(String var1, boolean var2) throws IOException;

    public abstract InputStream open(String var1) throws IOException;

    public abstract boolean rename(String var1, String var2) throws IOException;

    public abstract void setConf(Object var1);

    public abstract void setPermission(String var1, String var2) throws IOException;

    public static enum SpaceType {
        SPACE_TOTAL(0),
        SPACE_FREE(1),
        SPACE_USED(2);

        private final int value;

        private SpaceType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

