/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.model;

import java.util.ArrayList;
import java.util.List;
import org.springframework.faces.model.SelectionAware;
import org.springframework.faces.model.SerializableListDataModel;
import org.springframework.util.Assert;

public class OneSelectionTrackingListDataModel<T>
extends SerializableListDataModel<T>
implements SelectionAware<T> {
    private List<T> selections = new ArrayList<T>();

    public OneSelectionTrackingListDataModel() {
    }

    public OneSelectionTrackingListDataModel(List<T> list) {
        super(list);
    }

    @Override
    public List<T> getSelections() {
        return this.selections;
    }

    @Override
    public boolean isCurrentRowSelected() {
        return this.selections.contains(this.getRowData());
    }

    @Override
    public void select(T rowData) {
        Assert.isTrue((boolean)this.getWrappedData().contains(rowData), (String)"The object to select is not contained in this DataModel.");
        this.selections.clear();
        this.selections.add(rowData);
    }

    @Override
    public void selectAll() {
        if (this.getWrappedData().size() > 1) {
            throw new UnsupportedOperationException("This DataModel only allows one selection.");
        }
    }

    @Override
    public void setCurrentRowSelected(boolean rowSelected) {
        if (!this.isRowAvailable()) {
            return;
        }
        if (!rowSelected) {
            this.selections.remove(this.getRowData());
        } else if (!this.selections.contains(this.getRowData())) {
            this.selections.clear();
            this.selections.add(this.getRowData());
        }
    }

    @Override
    public void setSelections(List<T> selections) {
        Assert.isTrue((selections.size() <= 1 ? 1 : 0) != 0, (String)"This DataModel only allows one selection.");
        this.selections = selections;
    }

    public Object getSelectedRow() {
        if (this.selections.size() == 1) {
            return this.selections.get(0);
        }
        return null;
    }
}

