/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.zookeeper;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.UUID;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.api.transaction.CuratorTransactionFinal;
import org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import org.apache.zookeeper.data.Stat;
import org.springframework.messaging.MessageHeaders;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.StateMachineException;
import org.springframework.statemachine.StateMachinePersist;
import org.springframework.statemachine.kryo.MessageHeadersSerializer;
import org.springframework.statemachine.kryo.StateMachineContextSerializer;
import org.springframework.statemachine.kryo.UUIDSerializer;
import org.springframework.util.Assert;

public class ZookeeperStateMachinePersist<S, E>
implements StateMachinePersist<S, E, Stat> {
    private static final ThreadLocal<Kryo> kryoThreadLocal = new ThreadLocal<Kryo>(){

        @Override
        protected Kryo initialValue() {
            Kryo kryo = new Kryo();
            kryo.addDefaultSerializer(StateMachineContext.class, (Serializer)new StateMachineContextSerializer());
            kryo.addDefaultSerializer(MessageHeaders.class, (Serializer)new MessageHeadersSerializer());
            kryo.addDefaultSerializer(UUID.class, (Serializer)new UUIDSerializer());
            return kryo;
        }
    };
    private final CuratorFramework curatorClient;
    private final String path;
    private final String logPath;
    private final int logSize;

    public ZookeeperStateMachinePersist(CuratorFramework curatorClient, String path) {
        this(curatorClient, path, null, 0);
    }

    public ZookeeperStateMachinePersist(CuratorFramework curatorClient, String path, String logPath, int logSize) {
        if (logPath != null) {
            Assert.state((logSize > 0 && (logSize & -logSize) == logSize ? 1 : 0) != 0, (String)"Log size must be positive and power of two");
        }
        this.curatorClient = curatorClient;
        this.path = path;
        this.logPath = logPath;
        this.logSize = logSize;
    }

    public void write(StateMachineContext<S, E> context, Stat stat) {
        byte[] data = this.serialize(context);
        CuratorTransaction tx = this.curatorClient.inTransaction();
        try {
            CuratorTransactionFinal tt = ((CuratorTransactionBridge)((PathAndBytesable)tx.setData().withVersion(stat.getVersion())).forPath(this.path, data)).and();
            if (this.logPath != null) {
                tt = ((CuratorTransactionBridge)tt.setData().forPath(this.logPath + "/" + stat.getVersion() % this.logSize, data)).and();
            }
            Collection results = tt.commit();
            int version = ((CuratorTransactionResult)results.iterator().next()).getResultStat().getVersion();
            stat.setVersion(version);
        }
        catch (Exception e) {
            throw new StateMachineException("Error persisting data", e);
        }
    }

    public StateMachineContext<S, E> read(Stat stat) throws Exception {
        return this.deserialize((byte[])((WatchPathable)this.curatorClient.getData().storingStatIn(stat)).forPath(this.path));
    }

    public StateMachineContext<S, E> readLog(int version, Stat stat) throws Exception {
        return this.deserialize((byte[])((WatchPathable)this.curatorClient.getData().storingStatIn(stat)).forPath(this.logPath + "/" + version));
    }

    private byte[] serialize(StateMachineContext<S, E> context) {
        Kryo kryo = kryoThreadLocal.get();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)out);
        kryo.writeObject(output, context);
        output.close();
        return out.toByteArray();
    }

    private StateMachineContext<S, E> deserialize(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        Kryo kryo = kryoThreadLocal.get();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        Input input = new Input((InputStream)in);
        return (StateMachineContext)kryo.readObject(input, StateMachineContext.class);
    }
}

