/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.style.DefaultToStringStyler;
import org.springframework.core.style.SimpleValueStyler;
import org.springframework.core.style.ToStringCreator;
import org.springframework.core.style.ToStringStyler;
import org.springframework.core.style.ValueStyler;
import org.springframework.lang.Nullable;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextLoader;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MergedContextConfiguration
implements Serializable {
    private static final long serialVersionUID = -3290560718464957422L;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Set<Class<? extends ApplicationContextInitializer<?>>> EMPTY_INITIALIZER_CLASSES = Collections.emptySet();
    private static final Set<ContextCustomizer> EMPTY_CONTEXT_CUSTOMIZERS = Collections.emptySet();
    private final Class<?> testClass;
    private final String[] locations;
    private final Class<?>[] classes;
    private final Set<Class<? extends ApplicationContextInitializer<?>>> contextInitializerClasses;
    private final String[] activeProfiles;
    private final String[] propertySourceLocations;
    private final String[] propertySourceProperties;
    private final Set<ContextCustomizer> contextCustomizers;
    private final ContextLoader contextLoader;
    @Nullable
    private final CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate;
    @Nullable
    private final MergedContextConfiguration parent;

    public MergedContextConfiguration(Class<?> testClass, @Nullable String[] locations, @Nullable Class<?>[] classes, @Nullable String[] activeProfiles, ContextLoader contextLoader) {
        this(testClass, locations, classes, null, activeProfiles, contextLoader);
    }

    public MergedContextConfiguration(Class<?> testClass, @Nullable String[] locations, @Nullable Class<?>[] classes, @Nullable Set<Class<? extends ApplicationContextInitializer<?>>> contextInitializerClasses, @Nullable String[] activeProfiles, ContextLoader contextLoader) {
        this(testClass, locations, classes, contextInitializerClasses, activeProfiles, contextLoader, null, null);
    }

    public MergedContextConfiguration(Class<?> testClass, @Nullable String[] locations, @Nullable Class<?>[] classes, @Nullable Set<Class<? extends ApplicationContextInitializer<?>>> contextInitializerClasses, @Nullable String[] activeProfiles, ContextLoader contextLoader, @Nullable CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, @Nullable MergedContextConfiguration parent) {
        this(testClass, locations, classes, contextInitializerClasses, activeProfiles, null, null, contextLoader, cacheAwareContextLoaderDelegate, parent);
    }

    public MergedContextConfiguration(MergedContextConfiguration mergedConfig) {
        this(mergedConfig.testClass, mergedConfig.locations, mergedConfig.classes, mergedConfig.contextInitializerClasses, mergedConfig.activeProfiles, mergedConfig.propertySourceLocations, mergedConfig.propertySourceProperties, mergedConfig.contextCustomizers, mergedConfig.contextLoader, mergedConfig.cacheAwareContextLoaderDelegate, mergedConfig.parent);
    }

    public MergedContextConfiguration(Class<?> testClass, @Nullable String[] locations, @Nullable Class<?>[] classes, @Nullable Set<Class<? extends ApplicationContextInitializer<?>>> contextInitializerClasses, @Nullable String[] activeProfiles, @Nullable String[] propertySourceLocations, @Nullable String[] propertySourceProperties, ContextLoader contextLoader, @Nullable CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, @Nullable MergedContextConfiguration parent) {
        this(testClass, locations, classes, contextInitializerClasses, activeProfiles, propertySourceLocations, propertySourceProperties, EMPTY_CONTEXT_CUSTOMIZERS, contextLoader, cacheAwareContextLoaderDelegate, parent);
    }

    public MergedContextConfiguration(Class<?> testClass, @Nullable String[] locations, @Nullable Class<?>[] classes, @Nullable Set<Class<? extends ApplicationContextInitializer<?>>> contextInitializerClasses, @Nullable String[] activeProfiles, @Nullable String[] propertySourceLocations, @Nullable String[] propertySourceProperties, @Nullable Set<ContextCustomizer> contextCustomizers, ContextLoader contextLoader, @Nullable CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, @Nullable MergedContextConfiguration parent) {
        this.testClass = testClass;
        this.locations = MergedContextConfiguration.processStrings(locations);
        this.classes = MergedContextConfiguration.processClasses(classes);
        this.contextInitializerClasses = MergedContextConfiguration.processContextInitializerClasses(contextInitializerClasses);
        this.activeProfiles = MergedContextConfiguration.processActiveProfiles(activeProfiles);
        this.propertySourceLocations = MergedContextConfiguration.processStrings(propertySourceLocations);
        this.propertySourceProperties = MergedContextConfiguration.processStrings(propertySourceProperties);
        this.contextCustomizers = MergedContextConfiguration.processContextCustomizers(contextCustomizers);
        this.contextLoader = contextLoader;
        this.cacheAwareContextLoaderDelegate = cacheAwareContextLoaderDelegate;
        this.parent = parent;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public Class<?>[] getClasses() {
        return this.classes;
    }

    public boolean hasLocations() {
        return !ObjectUtils.isEmpty((Object[])this.getLocations());
    }

    public boolean hasClasses() {
        return !ObjectUtils.isEmpty((Object[])this.getClasses());
    }

    public boolean hasResources() {
        return this.hasLocations() || this.hasClasses();
    }

    public Set<Class<? extends ApplicationContextInitializer<?>>> getContextInitializerClasses() {
        return this.contextInitializerClasses;
    }

    public String[] getActiveProfiles() {
        return this.activeProfiles;
    }

    public String[] getPropertySourceLocations() {
        return this.propertySourceLocations;
    }

    public String[] getPropertySourceProperties() {
        return this.propertySourceProperties;
    }

    public Set<ContextCustomizer> getContextCustomizers() {
        return this.contextCustomizers;
    }

    public ContextLoader getContextLoader() {
        return this.contextLoader;
    }

    @Nullable
    public MergedContextConfiguration getParent() {
        return this.parent;
    }

    @Nullable
    public ApplicationContext getParentApplicationContext() {
        if (this.parent == null) {
            return null;
        }
        Assert.state((this.cacheAwareContextLoaderDelegate != null ? 1 : 0) != 0, (String)"Cannot retrieve a parent application context without access to the CacheAwareContextLoaderDelegate");
        return this.cacheAwareContextLoaderDelegate.loadContext(this.parent);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        MergedContextConfiguration otherConfig = (MergedContextConfiguration)other;
        if (!Arrays.equals(this.locations, otherConfig.locations)) {
            return false;
        }
        if (!Arrays.equals(this.classes, otherConfig.classes)) {
            return false;
        }
        if (!this.contextInitializerClasses.equals(otherConfig.contextInitializerClasses)) {
            return false;
        }
        if (!Arrays.equals(this.activeProfiles, otherConfig.activeProfiles)) {
            return false;
        }
        if (!Arrays.equals(this.propertySourceLocations, otherConfig.propertySourceLocations)) {
            return false;
        }
        if (!Arrays.equals(this.propertySourceProperties, otherConfig.propertySourceProperties)) {
            return false;
        }
        if (!this.contextCustomizers.equals(otherConfig.contextCustomizers)) {
            return false;
        }
        if (this.parent == null ? otherConfig.parent != null : !this.parent.equals(otherConfig.parent)) {
            return false;
        }
        return MergedContextConfiguration.nullSafeClassName(this.contextLoader).equals(MergedContextConfiguration.nullSafeClassName(otherConfig.contextLoader));
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.locations);
        result = 31 * result + Arrays.hashCode(this.classes);
        result = 31 * result + this.contextInitializerClasses.hashCode();
        result = 31 * result + Arrays.hashCode(this.activeProfiles);
        result = 31 * result + Arrays.hashCode(this.propertySourceLocations);
        result = 31 * result + Arrays.hashCode(this.propertySourceProperties);
        result = 31 * result + this.contextCustomizers.hashCode();
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        result = 31 * result + MergedContextConfiguration.nullSafeClassName(this.contextLoader).hashCode();
        return result;
    }

    public String toString() {
        return new ToStringCreator((Object)this, (ToStringStyler)new DefaultToStringStyler((ValueStyler)new SimpleValueStyler())).append("testClass", this.testClass).append("locations", (Object)this.locations).append("classes", this.classes).append("contextInitializerClasses", this.contextInitializerClasses).append("activeProfiles", (Object)this.activeProfiles).append("propertySourceLocations", (Object)this.propertySourceLocations).append("propertySourceProperties", (Object)this.propertySourceProperties).append("contextCustomizers", this.contextCustomizers).append("contextLoader", this.contextLoader != null ? this.contextLoader.getClass() : null).append("parent", (Object)this.parent).toString();
    }

    private static String[] processStrings(@Nullable String[] array) {
        return array != null ? array : EMPTY_STRING_ARRAY;
    }

    private static Class<?>[] processClasses(@Nullable Class<?>[] classes) {
        return classes != null ? classes : EMPTY_CLASS_ARRAY;
    }

    private static Set<Class<? extends ApplicationContextInitializer<?>>> processContextInitializerClasses(@Nullable Set<Class<? extends ApplicationContextInitializer<?>>> contextInitializerClasses) {
        return contextInitializerClasses != null ? Collections.unmodifiableSet(contextInitializerClasses) : EMPTY_INITIALIZER_CLASSES;
    }

    private static Set<ContextCustomizer> processContextCustomizers(@Nullable Set<ContextCustomizer> contextCustomizers) {
        return contextCustomizers != null ? Collections.unmodifiableSet(contextCustomizers) : EMPTY_CONTEXT_CUSTOMIZERS;
    }

    private static String[] processActiveProfiles(@Nullable String[] activeProfiles) {
        if (activeProfiles == null) {
            return EMPTY_STRING_ARRAY;
        }
        LinkedHashSet<String> profilesSet = new LinkedHashSet<String>(Arrays.asList(activeProfiles));
        return StringUtils.toStringArray(profilesSet);
    }

    protected static String nullSafeClassName(@Nullable ContextLoader contextLoader) {
        return contextLoader != null ? contextLoader.getClass().getName() : "null";
    }
}

