/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.test.context.ContextLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContextLoader
implements ContextLoader {
    protected boolean isGenerateDefaultLocations() {
        return true;
    }

    protected abstract String getResourceSuffix();

    @Override
    public final String[] processLocations(Class<?> clazz, String ... locations) {
        return ObjectUtils.isEmpty((Object[])locations) && this.isGenerateDefaultLocations() ? this.generateDefaultLocations(clazz) : this.modifyLocations(clazz, locations);
    }

    protected String[] generateDefaultLocations(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz can not be null.");
        Assert.hasText((String)this.getResourceSuffix(), (String)"resourceSuffix can not be empty.");
        return new String[]{"classpath:/" + ClassUtils.convertClassNameToResourcePath((String)clazz.getName()) + this.getResourceSuffix()};
    }

    protected String[] modifyLocations(Class<?> clazz, String ... locations) {
        String[] modifiedLocations = new String[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            String path = locations[i];
            modifiedLocations[i] = path.startsWith("/") ? "classpath:" + path : (!ResourcePatternUtils.isUrl((String)path) ? "classpath:/" + StringUtils.cleanPath((String)(ClassUtils.classPackageAsResourcePath(clazz) + "/" + path)) : StringUtils.cleanPath((String)path));
        }
        return modifiedLocations;
    }
}

