/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.security.Principal;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.annotation.ReflectiveProcessor;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.handler.annotation.DestinationVariable;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.MessageExceptionHandler;
import org.springframework.messaging.support.MessageHeaderAccessor;

public class MessageMappingReflectiveProcessor
implements ReflectiveProcessor {
    private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

    public void registerReflectionHints(ReflectionHints hints, AnnotatedElement element) {
        if (element instanceof Class) {
            Class type = (Class)element;
            this.registerTypeHints(hints, type);
        } else if (element instanceof Method) {
            Method method = (Method)element;
            this.registerMethodHints(hints, method);
            if (element.isAnnotationPresent(MessageExceptionHandler.class)) {
                this.registerMessageExceptionHandlerHints(hints, element.getAnnotation(MessageExceptionHandler.class));
            }
        }
    }

    protected void registerTypeHints(ReflectionHints hints, Class<?> type) {
        hints.registerType(type, new MemberCategory[0]);
    }

    protected void registerMethodHints(ReflectionHints hints, Method method) {
        hints.registerMethod(method, ExecutableMode.INVOKE);
        this.registerParameterHints(hints, method);
        this.registerReturnValueHints(hints, method);
    }

    protected void registerParameterHints(ReflectionHints hints, Method method) {
        hints.registerMethod(method, ExecutableMode.INVOKE);
        for (Parameter parameter : method.getParameters()) {
            MethodParameter methodParameter = MethodParameter.forParameter((Parameter)parameter);
            if (Message.class.isAssignableFrom(methodParameter.getParameterType())) {
                Type messageType = this.getMessageType(methodParameter);
                if (messageType == null) continue;
                this.bindingRegistrar.registerReflectionHints(hints, new Type[]{messageType});
                continue;
            }
            if (!this.couldBePayload(methodParameter)) continue;
            this.bindingRegistrar.registerReflectionHints(hints, new Type[]{methodParameter.getGenericParameterType()});
        }
    }

    protected void registerMessageExceptionHandlerHints(ReflectionHints hints, MessageExceptionHandler annotation) {
        for (Class<? extends Throwable> exceptionClass : annotation.value()) {
            hints.registerType(exceptionClass, new MemberCategory[0]);
        }
    }

    protected boolean couldBePayload(MethodParameter methodParameter) {
        return !methodParameter.hasParameterAnnotation(DestinationVariable.class) && !methodParameter.hasParameterAnnotation(Header.class) && !methodParameter.hasParameterAnnotation(Headers.class) && !MessageHeaders.class.isAssignableFrom(methodParameter.getParameterType()) && !MessageHeaderAccessor.class.isAssignableFrom(methodParameter.getParameterType()) && !Principal.class.isAssignableFrom(methodParameter.nestedIfOptional().getNestedParameterType());
    }

    protected void registerReturnValueHints(ReflectionHints hints, Method method) {
        MethodParameter returnType = MethodParameter.forExecutable((Executable)method, (int)-1);
        this.bindingRegistrar.registerReflectionHints(hints, new Type[]{returnType.getGenericParameterType()});
    }

    protected @Nullable Type getMessageType(MethodParameter parameter) {
        MethodParameter nestedParameter = parameter.nested();
        return nestedParameter.getNestedParameterType() == nestedParameter.getParameterType() ? null : nestedParameter.getNestedParameterType();
    }
}

