/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.table;

import org.springframework.shell.table.SizeConstraints;

public class KeyValueSizeConstraints
implements SizeConstraints {
    private final String delimiter;

    public KeyValueSizeConstraints(String delimiter) {
        this.delimiter = delimiter;
    }

    private static String leftTrim(String raw) {
        int start;
        int length = raw.length();
        for (start = 0; start < length && raw.charAt(start) == ' '; ++start) {
        }
        return raw.substring(start);
    }

    private static String rightTrim(String raw) {
        int end;
        for (end = raw.length(); end > 0 && raw.charAt(end - 1) == ' '; --end) {
        }
        return raw.substring(0, end);
    }

    @Override
    public SizeConstraints.Extent width(String[] raw, int tableWidth, int nbColumns) {
        int maxLeft = 0;
        int maxRight = 0;
        int min = 0;
        for (String line : raw) {
            String lineToConsider = line.trim();
            int offset = lineToConsider.indexOf(this.delimiter);
            if (offset != -1) {
                String minimalLeftPart = lineToConsider.substring(0, offset).trim();
                String minimalRightPart = lineToConsider.substring(offset + this.delimiter.length()).trim();
                int left = minimalLeftPart.length();
                int right = minimalRightPart.length();
                int case1 = Math.max(left, right + KeyValueSizeConstraints.leftTrim(this.delimiter).length());
                int case2 = Math.max(left + KeyValueSizeConstraints.rightTrim(this.delimiter).length(), right);
                int bestMin = Math.min(case1, case2);
                min = Math.max(min, bestMin);
                maxLeft = Math.max(maxLeft, offset);
                int after = lineToConsider.length() - offset - this.delimiter.length();
                maxRight = Math.max(maxRight, after);
                continue;
            }
            min = Math.max(min, lineToConsider.length());
        }
        return new SizeConstraints.Extent(min, maxLeft + this.delimiter.length() + maxRight);
    }
}

