/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.standard.commands;

import org.springframework.core.io.ResourceLoader;
import org.springframework.shell.standard.AbstractShellComponent;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.completion.BashCompletions;
import org.springframework.shell.standard.completion.ZshCompletions;

@ShellComponent
public class Completion
extends AbstractShellComponent {
    private ResourceLoader resourceLoader;
    private String rootCommand;

    public Completion(String rootCommand) {
        this.rootCommand = rootCommand;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @ShellMethod(key={"completion bash"}, value="Generate bash completion script")
    public String bash() {
        BashCompletions bashCompletions = new BashCompletions(this.resourceLoader, this.getCommandCatalog());
        return bashCompletions.generate(this.rootCommand);
    }

    @ShellMethod(key={"completion zsh"}, value="Generate zsh completion script")
    public String zsh() {
        ZshCompletions zshCompletions = new ZshCompletions(this.resourceLoader, this.getCommandCatalog());
        return zshCompletions.generate(this.rootCommand);
    }

    public static interface Command {
    }
}

