/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.log.LogMessage;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractAuthenticationTargetUrlRequestHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private @Nullable String targetUrlParameter = null;
    private String defaultTargetUrl = "/";
    private boolean alwaysUseDefaultTargetUrl = false;
    private boolean useReferer = false;
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    protected AbstractAuthenticationTargetUrlRequestHandler() {
    }

    protected void handle(HttpServletRequest request, HttpServletResponse response, @Nullable Authentication authentication) throws IOException, ServletException {
        String targetUrl = this.determineTargetUrl(request, response, authentication);
        if (response.isCommitted()) {
            this.logger.debug((Object)LogMessage.format((String)"Did not redirect to %s since response already committed.", (Object)targetUrl));
            return;
        }
        this.redirectStrategy.sendRedirect(request, response, targetUrl);
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response, @Nullable Authentication authentication) {
        return this.determineTargetUrl(request, response);
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        if (this.isAlwaysUseDefaultTargetUrl()) {
            return this.defaultTargetUrl;
        }
        String targetUrlParameterValue = this.getTargetUrlParameterValue(request);
        if (StringUtils.hasText((String)targetUrlParameterValue)) {
            this.trace("Using url %s from request parameter %s", targetUrlParameterValue, this.targetUrlParameter);
            return targetUrlParameterValue;
        }
        if (this.useReferer) {
            this.trace("Using url %s from Referer header", request.getHeader("Referer"));
            return request.getHeader("Referer");
        }
        return this.defaultTargetUrl;
    }

    private @Nullable String getTargetUrlParameterValue(HttpServletRequest request) {
        if (this.targetUrlParameter == null) {
            return null;
        }
        String value = request.getParameter(this.targetUrlParameter);
        if (value == null) {
            return null;
        }
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        return this.defaultTargetUrl;
    }

    private void trace(String msg, String ... msgParts) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)LogMessage.format((String)msg, (Object[])msgParts));
        }
    }

    protected final String getDefaultTargetUrl() {
        return this.defaultTargetUrl;
    }

    public void setDefaultTargetUrl(String defaultTargetUrl) {
        Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl(defaultTargetUrl), (String)"defaultTarget must start with '/' or with 'http(s)'");
        this.defaultTargetUrl = defaultTargetUrl;
    }

    public void setAlwaysUseDefaultTargetUrl(boolean alwaysUseDefaultTargetUrl) {
        this.alwaysUseDefaultTargetUrl = alwaysUseDefaultTargetUrl;
    }

    protected boolean isAlwaysUseDefaultTargetUrl() {
        return this.alwaysUseDefaultTargetUrl;
    }

    public void setTargetUrlParameter(String targetUrlParameter) {
        if (targetUrlParameter != null) {
            Assert.hasText((String)targetUrlParameter, (String)"targetUrlParameter cannot be empty");
        }
        this.targetUrlParameter = targetUrlParameter;
    }

    protected @Nullable String getTargetUrlParameter() {
        return this.targetUrlParameter;
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        Assert.notNull((Object)redirectStrategy, (String)"redirectStrategy cannot be null");
        this.redirectStrategy = redirectStrategy;
    }

    protected RedirectStrategy getRedirectStrategy() {
        return this.redirectStrategy;
    }

    public void setUseReferer(boolean useReferer) {
        this.useReferer = useReferer;
    }
}

