/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.util.matcher.IpAddressMatcher;
import org.springframework.util.Assert;

public final class IpAddressAuthorizationManager
implements AuthorizationManager<RequestAuthorizationContext> {
    private final IpAddressMatcher ipAddressMatcher;

    IpAddressAuthorizationManager(String ipAddress) {
        this.ipAddressMatcher = new IpAddressMatcher(ipAddress);
    }

    public static IpAddressAuthorizationManager hasIpAddress(String ipAddress) {
        Assert.notNull((Object)ipAddress, (String)"ipAddress cannot be null");
        return new IpAddressAuthorizationManager(ipAddress);
    }

    public AuthorizationResult authorize(Supplier<? extends @Nullable Authentication> authentication, RequestAuthorizationContext requestAuthorizationContext) {
        return new AuthorizationDecision(this.ipAddressMatcher.matcher(requestAuthorizationContext.getRequest()).isMatch());
    }
}

