/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.cas.web;

import jakarta.servlet.http.HttpServletRequest;
import org.apereo.cas.client.authentication.DefaultGatewayResolverImpl;
import org.apereo.cas.client.authentication.GatewayResolver;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class CasGatewayResolverRequestMatcher
implements RequestMatcher {
    private final ServiceProperties serviceProperties;
    private GatewayResolver gatewayStorage = new DefaultGatewayResolverImpl();

    public CasGatewayResolverRequestMatcher(ServiceProperties serviceProperties) {
        Assert.notNull((Object)serviceProperties, (String)"serviceProperties cannot be null");
        this.serviceProperties = serviceProperties;
    }

    public boolean matches(HttpServletRequest request) {
        boolean wasGatewayed = this.gatewayStorage.hasGatewayedAlready(request, this.serviceProperties.getService());
        if (!wasGatewayed) {
            this.gatewayStorage.storeGatewayInformation(request, this.serviceProperties.getService());
            return true;
        }
        return false;
    }

    public void setGatewayStorage(GatewayResolver gatewayStorage) {
        Assert.notNull((Object)gatewayStorage, (String)"gatewayStorage cannot be null");
        this.gatewayStorage = gatewayStorage;
    }
}

