/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.support.JacksonMapperUtils;
import org.springframework.kafka.support.mapping.DefaultJacksonJavaTypeMapper;
import org.springframework.kafka.support.mapping.JacksonJavaTypeMapper;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectWriter;
import tools.jackson.databind.json.JsonMapper;

public class JacksonJsonSerializer<T>
implements Serializer<T> {
    public static final String ADD_TYPE_INFO_HEADERS = "spring.json.add.type.headers";
    public static final String TYPE_MAPPINGS = "spring.json.type.mapping";
    protected final JsonMapper jsonMapper;
    protected boolean addTypeInfo = true;
    private ObjectWriter writer;
    protected JacksonJavaTypeMapper typeMapper = new DefaultJacksonJavaTypeMapper();
    private boolean typeMapperExplicitlySet = false;
    private boolean setterCalled;
    private boolean configured;
    private final Lock globalLock = new ReentrantLock();

    public JacksonJsonSerializer() {
        this((JavaType)null, JacksonMapperUtils.enhancedJsonMapper());
    }

    public JacksonJsonSerializer(TypeReference<? super T> targetType) {
        this(targetType, JacksonMapperUtils.enhancedJsonMapper());
    }

    public JacksonJsonSerializer(JsonMapper jsonMapper) {
        this((JavaType)null, jsonMapper);
    }

    public JacksonJsonSerializer(TypeReference<? super T> targetType, JsonMapper jsonMapper) {
        this(targetType == null ? null : jsonMapper.constructType(targetType.getType()), jsonMapper);
    }

    public JacksonJsonSerializer(@Nullable JavaType targetType, JsonMapper jsonMapper) {
        Assert.notNull((Object)jsonMapper, (String)"'jsonMapper' must not be null.");
        this.jsonMapper = jsonMapper;
        this.writer = jsonMapper.writerFor(targetType);
    }

    public boolean isAddTypeInfo() {
        return this.addTypeInfo;
    }

    public void setAddTypeInfo(boolean addTypeInfo) {
        this.addTypeInfo = addTypeInfo;
        this.setterCalled = true;
    }

    public JacksonJavaTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public void setTypeMapper(JacksonJavaTypeMapper typeMapper) {
        Assert.notNull((Object)typeMapper, (String)"'typeMapper' cannot be null");
        this.typeMapper = typeMapper;
        this.typeMapperExplicitlySet = true;
        this.setterCalled = true;
    }

    public void setUseTypeMapperForKey(boolean isKey) {
        if (!this.typeMapperExplicitlySet && this.getTypeMapper() instanceof DefaultJacksonJavaTypeMapper) {
            ((DefaultJacksonJavaTypeMapper)this.getTypeMapper()).setUseForKey(isKey);
        }
        this.setterCalled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Map<String, ?> configs, boolean isKey) {
        try {
            JacksonJavaTypeMapper jacksonJavaTypeMapper;
            this.globalLock.lock();
            if (this.configured) {
                return;
            }
            Assert.state((!this.setterCalled || !configs.containsKey(ADD_TYPE_INFO_HEADERS) && !configs.containsKey(TYPE_MAPPINGS) ? 1 : 0) != 0, (String)"JsonSerializer must be configured with property setters, or via configuration properties; not both");
            this.setUseTypeMapperForKey(isKey);
            if (configs.containsKey(ADD_TYPE_INFO_HEADERS)) {
                Object config = configs.get(ADD_TYPE_INFO_HEADERS);
                if (config instanceof Boolean) {
                    Boolean configBoolean = (Boolean)config;
                    this.addTypeInfo = configBoolean;
                } else if (config instanceof String) {
                    String configString = (String)config;
                    this.addTypeInfo = Boolean.parseBoolean(configString);
                } else {
                    throw new IllegalStateException("spring.json.add.type.headers must be Boolean or String");
                }
            }
            if (configs.containsKey(TYPE_MAPPINGS) && !this.typeMapperExplicitlySet && (jacksonJavaTypeMapper = this.typeMapper) instanceof DefaultJacksonJavaTypeMapper) {
                DefaultJacksonJavaTypeMapper abstractJavaTypeMapper = (DefaultJacksonJavaTypeMapper)jacksonJavaTypeMapper;
                abstractJavaTypeMapper.setIdClassMapping(JacksonJsonSerializer.createMappings((String)configs.get(TYPE_MAPPINGS)));
            }
            this.configured = true;
        }
        finally {
            this.globalLock.unlock();
        }
    }

    protected static Map<String, Class<?>> createMappings(String mappings) {
        String[] array;
        HashMap mappingsMap = new HashMap();
        for (String entry : array = StringUtils.commaDelimitedListToStringArray((String)mappings)) {
            String[] split = entry.split(":");
            Assert.isTrue((split.length == 2 ? 1 : 0) != 0, (String)"Each comma-delimited mapping entry must have exactly one ':'");
            try {
                mappingsMap.put(split[0].trim(), ClassUtils.forName((String)split[1].trim(), (ClassLoader)ClassUtils.getDefaultClassLoader()));
            }
            catch (ClassNotFoundException | LinkageError e) {
                throw new IllegalArgumentException("Failed to load: " + split[1] + " for " + split[0], e);
            }
        }
        return mappingsMap;
    }

    public byte @Nullable [] serialize(String topic, Headers headers, @Nullable T data) {
        if (data == null) {
            return null;
        }
        if (this.addTypeInfo && headers != null) {
            this.typeMapper.fromJavaType(this.jsonMapper.constructType(data.getClass()), headers);
        }
        return this.serialize(topic, data);
    }

    public byte @Nullable [] serialize(String topic, @Nullable T data) {
        if (data == null) {
            return null;
        }
        try {
            return this.writer.writeValueAsBytes(data);
        }
        catch (Exception ex) {
            throw new SerializationException("Can't serialize data [" + String.valueOf(data) + "] for topic [" + topic + "]", (Throwable)ex);
        }
    }

    public void close() {
    }

    public <X> JacksonJsonSerializer<X> copyWithType(Class<? super X> newTargetType) {
        return this.copyWithType(this.jsonMapper.constructType(newTargetType));
    }

    public <X> JacksonJsonSerializer<X> copyWithType(TypeReference<? super X> newTargetType) {
        return this.copyWithType(this.jsonMapper.constructType(newTargetType.getType()));
    }

    public <X> JacksonJsonSerializer<X> copyWithType(JavaType newTargetType) {
        JacksonJsonSerializer<T> result = new JacksonJsonSerializer<T>(newTargetType, this.jsonMapper);
        result.addTypeInfo = this.addTypeInfo;
        result.typeMapper = this.typeMapper;
        result.typeMapperExplicitlySet = this.typeMapperExplicitlySet;
        return result;
    }

    public JacksonJsonSerializer<T> forKeys() {
        this.setUseTypeMapperForKey(true);
        return this;
    }

    public JacksonJsonSerializer<T> noTypeInfo() {
        this.setAddTypeInfo(false);
        return this;
    }

    public JacksonJsonSerializer<T> typeMapper(JacksonJavaTypeMapper mapper) {
        this.setTypeMapper(mapper);
        return this;
    }
}

