/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.common.TopicPartition;
import org.jspecify.annotations.Nullable;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.listener.ConsumerSeekAware;
import org.springframework.kafka.listener.DelegatingMessageListener;
import org.springframework.kafka.listener.ListenerType;
import org.springframework.kafka.listener.ListenerUtils;

public abstract class AbstractDelegatingMessageListenerAdapter<T>
implements ConsumerSeekAware,
DelegatingMessageListener<T> {
    protected final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    protected final T delegate;
    protected final ListenerType delegateType;
    private final @Nullable ConsumerSeekAware seekAware;

    public AbstractDelegatingMessageListenerAdapter(T delegate) {
        this.delegate = delegate;
        this.delegateType = ListenerUtils.determineListenerType(delegate);
        this.seekAware = delegate instanceof ConsumerSeekAware ? (ConsumerSeekAware)delegate : null;
    }

    @Override
    public T getDelegate() {
        return this.delegate;
    }

    @Override
    public void registerSeekCallback(ConsumerSeekAware.ConsumerSeekCallback callback) {
        if (this.seekAware != null) {
            this.seekAware.registerSeekCallback(callback);
        }
    }

    @Override
    public void onPartitionsAssigned(Map<TopicPartition, Long> assignments, ConsumerSeekAware.ConsumerSeekCallback callback) {
        if (this.seekAware != null) {
            this.seekAware.onPartitionsAssigned(assignments, callback);
        }
    }

    @Override
    public void onPartitionsRevoked(@Nullable Collection<TopicPartition> partitions) {
        if (this.seekAware != null) {
            this.seekAware.onPartitionsRevoked(partitions);
        }
    }

    @Override
    public void onIdleContainer(Map<TopicPartition, Long> assignments, ConsumerSeekAware.ConsumerSeekCallback callback) {
        if (this.seekAware != null) {
            this.seekAware.onIdleContainer(assignments, callback);
        }
    }
}

