/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import org.apache.kafka.common.utils.Bytes;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.support.KafkaNull;
import org.springframework.kafka.support.converter.ConversionException;
import org.springframework.kafka.support.converter.JacksonJsonMessageConverter;
import org.springframework.messaging.Message;
import tools.jackson.databind.json.JsonMapper;

public class BytesJacksonJsonMessageConverter
extends JacksonJsonMessageConverter {
    public BytesJacksonJsonMessageConverter() {
    }

    public BytesJacksonJsonMessageConverter(JsonMapper jsonMapper) {
        super(jsonMapper);
    }

    @Override
    protected @Nullable Object convertPayload(Message<?> message) {
        try {
            return message.getPayload() instanceof KafkaNull ? null : Bytes.wrap((byte[])this.getJsonMapper().writeValueAsBytes(message.getPayload()));
        }
        catch (Exception e) {
            throw new ConversionException("Failed to convert to JSON", message, (Throwable)e);
        }
    }
}

