/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.annotation;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.kafka.annotation.DltHandler;
import org.springframework.kafka.annotation.RetryableTopic;
import org.springframework.kafka.core.KafkaOperations;
import org.springframework.kafka.retrytopic.RetryTopicConfiguration;
import org.springframework.kafka.retrytopic.RetryTopicConfigurationBuilder;
import org.springframework.kafka.retrytopic.RetryTopicConfigurer;
import org.springframework.kafka.support.EndpointHandlerMethod;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.backoff.ExponentialRandomBackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.backoff.SleepingBackOffPolicy;
import org.springframework.retry.backoff.UniformRandomBackOffPolicy;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class RetryableTopicAnnotationProcessor {
    private static final String NULL = "null";
    private static final String THE_OSQ = "The [";
    private static final String RESOLVED_TO_OSQ = "Resolved to [";
    private static final String CSQ = "]";
    private static final String CSQ_FOR_OSQ = "] for [";
    private final BeanFactory beanFactory;
    private final BeanExpressionResolver resolver;
    private final BeanExpressionContext expressionContext;

    public RetryableTopicAnnotationProcessor(BeanFactory beanFactory) {
        this(beanFactory, (BeanExpressionResolver)new StandardBeanExpressionResolver(), beanFactory instanceof ConfigurableBeanFactory ? new BeanExpressionContext((ConfigurableBeanFactory)beanFactory, null) : null);
    }

    public RetryableTopicAnnotationProcessor(BeanFactory beanFactory, BeanExpressionResolver resolver, BeanExpressionContext expressionContext) {
        this.beanFactory = beanFactory;
        this.resolver = resolver;
        this.expressionContext = expressionContext;
    }

    public RetryTopicConfiguration processAnnotation(String[] topics, Method method, RetryableTopic annotation, Object bean) {
        Long resolvedTimeout = this.resolveExpressionAsLong(annotation.timeout(), "timeout", false);
        long timeout = -1L;
        if (resolvedTimeout != null) {
            timeout = resolvedTimeout;
        }
        List<Class<? extends Throwable>> includes = this.resolveClasses(annotation.include(), annotation.includeNames(), "include");
        List<Class<? extends Throwable>> excludes = this.resolveClasses(annotation.exclude(), annotation.excludeNames(), "exclude");
        boolean traverse = false;
        if (StringUtils.hasText((String)annotation.traversingCauses())) {
            Boolean traverseResolved = this.resolveExpressionAsBoolean(annotation.traversingCauses(), "traversingCauses");
            traverse = traverseResolved != null ? traverseResolved : includes.size() > 0 || excludes.size() > 0;
        }
        Boolean autoStartDlt = null;
        if (StringUtils.hasText((String)annotation.autoStartDltHandler())) {
            autoStartDlt = this.resolveExpressionAsBoolean(annotation.autoStartDltHandler(), "autoStartDltContainer");
        }
        return RetryTopicConfigurationBuilder.newInstance().maxAttempts(this.resolveExpressionAsInteger(annotation.attempts(), "attempts", true)).concurrency(this.resolveExpressionAsInteger(annotation.concurrency(), "concurrency", false)).customBackoff(this.createBackoffFromAnnotation(annotation.backoff(), this.beanFactory)).retryTopicSuffix(this.resolveExpressionAsString(annotation.retryTopicSuffix(), "retryTopicSuffix")).dltSuffix(this.resolveExpressionAsString(annotation.dltTopicSuffix(), "dltTopicSuffix")).dltHandlerMethod(this.getDltProcessor(method, bean)).includeTopics(Arrays.asList(topics)).listenerFactory(this.resolveExpressionAsString(annotation.listenerContainerFactory(), "listenerContainerFactory")).autoCreateTopics(this.resolveExpressionAsBoolean(annotation.autoCreateTopics(), "autoCreateTopics"), this.resolveExpressionAsInteger(annotation.numPartitions(), "numPartitions", true), this.resolveExpressionAsShort(annotation.replicationFactor(), "replicationFactor", true)).retryOn(includes).notRetryOn(excludes).traversingCauses(traverse).useSingleTopicForFixedDelays(annotation.fixedDelayTopicStrategy()).dltProcessingFailureStrategy(annotation.dltStrategy()).autoStartDltHandler(autoStartDlt).setTopicSuffixingStrategy(annotation.topicSuffixingStrategy()).sameIntervalTopicReuseStrategy(annotation.sameIntervalTopicReuseStrategy()).timeoutAfter(timeout).create(this.getKafkaTemplate(this.resolveExpressionAsString(annotation.kafkaTemplate(), "kafkaTemplate"), topics));
    }

    private SleepingBackOffPolicy<?> createBackoffFromAnnotation(Backoff backoff, BeanFactory beanFactory) {
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
        evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        Long min = backoff.delay() == 0L ? backoff.value() : backoff.delay();
        if (StringUtils.hasText((String)backoff.delayExpression())) {
            min = this.resolveExpressionAsLong(backoff.delayExpression(), "delayExpression", true);
        }
        Long max = backoff.maxDelay();
        if (StringUtils.hasText((String)backoff.maxDelayExpression())) {
            max = this.resolveExpressionAsLong(backoff.maxDelayExpression(), "maxDelayExpression", true);
        }
        Double multiplier = backoff.multiplier();
        if (StringUtils.hasText((String)backoff.multiplierExpression())) {
            multiplier = this.resolveExpressionAsDouble(backoff.multiplierExpression(), "multiplierExpression", true);
        }
        if (multiplier != null && multiplier > 0.0) {
            ExponentialBackOffPolicy policy = new ExponentialBackOffPolicy();
            if (backoff.random()) {
                policy = new ExponentialRandomBackOffPolicy();
            }
            policy.setInitialInterval(min.longValue());
            policy.setMultiplier(multiplier.doubleValue());
            policy.setMaxInterval(max > min ? max : 30000L);
            return policy;
        }
        if (max != null && min != null && max > min) {
            UniformRandomBackOffPolicy policy = new UniformRandomBackOffPolicy();
            policy.setMinBackOffPeriod(min.longValue());
            policy.setMaxBackOffPeriod(max.longValue());
            return policy;
        }
        FixedBackOffPolicy policy = new FixedBackOffPolicy();
        if (min != null) {
            policy.setBackOffPeriod(min.longValue());
        }
        return policy;
    }

    private EndpointHandlerMethod getDltProcessor(Method listenerMethod, Object bean) {
        Class<?> declaringClass = listenerMethod.getDeclaringClass();
        return Arrays.stream(ReflectionUtils.getDeclaredMethods(declaringClass)).filter(method -> AnnotationUtils.findAnnotation((Method)method, DltHandler.class) != null).map(method -> RetryTopicConfigurer.createHandlerMethodWith(bean, method)).findFirst().orElse(RetryTopicConfigurer.DEFAULT_DLT_HANDLER);
    }

    private KafkaOperations<?, ?> getKafkaTemplate(String kafkaTemplateName, String[] topics) {
        if (StringUtils.hasText((String)kafkaTemplateName)) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain kafka template by bean name");
            try {
                return (KafkaOperations)this.beanFactory.getBean(kafkaTemplateName, KafkaOperations.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException("Could not register Kafka listener endpoint for topics " + Arrays.asList(topics) + ", no " + KafkaOperations.class.getSimpleName() + " with id '" + kafkaTemplateName + "' was found in the application context", (Throwable)ex);
            }
        }
        try {
            return (KafkaOperations)this.beanFactory.getBean("defaultRetryTopicKafkaTemplate", KafkaOperations.class);
        }
        catch (NoSuchBeanDefinitionException ex2) {
            KafkaOperations kafkaOps = (KafkaOperations)this.beanFactory.getBeanProvider(KafkaOperations.class).getIfUnique();
            Assert.state((kafkaOps != null ? 1 : 0) != 0, () -> "A single KafkaTemplate bean could not be found in the context;  a single instance must exist, or one specifically named defaultRetryTopicKafkaTemplate");
            return kafkaOps;
        }
    }

    private String resolveExpressionAsString(String value, String attribute) {
        Object resolved = this.resolveExpression(value);
        if (resolved instanceof String) {
            return (String)resolved;
        }
        if (resolved != null) {
            throw new IllegalStateException(THE_OSQ + attribute + "] must resolve to a String. Resolved to [" + resolved.getClass() + CSQ_FOR_OSQ + value + CSQ);
        }
        return null;
    }

    private Integer resolveExpressionAsInteger(String value, String attribute, boolean required) {
        Object resolved = this.resolveExpression(value);
        Integer result = null;
        if (resolved instanceof String) {
            result = !required && !StringUtils.hasText((String)((String)resolved)) ? null : Integer.valueOf(Integer.parseInt((String)resolved));
        } else if (resolved instanceof Number) {
            result = ((Number)resolved).intValue();
        } else if (resolved != null || required) {
            throw new IllegalStateException(THE_OSQ + attribute + "] must resolve to an Number or a String that can be parsed as an Integer. Resolved to [" + (Serializable)(resolved == null ? NULL : resolved.getClass()) + CSQ_FOR_OSQ + value + CSQ);
        }
        return result;
    }

    private Short resolveExpressionAsShort(String value, String attribute, boolean required) {
        Object resolved = this.resolveExpression(value);
        Short result = null;
        if (resolved instanceof String) {
            result = !required && !StringUtils.hasText((String)((String)resolved)) ? null : Short.valueOf(Short.parseShort((String)resolved));
        } else if (resolved instanceof Number) {
            result = ((Number)resolved).shortValue();
        } else if (resolved != null || required) {
            throw new IllegalStateException(THE_OSQ + attribute + "] must resolve to an Number or a String that can be parsed as a Short. Resolved to [" + (Serializable)(resolved == null ? NULL : resolved.getClass()) + CSQ_FOR_OSQ + value + CSQ);
        }
        return result;
    }

    private Long resolveExpressionAsLong(String value, String attribute, boolean required) {
        Object resolved = this.resolveExpression(value);
        Long result = null;
        if (resolved instanceof String) {
            result = !required && !StringUtils.hasText((String)((String)resolved)) ? null : Long.valueOf(Long.parseLong((String)resolved));
        } else if (resolved instanceof Number) {
            result = ((Number)resolved).longValue();
        } else if (resolved != null || required) {
            throw new IllegalStateException(THE_OSQ + attribute + "] must resolve to an Number or a String that can be parsed as a Long. Resolved to [" + (Serializable)(resolved == null ? NULL : resolved.getClass()) + CSQ_FOR_OSQ + value + CSQ);
        }
        return result;
    }

    private Double resolveExpressionAsDouble(String value, String attribute, boolean required) {
        Object resolved = this.resolveExpression(value);
        Double result = null;
        if (resolved instanceof String) {
            result = !required && !StringUtils.hasText((String)((String)resolved)) ? null : Double.valueOf(Double.parseDouble((String)resolved));
        } else if (resolved instanceof Number) {
            result = ((Number)resolved).doubleValue();
        } else if (resolved != null || required) {
            throw new IllegalStateException(THE_OSQ + attribute + "] must resolve to an Number or a String that can be parsed as a Double. Resolved to [" + (Serializable)(resolved == null ? NULL : resolved.getClass()) + CSQ_FOR_OSQ + value + CSQ);
        }
        return result;
    }

    private Boolean resolveExpressionAsBoolean(String value, String attribute) {
        Object resolved = this.resolveExpression(value);
        Boolean result = null;
        if (resolved instanceof Boolean) {
            result = (Boolean)resolved;
        } else if (resolved instanceof String) {
            result = Boolean.parseBoolean((String)resolved);
        } else if (resolved != null) {
            throw new IllegalStateException(THE_OSQ + attribute + "] must resolve to a Boolean or a String that can be parsed as a Boolean. Resolved to [" + resolved.getClass() + CSQ_FOR_OSQ + value + CSQ);
        }
        return result;
    }

    private List<Class<? extends Throwable>> resolveClasses(Class<? extends Throwable>[] fromAnnot, String[] names, String type) {
        ArrayList<Class<? extends Throwable>> classes = new ArrayList<Class<? extends Throwable>>(Arrays.asList(fromAnnot));
        try {
            for (String name : names) {
                Class clazz = ClassUtils.forName((String)name, (ClassLoader)ClassUtils.getDefaultClassLoader());
                if (!Throwable.class.isAssignableFrom(clazz)) {
                    throw new IllegalStateException(type + " entry must be of type Throwable: " + clazz);
                }
                classes.add(clazz);
            }
        }
        catch (ClassNotFoundException | LinkageError ex) {
            throw new IllegalStateException(ex);
        }
        return classes;
    }

    private Object resolveExpression(String value) {
        String resolved = this.resolve(value);
        if (this.expressionContext != null) {
            return this.resolver.evaluate(resolved, this.expressionContext);
        }
        return value;
    }

    private String resolve(String value) {
        if (this.beanFactory != null && this.beanFactory instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)this.beanFactory).resolveEmbeddedValue(value);
        }
        return value;
    }
}

