/*
 * Copyright 2002-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.integration.syslog;

import org.springframework.integration.transformer.SyslogToMapTransformer;

/**
 * Headers in a {@code Map} generated by the @link {@link SyslogToMapTransformer} that
 * will be added to Spring Integration messages as headers, prefixed by {@link #PREFIX}.
 *
 * @author Gary Russell
 *
 * @since 3.0
 *
 */
public final class SyslogHeaders {

	private SyslogHeaders() {
	}

	public static final String PREFIX = "syslog_";

	public static final String FACILITY = PREFIX + SyslogToMapTransformer.FACILITY;

	public static final String SEVERITY = PREFIX + SyslogToMapTransformer.SEVERITY;

	public static final String TIMESTAMP = PREFIX + SyslogToMapTransformer.TIMESTAMP;

	public static final String HOST = PREFIX + SyslogToMapTransformer.HOST;

	public static final String TAG = PREFIX + SyslogToMapTransformer.TAG;

	//// RFC 5424 Parser:

	public static final String MESSAGE = PREFIX + "MESSAGE";

	public static final String APP_NAME = PREFIX + "APP_NAME";

	public static final String PROCID = PREFIX + "PROCID";

	public static final String MSGID = PREFIX + "MSGID";

	public static final String VERSION = PREFIX + "VERSION";

	public static final String STRUCTURED_DATA = PREFIX + "STRUCTURED_DATA";

	// Text versions of syslog numeric values
	public static final String SEVERITY_TEXT = PREFIX + "SEVERITY_TEXT";

	// Additional fields
	public static final String SOURCE_TYPE = PREFIX + "SOURCE_TYPE";

	public static final String SOURCE = PREFIX + "SOURCE";

	// full line when parse errors or retained original
	public static final String UNDECODED = PREFIX + "UNDECODED";

	public static final String DECODE_ERRORS = PREFIX + "DECODE_ERRORS";

	public static final String ERRORS = PREFIX + "ERRORS";

}
