/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.ip.config.IpAdapterParserUtils;
import org.springframework.integration.ip.udp.MulticastReceivingChannelAdapter;
import org.springframework.integration.ip.udp.UnicastReceivingChannelAdapter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class UdpInboundChannelAdapterParser
extends AbstractChannelAdapterParser {
    protected AbstractBeanDefinition doParse(Element element, ParserContext parserContext, String channelName) {
        BeanDefinitionBuilder builder = this.parseUdp(element, parserContext);
        IpAdapterParserUtils.addCommonSocketOptions(builder, element);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"receive-buffer-size");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"pool-size");
        builder.addPropertyReference("outputChannel", channelName);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-channel", (String)"errorChannel");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"task-executor");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"lookup-host");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"socket-customizer");
        return builder.getBeanDefinition();
    }

    private void addPortToConstructor(Element element, BeanDefinitionBuilder builder, ParserContext parserContext) {
        String port = IpAdapterParserUtils.getPort(element, parserContext);
        builder.addConstructorArgValue((Object)port);
    }

    private BeanDefinitionBuilder parseUdp(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder;
        String multicast = IpAdapterParserUtils.getMulticast(element);
        if (multicast.equals("false")) {
            builder = BeanDefinitionBuilder.genericBeanDefinition(UnicastReceivingChannelAdapter.class);
        } else {
            builder = BeanDefinitionBuilder.genericBeanDefinition(MulticastReceivingChannelAdapter.class);
            String mcAddress = element.getAttribute("multicast-address");
            if (!StringUtils.hasText((String)mcAddress)) {
                parserContext.getReaderContext().error("multicast-address is required for a multicast UDP/IP channel adapter", (Object)element);
            }
            builder.addConstructorArgValue((Object)mcAddress);
        }
        this.addPortToConstructor(element, builder, parserContext);
        IpAdapterParserUtils.addConstructorValueIfAttributeDefined(builder, element, "check-length");
        return builder;
    }
}

