/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.hateoas.LinkRelation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class StringLinkRelation
implements LinkRelation,
Serializable {
    private static final long serialVersionUID = -3904935345545567957L;
    private static final Map<String, StringLinkRelation> CACHE = new ConcurrentHashMap<String, StringLinkRelation>(256);
    private final String relation;

    @JsonCreator
    public static StringLinkRelation of(String relation) {
        Assert.hasText((String)relation, (String)"Relation must not be null or empty!");
        return CACHE.computeIfAbsent(relation, StringLinkRelation::new);
    }

    private StringLinkRelation(String relation) {
        Assert.notNull((Object)relation, (String)"relation cannot be null!");
        this.relation = relation;
    }

    @Override
    @JsonValue
    public String value() {
        return this.relation;
    }

    public String toString() {
        return this.value();
    }

    public int hashCode() {
        return this.relation.toLowerCase(Locale.US).hashCode();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringLinkRelation that = (StringLinkRelation)o;
        return this.relation.equalsIgnoreCase(that.relation);
    }

    public String getRelation() {
        return this.relation;
    }
}

