/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.test.autoconfigure;

import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.grpc.test.autoconfigure.AutoConfigureInProcessTransport;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextAnnotationUtils;

class InProcessTransportContextCustomizerFactory
implements ContextCustomizerFactory {
    static final String ENABLED_PROPERTY = "spring.grpc.test.inprocess.enabled";

    InProcessTransportContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        AutoConfigureInProcessTransport annotation = (AutoConfigureInProcessTransport)TestContextAnnotationUtils.findMergedAnnotation(testClass, AutoConfigureInProcessTransport.class);
        return new InProcessTransportContextCustomizer(annotation);
    }

    private static class InProcessTransportContextCustomizer
    implements ContextCustomizer {
        private final @Nullable AutoConfigureInProcessTransport annotation;

        InProcessTransportContextCustomizer(@Nullable AutoConfigureInProcessTransport annotation) {
            this.annotation = annotation;
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
            if (this.annotation == null || !((Boolean)context.getEnvironment().getProperty(InProcessTransportContextCustomizerFactory.ENABLED_PROPERTY, Boolean.class, (Object)true)).booleanValue()) {
                return;
            }
            TestPropertyValues.of((String[])new String[]{"spring.grpc.client.inprocess.exclusive=true", "spring.grpc.server.inprocess.exclusive=true"}).applyTo(context);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InProcessTransportContextCustomizer that = (InProcessTransportContextCustomizer)o;
            return Objects.equals(this.annotation, that.annotation);
        }

        public int hashCode() {
            return Objects.hash(this.annotation);
        }
    }
}

